/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.destroystokyo.paper.antixray.ChunkPacketInfo;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.annotation.DoNotUse;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import java.util.stream.LongStream;
import net.minecraft.core.IdMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.VarInt;
import net.minecraft.util.BitStorage;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.SimpleBitStorage;
import net.minecraft.util.ZeroBitStorage;
import net.minecraft.world.level.chunk.GlobalPalette;
import net.minecraft.world.level.chunk.HashMapPalette;
import net.minecraft.world.level.chunk.LinearPalette;
import net.minecraft.world.level.chunk.Palette;
import net.minecraft.world.level.chunk.PaletteResize;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.SingleValuePalette;
import org.jetbrains.annotations.Nullable;

public class PalettedContainer<T>
implements PaletteResize<T>,
PalettedContainerRO<T> {
    private static final int MIN_PALETTE_BITS = 0;
    private final PaletteResize<T> dummyPaletteResize = (newSize, added) -> 0;
    public final IdMap<T> registry;
    private final T @Nullable [] presetValues;
    public volatile Data<T> data;
    private final Strategy strategy;

    public void acquire() {
    }

    public void release() {
    }

    @Deprecated
    @DoNotUse
    public static <T> Codec<PalettedContainer<T>> codecRW(IdMap<T> idList, Codec<T> entryCodec, Strategy paletteProvider, T defaultValue) {
        return PalettedContainer.codecRW(idList, entryCodec, paletteProvider, defaultValue, null);
    }

    public static <T> Codec<PalettedContainer<T>> codecRW(IdMap<T> idList, Codec<T> entryCodec, Strategy paletteProvider, T defaultValue, T @Nullable [] presetValues) {
        PalettedContainerRO.Unpacker unpacker = (idListx, paletteProviderx, serialized) -> PalettedContainer.unpack(idListx, paletteProviderx, serialized, defaultValue, presetValues);
        return PalettedContainer.codec(idList, entryCodec, paletteProvider, defaultValue, unpacker);
    }

    public static <T> Codec<PalettedContainerRO<T>> codecRO(IdMap<T> idList, Codec<T> entryCodec, Strategy paletteProvider, T defaultValue) {
        PalettedContainerRO.Unpacker unpacker = (idListx, paletteProviderx, serialized) -> PalettedContainer.unpack(idListx, paletteProviderx, serialized, defaultValue, null).map(result -> result);
        return PalettedContainer.codec(idList, entryCodec, paletteProvider, defaultValue, unpacker);
    }

    private static <T, C extends PalettedContainerRO<T>> Codec<C> codec(IdMap<T> idList, Codec<T> entryCodec, Strategy provider, T defaultValue, PalettedContainerRO.Unpacker<T, C> reader) {
        return RecordCodecBuilder.create(instance -> instance.group((App)entryCodec.mapResult(ExtraCodecs.orElsePartial(defaultValue)).listOf().fieldOf("palette").forGetter(PalettedContainerRO.PackedData::paletteEntries), (App)Codec.LONG_STREAM.lenientOptionalFieldOf("data").forGetter(PalettedContainerRO.PackedData::storage)).apply((Applicative)instance, PalettedContainerRO.PackedData::new)).comapFlatMap(serialized -> reader.read(idList, provider, (PalettedContainerRO.PackedData)serialized), container -> container.pack(idList, provider));
    }

    @Deprecated
    @DoNotUse
    public PalettedContainer(IdMap<T> idList, Strategy paletteProvider, Configuration<T> dataProvider, BitStorage storage, List<T> paletteEntries) {
        this(idList, paletteProvider, dataProvider, storage, paletteEntries, null, null);
    }

    public PalettedContainer(IdMap<T> idList, Strategy paletteProvider, Configuration<T> dataProvider, BitStorage storage, List<T> paletteEntries, T defaultValue, T @Nullable [] presetValues) {
        this.presetValues = presetValues;
        this.registry = idList;
        this.strategy = paletteProvider;
        this.data = new Data<T>(dataProvider, storage, dataProvider.factory().create(dataProvider.bits(), idList, this, paletteEntries));
        if (presetValues != null && (dataProvider.factory() == Strategy.SINGLE_VALUE_PALETTE_FACTORY ? this.data.palette.valueFor(0) != defaultValue : dataProvider.factory() != Strategy.GLOBAL_PALETTE_FACTORY)) {
            int maxSize = 1 << dataProvider.bits();
            for (T presetValue : presetValues) {
                if (this.data.palette.getSize() >= maxSize) {
                    HashSet<T> allValues = new HashSet<T>(paletteEntries);
                    allValues.addAll(Arrays.asList(presetValues));
                    int newBits = Mth.ceillog2(allValues.size());
                    if (newBits <= dataProvider.bits()) break;
                    this.onResize(newBits, null);
                    break;
                }
                this.data.palette.idFor(presetValue);
            }
        }
    }

    private PalettedContainer(IdMap<T> idList, Strategy paletteProvider, Data<T> data, T @Nullable [] presetValues) {
        this.presetValues = presetValues;
        this.registry = idList;
        this.strategy = paletteProvider;
        this.data = data;
    }

    @Deprecated
    @DoNotUse
    public PalettedContainer(IdMap<T> idList, T object, Strategy paletteProvider) {
        this(idList, object, paletteProvider, null);
    }

    public PalettedContainer(IdMap<T> idList, T object, Strategy paletteProvider, T @Nullable [] presetValues) {
        this.presetValues = presetValues;
        this.strategy = paletteProvider;
        this.registry = idList;
        this.data = this.createOrReuseData(null, 0);
        this.data.palette.idFor(object);
    }

    private Data<T> createOrReuseData(@javax.annotation.Nullable Data<T> previousData, int bits) {
        Configuration<T> configuration = this.strategy.getConfiguration(this.registry, bits);
        return previousData != null && configuration.equals(previousData.configuration()) ? previousData : configuration.createData(this.registry, this, this.strategy.size());
    }

    @Override
    public synchronized int onResize(int newBits, T object) {
        Data<T> data = this.data;
        if (this.presetValues != null && object != null && data.configuration().factory() == Strategy.SINGLE_VALUE_PALETTE_FACTORY) {
            int duplicates = 0;
            List<T> presetValues = Arrays.asList(this.presetValues);
            duplicates += presetValues.contains(object) ? 1 : 0;
            newBits = Mth.ceillog2((1 << this.strategy.calculateBitsForSerialization(this.registry, 1 << newBits)) + presetValues.size() - (duplicates += presetValues.contains(data.palette.valueFor(0)) ? 1 : 0));
        }
        Data data2 = this.createOrReuseData(data, newBits);
        data2.copyFrom(data.palette, data.storage);
        this.data = data2;
        this.addPresetValues();
        return object == null ? -1 : data2.palette.idFor(object);
    }

    private void addPresetValues() {
        if (this.presetValues != null && this.data.configuration().factory() != Strategy.GLOBAL_PALETTE_FACTORY) {
            for (T presetValue : this.presetValues) {
                this.data.palette.idFor(presetValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getAndSet(int x, int y, int z, T value) {
        T var5;
        this.acquire();
        try {
            var5 = this.getAndSet(this.strategy.getIndex(x, y, z), value);
        }
        finally {
            this.release();
        }
        return var5;
    }

    public T getAndSetUnchecked(int x, int y, int z, T value) {
        return this.getAndSet(this.strategy.getIndex(x, y, z), value);
    }

    private synchronized T getAndSet(int index, T value) {
        int i = this.data.palette.idFor(value);
        int j = this.data.storage.getAndSet(index, i);
        return this.data.palette.valueFor(j);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(int x, int y, int z, T value) {
        this.acquire();
        try {
            this.set(this.strategy.getIndex(x, y, z), value);
        }
        finally {
            this.release();
        }
    }

    private synchronized void set(int index, T value) {
        int i = this.data.palette.idFor(value);
        this.data.storage.set(index, i);
    }

    @Override
    public T get(int x, int y, int z) {
        return this.get(this.strategy.getIndex(x, y, z));
    }

    public T get(int index) {
        Data<T> data = this.data;
        return data.palette.valueFor(data.storage.get(index));
    }

    @Override
    public void getAll(Consumer<T> action) {
        Palette palette = this.data.palette();
        IntArraySet intSet = new IntArraySet();
        this.data.storage.getAll(arg_0 -> ((IntSet)intSet).add(arg_0));
        intSet.forEach(id -> action.accept(palette.valueFor(id)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void read(FriendlyByteBuf buf) {
        this.acquire();
        try {
            byte i = buf.readByte();
            Data<T> data = this.createOrReuseData(this.data, i);
            data.palette.read(buf);
            buf.readLongArray(data.storage.getRaw());
            this.data = data;
            this.addPresetValues();
        }
        finally {
            this.release();
        }
    }

    @Override
    @Deprecated
    @DoNotUse
    public void write(FriendlyByteBuf buf) {
        this.write(buf, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void write(FriendlyByteBuf buf, @javax.annotation.Nullable ChunkPacketInfo<T> chunkPacketInfo, int chunkSectionIndex) {
        this.acquire();
        try {
            this.data.write(buf, chunkPacketInfo, chunkSectionIndex);
            if (chunkPacketInfo != null) {
                chunkPacketInfo.setPresetValues(chunkSectionIndex, this.presetValues);
            }
        }
        finally {
            this.release();
        }
    }

    private static <T> DataResult<PalettedContainer<T>> unpack(IdMap<T> idList, Strategy paletteProvider, PalettedContainerRO.PackedData<T> serialized, T defaultValue, T @Nullable [] presetValues) {
        BitStorage bitStorage;
        List<T> list = serialized.paletteEntries();
        int i = paletteProvider.size();
        int j = paletteProvider.calculateBitsForSerialization(idList, list.size());
        Configuration<T> configuration = paletteProvider.getConfiguration(idList, j);
        if (j == 0) {
            bitStorage = new ZeroBitStorage(i);
        } else {
            Optional<LongStream> optional = serialized.storage();
            if (optional.isEmpty()) {
                return DataResult.error(() -> "Missing values for non-zero storage");
            }
            long[] ls = optional.get().toArray();
            try {
                if (configuration.factory() == Strategy.GLOBAL_PALETTE_FACTORY) {
                    HashMapPalette<Object> palette = new HashMapPalette<Object>(idList, j, (id, value) -> 0, list);
                    SimpleBitStorage simpleBitStorage = new SimpleBitStorage(j, i, ls);
                    int[] is = new int[i];
                    simpleBitStorage.unpack(is);
                    PalettedContainer.swapPalette(is, id -> idList.getId(palette.valueFor(id)));
                    bitStorage = new SimpleBitStorage(configuration.bits(), i, is);
                } else {
                    bitStorage = new SimpleBitStorage(configuration.bits(), i, ls);
                }
            }
            catch (SimpleBitStorage.InitializationException var13) {
                return DataResult.error(() -> "Failed to read PalettedContainer: " + var13.getMessage());
            }
        }
        return DataResult.success(new PalettedContainer<T>(idList, paletteProvider, configuration, bitStorage, list, defaultValue, presetValues));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized PalettedContainerRO.PackedData<T> pack(IdMap<T> idList, Strategy paletteProvider) {
        PalettedContainerRO.PackedData<T> var12;
        this.acquire();
        try {
            Optional<LongStream> optional;
            HashMapPalette<T> hashMapPalette = new HashMapPalette<T>(idList, this.data.storage.getBits(), this.dummyPaletteResize);
            int i = paletteProvider.size();
            int[] is = new int[i];
            this.data.storage.unpack(is);
            PalettedContainer.swapPalette(is, id -> hashMapPalette.idFor(this.data.palette.valueFor(id)));
            int j = paletteProvider.calculateBitsForSerialization(idList, hashMapPalette.getSize());
            if (j != 0) {
                SimpleBitStorage simpleBitStorage = new SimpleBitStorage(j, i, is);
                optional = Optional.of(Arrays.stream(simpleBitStorage.getRaw()));
            } else {
                optional = Optional.empty();
            }
            var12 = new PalettedContainerRO.PackedData<T>(hashMapPalette.getEntries(), optional);
        }
        finally {
            this.release();
        }
        return var12;
    }

    private static <T> void swapPalette(int[] is, IntUnaryOperator applier) {
        int i = -1;
        int j = -1;
        for (int k = 0; k < is.length; ++k) {
            int l = is[k];
            if (l != i) {
                i = l;
                j = applier.applyAsInt(l);
            }
            is[k] = j;
        }
    }

    @Override
    public int getSerializedSize() {
        return this.data.getSerializedSize();
    }

    @Override
    public boolean maybeHas(Predicate<T> predicate) {
        return this.data.palette.maybeHas(predicate);
    }

    public PalettedContainer<T> copy() {
        return new PalettedContainer<T>(this.registry, this.strategy, this.data.copy(), this.presetValues);
    }

    @Override
    public PalettedContainer<T> recreate() {
        return new PalettedContainer<T>(this.registry, this.data.palette.valueFor(0), this.strategy, this.presetValues);
    }

    @Override
    public void count(CountConsumer<T> counter) {
        if (this.data.palette.getSize() == 1) {
            counter.accept(this.data.palette.valueFor(0), this.data.storage.getSize());
        } else {
            Int2IntOpenHashMap int2IntOpenHashMap = new Int2IntOpenHashMap();
            this.data.storage.getAll((int key) -> int2IntOpenHashMap.addTo(key, 1));
            int2IntOpenHashMap.int2IntEntrySet().forEach(entry -> counter.accept(this.data.palette.valueFor(entry.getIntKey()), entry.getIntValue()));
        }
    }

    public static abstract class Strategy {
        public static final Palette.Factory SINGLE_VALUE_PALETTE_FACTORY = SingleValuePalette::create;
        public static final Palette.Factory LINEAR_PALETTE_FACTORY = LinearPalette::create;
        public static final Palette.Factory HASHMAP_PALETTE_FACTORY = HashMapPalette::create;
        static final Palette.Factory GLOBAL_PALETTE_FACTORY = GlobalPalette::create;
        public static final Strategy SECTION_STATES = new Strategy(4){

            @Override
            public <A> Configuration<A> getConfiguration(IdMap<A> idList, int bits) {
                return switch (bits) {
                    case 0 -> new Configuration(SINGLE_VALUE_PALETTE_FACTORY, bits);
                    case 1, 2, 3, 4 -> new Configuration(LINEAR_PALETTE_FACTORY, 4);
                    case 5, 6, 7, 8 -> new Configuration(HASHMAP_PALETTE_FACTORY, bits);
                    default -> new Configuration(GLOBAL_PALETTE_FACTORY, Mth.ceillog2(idList.size()));
                };
            }
        };
        public static final Strategy SECTION_BIOMES = new Strategy(2){

            @Override
            public <A> Configuration<A> getConfiguration(IdMap<A> idList, int bits) {
                return switch (bits) {
                    case 0 -> new Configuration(SINGLE_VALUE_PALETTE_FACTORY, bits);
                    case 1, 2, 3 -> new Configuration(LINEAR_PALETTE_FACTORY, bits);
                    default -> new Configuration(GLOBAL_PALETTE_FACTORY, Mth.ceillog2(idList.size()));
                };
            }
        };
        private final int sizeBits;

        Strategy(int edgeBits) {
            this.sizeBits = edgeBits;
        }

        public int size() {
            return 1 << this.sizeBits * 3;
        }

        public int getIndex(int x, int y, int z) {
            return (y << this.sizeBits | z) << this.sizeBits | x;
        }

        public abstract <A> Configuration<A> getConfiguration(IdMap<A> var1, int var2);

        <A> int calculateBitsForSerialization(IdMap<A> idList, int size) {
            int i = Mth.ceillog2(size);
            Configuration<A> configuration = this.getConfiguration(idList, i);
            return configuration.factory() == GLOBAL_PALETTE_FACTORY ? i : configuration.bits();
        }
    }

    record Configuration<T>(Palette.Factory factory, int bits) {
        public Data<T> createData(IdMap<T> idList, PaletteResize<T> listener, int size) {
            BitStorage bitStorage = this.bits == 0 ? new ZeroBitStorage(size) : new SimpleBitStorage(this.bits, size);
            Palette<T> palette = this.factory.create(this.bits, idList, listener, List.of());
            return new Data<T>(this, bitStorage, palette);
        }
    }

    record Data<T>(Configuration<T> configuration, BitStorage storage, Palette<T> palette) {
        public void copyFrom(Palette<T> palette, BitStorage storage) {
            for (int i = 0; i < storage.getSize(); ++i) {
                T object = palette.valueFor(storage.get(i));
                this.storage.set(i, this.palette.idFor(object));
            }
        }

        public int getSerializedSize() {
            return 1 + this.palette.getSerializedSize() + VarInt.getByteSize(this.storage.getRaw().length) + this.storage.getRaw().length * 8;
        }

        public void write(FriendlyByteBuf buf, @javax.annotation.Nullable ChunkPacketInfo<T> chunkPacketInfo, int chunkSectionIndex) {
            buf.writeByte(this.storage.getBits());
            this.palette.write(buf);
            if (chunkPacketInfo != null) {
                chunkPacketInfo.setBits(chunkSectionIndex, this.configuration.bits());
                chunkPacketInfo.setPalette(chunkSectionIndex, this.palette);
                chunkPacketInfo.setIndex(chunkSectionIndex, buf.writerIndex() + VarInt.getByteSize(this.storage.getRaw().length));
            }
            buf.writeLongArray(this.storage.getRaw());
        }

        public Data<T> copy() {
            return new Data<T>(this.configuration, this.storage.copy(), this.palette.copy());
        }
    }

    @FunctionalInterface
    public static interface CountConsumer<T> {
        public void accept(T var1, int var2);
    }
}

