/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.carver;

import com.mojang.serialization.Codec;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.carver.CanyonCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.WorldCarver;

public class CanyonWorldCarver
extends WorldCarver<CanyonCarverConfiguration> {
    public CanyonWorldCarver(Codec<CanyonCarverConfiguration> configCodec) {
        super(configCodec);
    }

    @Override
    @Override
    public boolean isStartChunk(CanyonCarverConfiguration config, RandomSource random) {
        return random.nextFloat() <= config.probability;
    }

    @Override
    @Override
    public boolean carve(CarvingContext context, CanyonCarverConfiguration config, ChunkAccess chunk, Function<BlockPos, Holder<Biome>> posToBiome, RandomSource random, Aquifer aquiferSampler, ChunkPos pos, CarvingMask mask) {
        int i = (this.getRange() * 2 - 1) * 16;
        double d = pos.getBlockX(random.nextInt(16));
        int j = config.y.sample(random, context);
        double e = pos.getBlockZ(random.nextInt(16));
        float f = random.nextFloat() * ((float)Math.PI * 2);
        float g = config.verticalRotation.sample(random);
        double h = config.yScale.sample(random);
        float k = config.shape.thickness.sample(random);
        int l = (int)((float)i * config.shape.distanceFactor.sample(random));
        boolean m = false;
        this.doCarve(context, config, chunk, posToBiome, random.nextLong(), aquiferSampler, d, j, e, k, f, g, 0, l, h, mask);
        return true;
    }

    private void doCarve(CarvingContext context, CanyonCarverConfiguration config, ChunkAccess chunk, Function<BlockPos, Holder<Biome>> posToBiome, long seed, Aquifer aquiferSampler, double x, double y, double z, float width, float yaw, float pitch, int branchStartIndex, int branchCount, double yawPitchRatio, CarvingMask mask) {
        RandomSource randomSource = RandomSource.create(seed);
        float[] fs = this.initWidthFactors(context, config, randomSource);
        float f = 0.0f;
        float g = 0.0f;
        for (int i = branchStartIndex; i < branchCount; ++i) {
            double d = 1.5 + (double)(Mth.sin((float)i * (float)Math.PI / (float)branchCount) * width);
            double e = d * yawPitchRatio;
            d *= (double)config.shape.horizontalRadiusFactor.sample(randomSource);
            e = this.updateVerticalRadius(config, randomSource, e, branchCount, i);
            float h = Mth.cos(pitch);
            float j = Mth.sin(pitch);
            x += (double)(Mth.cos(yaw) * h);
            y += (double)j;
            z += (double)(Mth.sin(yaw) * h);
            pitch *= 0.7f;
            pitch += g * 0.05f;
            yaw += f * 0.05f;
            g *= 0.8f;
            f *= 0.5f;
            g += (randomSource.nextFloat() - randomSource.nextFloat()) * randomSource.nextFloat() * 2.0f;
            f += (randomSource.nextFloat() - randomSource.nextFloat()) * randomSource.nextFloat() * 4.0f;
            if (randomSource.nextInt(4) == 0) continue;
            if (!CanyonWorldCarver.canReach(chunk.getPos(), x, z, i, branchCount, width)) {
                return;
            }
            this.carveEllipsoid(context, config, chunk, posToBiome, aquiferSampler, x, y, z, d, e, mask, (contextx, scaledRelativeX, scaledRelativeY, scaledRelativeZ, yx) -> this.shouldSkip(contextx, fs, scaledRelativeX, scaledRelativeY, scaledRelativeZ, yx));
        }
    }

    private float[] initWidthFactors(CarvingContext context, CanyonCarverConfiguration config, RandomSource random) {
        int i = context.getGenDepth();
        float[] fs = new float[i];
        float f = 1.0f;
        for (int j = 0; j < i; ++j) {
            if (j == 0 || random.nextInt(config.shape.widthSmoothness) == 0) {
                f = 1.0f + random.nextFloat() * random.nextFloat();
            }
            fs[j] = f * f;
        }
        return fs;
    }

    private double updateVerticalRadius(CanyonCarverConfiguration config, RandomSource random, double pitch, float branchCount, float branchIndex) {
        float f = 1.0f - Mth.abs(0.5f - branchIndex / branchCount) * 2.0f;
        float g = config.shape.verticalRadiusDefaultFactor + config.shape.verticalRadiusCenterFactor * f;
        return (double)g * pitch * (double)Mth.randomBetween(random, 0.75f, 1.0f);
    }

    private boolean shouldSkip(CarvingContext context, float[] horizontalStretchFactors, double scaledRelativeX, double scaledRelativeY, double scaledRelativeZ, int y) {
        int i = y - context.getMinGenY();
        return (scaledRelativeX * scaledRelativeX + scaledRelativeZ * scaledRelativeZ) * (double)horizontalStretchFactors[i - 1] + scaledRelativeY * scaledRelativeY / 6.0 >= 1.0;
    }
}

