/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockPileConfiguration;

public class BlockPileFeature
extends Feature<BlockPileConfiguration> {
    public BlockPileFeature(Codec<BlockPileConfiguration> configCodec) {
        super(configCodec);
    }

    @Override
    @Override
    public boolean place(FeaturePlaceContext<BlockPileConfiguration> context) {
        BlockPos blockPos = context.origin();
        WorldGenLevel worldGenLevel = context.level();
        RandomSource randomSource = context.random();
        BlockPileConfiguration blockPileConfiguration = context.config();
        if (blockPos.getY() < worldGenLevel.getMinBuildHeight() + 5) {
            return false;
        }
        int i = 2 + randomSource.nextInt(2);
        int j = 2 + randomSource.nextInt(2);
        for (BlockPos blockPos2 : BlockPos.betweenClosed(blockPos.offset(-i, 0, -j), blockPos.offset(i, 1, j))) {
            int l;
            int k = blockPos.getX() - blockPos2.getX();
            if ((float)(k * k + (l = blockPos.getZ() - blockPos2.getZ()) * l) <= randomSource.nextFloat() * 10.0f - randomSource.nextFloat() * 6.0f) {
                this.tryPlaceBlock(worldGenLevel, blockPos2, randomSource, blockPileConfiguration);
                continue;
            }
            if (!((double)randomSource.nextFloat() < 0.031)) continue;
            this.tryPlaceBlock(worldGenLevel, blockPos2, randomSource, blockPileConfiguration);
        }
        return true;
    }

    private boolean mayPlaceOn(LevelAccessor world, BlockPos pos, RandomSource random) {
        BlockPos blockPos = pos.below();
        BlockState blockState = world.getBlockState(blockPos);
        if (blockState.is(Blocks.DIRT_PATH)) {
            return random.nextBoolean();
        }
        return blockState.isFaceSturdy(world, blockPos, Direction.UP);
    }

    private void tryPlaceBlock(LevelAccessor world, BlockPos pos, RandomSource random, BlockPileConfiguration config) {
        if (world.isEmptyBlock(pos) && this.mayPlaceOn(world, pos, random)) {
            world.setBlock(pos, config.stateProvider.getState(random, pos), 4);
        }
    }
}

