/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.VegetationPatchFeature;
import net.minecraft.world.level.levelgen.feature.configurations.VegetationPatchConfiguration;

public class WaterloggedVegetationPatchFeature
extends VegetationPatchFeature {
    public WaterloggedVegetationPatchFeature(Codec<VegetationPatchConfiguration> configCodec) {
        super(configCodec);
    }

    @Override
    @Override
    protected Set<BlockPos> placeGroundPatch(WorldGenLevel world, VegetationPatchConfiguration config, RandomSource random, BlockPos pos, Predicate<BlockState> replaceable, int radiusX, int radiusZ) {
        Set<BlockPos> set = super.placeGroundPatch(world, config, random, pos, replaceable, radiusX, radiusZ);
        HashSet<BlockPos> set2 = new HashSet<BlockPos>();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (BlockPos blockPos : set) {
            if (WaterloggedVegetationPatchFeature.isExposed(world, set, blockPos, mutableBlockPos)) continue;
            set2.add(blockPos);
        }
        for (BlockPos blockPos2 : set2) {
            world.setBlock(blockPos2, Blocks.WATER.defaultBlockState(), 2);
        }
        return set2;
    }

    private static boolean isExposed(WorldGenLevel world, Set<BlockPos> positions, BlockPos pos, BlockPos.MutableBlockPos mutablePos) {
        return WaterloggedVegetationPatchFeature.isExposedDirection(world, pos, mutablePos, Direction.NORTH) || WaterloggedVegetationPatchFeature.isExposedDirection(world, pos, mutablePos, Direction.EAST) || WaterloggedVegetationPatchFeature.isExposedDirection(world, pos, mutablePos, Direction.SOUTH) || WaterloggedVegetationPatchFeature.isExposedDirection(world, pos, mutablePos, Direction.WEST) || WaterloggedVegetationPatchFeature.isExposedDirection(world, pos, mutablePos, Direction.DOWN);
    }

    private static boolean isExposedDirection(WorldGenLevel world, BlockPos pos, BlockPos.MutableBlockPos mutablePos, Direction direction) {
        mutablePos.setWithOffset((Vec3i)pos, direction);
        return !world.getBlockState(mutablePos).isFaceSturdy(world, mutablePos, direction.getOpposite());
    }

    @Override
    @Override
    protected boolean placeVegetation(WorldGenLevel world, VegetationPatchConfiguration config, ChunkGenerator generator, RandomSource random, BlockPos pos) {
        if (super.placeVegetation(world, config, generator, random, pos.below())) {
            BlockState blockState = world.getBlockState(pos);
            if (blockState.hasProperty(BlockStateProperties.WATERLOGGED) && !blockState.getValue(BlockStateProperties.WATERLOGGED).booleanValue()) {
                world.setBlock(pos, (BlockState)blockState.setValue(BlockStateProperties.WATERLOGGED, true), 2);
            }
            return true;
        }
        return false;
    }
}

