/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.material;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import gg.airplane.structs.FluidDirectionCache;
import it.unimi.dsi.fastutil.shorts.Short2BooleanMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.FluidLevelChangeEvent;

public abstract class FlowingFluid
extends Fluid {
    public static final BooleanProperty FALLING = BlockStateProperties.FALLING;
    public static final IntegerProperty LEVEL = BlockStateProperties.LEVEL_FLOWING;
    private static final int CACHE_SIZE = 200;
    private static final ThreadLocal<FluidDirectionCache<Block.BlockStatePairKey>> localFluidDirectionCache = ThreadLocal.withInitial(() -> new FluidDirectionCache(2048));
    private final Map<FluidState, VoxelShape> shapes = Maps.newIdentityHashMap();

    @Override
    protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
        builder.add(FALLING);
    }

    @Override
    public Vec3 getFlow(BlockGetter world, BlockPos pos, FluidState state) {
        double d0 = 0.0;
        double d1 = 0.0;
        BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
        for (Direction enumdirection : Direction.Plane.HORIZONTAL) {
            blockposition_mutableblockposition.setWithOffset((Vec3i)pos, enumdirection);
            FluidState fluid1 = world.getFluidState(blockposition_mutableblockposition);
            if (!this.affectsFlow(fluid1)) continue;
            float f = fluid1.getOwnHeight();
            float f1 = 0.0f;
            if (f == 0.0f) {
                Vec3i blockposition1;
                FluidState fluid2;
                if (!world.getBlockState(blockposition_mutableblockposition).blocksMotion() && this.affectsFlow(fluid2 = world.getFluidState((BlockPos)(blockposition1 = blockposition_mutableblockposition.below()))) && (f = fluid2.getOwnHeight()) > 0.0f) {
                    f1 = state.getOwnHeight() - (f - 0.8888889f);
                }
            } else if (f > 0.0f) {
                f1 = state.getOwnHeight() - f;
            }
            if (f1 == 0.0f) continue;
            d0 += (double)((float)enumdirection.getStepX() * f1);
            d1 += (double)((float)enumdirection.getStepZ() * f1);
        }
        Vec3 vec3d = new Vec3(d0, 0.0, d1);
        if (state.getValue(FALLING).booleanValue()) {
            for (Direction enumdirection1 : Direction.Plane.HORIZONTAL) {
                blockposition_mutableblockposition.setWithOffset((Vec3i)pos, enumdirection1);
                if (!this.isSolidFace(world, blockposition_mutableblockposition, enumdirection1) && !this.isSolidFace(world, (BlockPos)blockposition_mutableblockposition.above(), enumdirection1)) continue;
                vec3d = vec3d.normalize().add(0.0, -6.0, 0.0);
                break;
            }
        }
        return vec3d.normalize();
    }

    private boolean affectsFlow(FluidState state) {
        return state.isEmpty() || state.getType().isSame(this);
    }

    protected boolean isSolidFace(BlockGetter world, BlockPos pos, Direction direction) {
        BlockState iblockdata = world.getBlockState(pos);
        FluidState fluid = world.getFluidState(pos);
        return fluid.getType().isSame(this) ? false : (direction == Direction.UP ? true : (iblockdata.getBlock() instanceof IceBlock ? false : iblockdata.isFaceSturdy(world, pos, direction)));
    }

    protected void spread(Level world, BlockPos fluidPos, FluidState state) {
        if (!state.isEmpty()) {
            BlockState iblockdata = world.getBlockState(fluidPos);
            BlockPos blockposition1 = fluidPos.below();
            BlockState iblockdata1 = world.getBlockState(blockposition1);
            FluidState fluid1 = this.getNewLiquid(world, blockposition1, iblockdata1);
            if (this.canSpreadTo(world, fluidPos, iblockdata, Direction.DOWN, blockposition1, iblockdata1, world.getFluidState(blockposition1), fluid1.getType())) {
                CraftBlock source = CraftBlock.at(world, fluidPos);
                BlockFromToEvent event = new BlockFromToEvent((org.bukkit.block.Block)source, BlockFace.DOWN);
                world.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                this.spreadTo(world, blockposition1, iblockdata1, Direction.DOWN, fluid1);
                if (this.sourceNeighborCount(world, fluidPos) >= 3) {
                    this.spreadToSides(world, fluidPos, state, iblockdata);
                }
            } else if (state.isSource() || !this.isWaterHole(world, fluid1.getType(), fluidPos, iblockdata, blockposition1, iblockdata1)) {
                this.spreadToSides(world, fluidPos, state, iblockdata);
            }
        }
    }

    private void spreadToSides(Level world, BlockPos pos, FluidState fluidState, BlockState blockState) {
        int i = fluidState.getAmount() - this.getDropOff(world);
        if (fluidState.getValue(FALLING).booleanValue()) {
            i = 7;
        }
        if (i > 0) {
            Map<Direction, FluidState> map = this.getSpread(world, pos, blockState);
            for (Map.Entry<Direction, FluidState> entry : map.entrySet()) {
                Direction enumdirection = entry.getKey();
                FluidState fluid1 = entry.getValue();
                BlockPos blockposition1 = pos.relative(enumdirection);
                BlockState iblockdata1 = world.getBlockStateIfLoaded(blockposition1);
                if (iblockdata1 == null || !this.canSpreadTo(world, pos, blockState, enumdirection, blockposition1, iblockdata1, world.getFluidState(blockposition1), fluid1.getType())) continue;
                CraftBlock source = CraftBlock.at(world, pos);
                BlockFromToEvent event = new BlockFromToEvent((org.bukkit.block.Block)source, CraftBlock.notchToBlockFace(enumdirection));
                world.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) continue;
                this.spreadTo(world, blockposition1, iblockdata1, enumdirection, fluid1);
            }
        }
    }

    protected FluidState getNewLiquid(Level world, BlockPos pos, BlockState state) {
        BlockPos blockposition2;
        BlockState iblockdata3;
        FluidState fluid2;
        int i = 0;
        int j = 0;
        for (Direction enumdirection : Direction.Plane.HORIZONTAL) {
            FluidState fluid;
            BlockPos blockposition1 = pos.relative(enumdirection);
            BlockState iblockdata1 = world.getBlockStateIfLoaded(blockposition1);
            if (iblockdata1 == null || !(fluid = iblockdata1.getFluidState()).getType().isSame(this) || !this.canPassThroughWall(enumdirection, world, pos, state, blockposition1, iblockdata1)) continue;
            if (fluid.isSource()) {
                ++j;
            }
            i = Math.max(i, fluid.getAmount());
        }
        if (this.canConvertToSource(world) && j >= this.getRequiredSources(world)) {
            BlockState iblockdata2 = world.getBlockState(pos.below());
            FluidState fluid1 = iblockdata2.getFluidState();
            if (iblockdata2.isSolid() || this.isSourceBlockOfThisType(fluid1)) {
                return this.getSource(false);
            }
        }
        if (!(fluid2 = (iblockdata3 = world.getBlockState(blockposition2 = pos.above())).getFluidState()).isEmpty() && fluid2.getType().isSame(this) && this.canPassThroughWall(Direction.UP, world, pos, state, blockposition2, iblockdata3)) {
            return this.getFlowing(8, true);
        }
        int k = i - this.getDropOff(world);
        return k <= 0 ? Fluids.EMPTY.defaultFluidState() : this.getFlowing(k, false);
    }

    private boolean canPassThroughWall(Direction face, BlockGetter world, BlockPos pos, BlockState state, BlockPos fromPos, BlockState fromState) {
        VoxelShape voxelshape1;
        VoxelShape voxelshape;
        boolean flag;
        Block.BlockStatePairKey block_a;
        FluidDirectionCache<Block.BlockStatePairKey> cache = null;
        if (!state.getBlock().hasDynamicShape() && !fromState.getBlock().hasDynamicShape()) {
            cache = localFluidDirectionCache.get();
        }
        if (cache != null) {
            block_a = new Block.BlockStatePairKey(state, fromState, face);
            Boolean flag2 = cache.getValue(block_a);
            if (flag2 != null) {
                return flag2;
            }
        } else {
            block_a = null;
        }
        boolean bl = flag = !Shapes.mergedFaceOccludes(voxelshape = state.getCollisionShape(world, pos), voxelshape1 = fromState.getCollisionShape(world, fromPos), face);
        if (cache != null) {
            cache.putValue(block_a, flag);
        }
        return flag;
    }

    public abstract Fluid getFlowing();

    public FluidState getFlowing(int level, boolean falling) {
        return (FluidState)((FluidState)this.getFlowing().defaultFluidState().setValue(LEVEL, level)).setValue(FALLING, falling);
    }

    public abstract Fluid getSource();

    public FluidState getSource(boolean falling) {
        return (FluidState)this.getSource().defaultFluidState().setValue(FALLING, falling);
    }

    protected abstract boolean canConvertToSource(Level var1);

    protected int getRequiredSources(Level level) {
        return 2;
    }

    protected void spreadTo(LevelAccessor world, BlockPos pos, BlockState state, Direction direction, FluidState fluidState) {
        if (state.getBlock() instanceof LiquidBlockContainer) {
            ((LiquidBlockContainer)((Object)state.getBlock())).placeLiquid(world, pos, state, fluidState);
        } else {
            if (!state.isAir()) {
                this.beforeDestroyingBlock(world, pos, state, pos.relative(direction.getOpposite()));
            }
            world.setBlock(pos, fluidState.createLegacyBlock(), 3);
        }
    }

    protected void beforeDestroyingBlock(LevelAccessor world, BlockPos pos, BlockState state, BlockPos source) {
        this.beforeDestroyingBlock(world, pos, state);
    }

    protected abstract void beforeDestroyingBlock(LevelAccessor var1, BlockPos var2, BlockState var3);

    private static short getCacheKey(BlockPos from, BlockPos to) {
        int i = to.getX() - from.getX();
        int j = to.getZ() - from.getZ();
        return (short)((i + 128 & 0xFF) << 8 | j + 128 & 0xFF);
    }

    protected int getSlopeDistance(LevelReader world, BlockPos pos, int i, Direction direction, BlockState state, BlockPos fromPos, Short2ObjectMap<Pair<BlockState, FluidState>> stateCache, Short2BooleanMap flowDownCache) {
        int j = 1000;
        for (Direction enumdirection1 : Direction.Plane.HORIZONTAL) {
            int k;
            if (enumdirection1 == direction) continue;
            BlockPos blockposition2 = pos.relative(enumdirection1);
            short short0 = FlowingFluid.getCacheKey(fromPos, blockposition2);
            Pair pair = (Pair)stateCache.get(short0);
            if (pair == null) {
                BlockState iblockdatax = world.getBlockStateIfLoaded(blockposition2);
                if (iblockdatax == null) continue;
                pair = Pair.of((Object)iblockdatax, (Object)iblockdatax.getFluidState());
                stateCache.put(short0, (Object)pair);
            }
            BlockState iblockdata1 = (BlockState)pair.getFirst();
            FluidState fluid = (FluidState)pair.getSecond();
            if (!this.canPassThrough(world, this.getFlowing(), pos, state, enumdirection1, blockposition2, iblockdata1, fluid)) continue;
            boolean flag = flowDownCache.computeIfAbsent(short0, short1 -> {
                BlockPos blockposition3 = blockposition2.below();
                BlockState iblockdata2 = world.getBlockState(blockposition3);
                return this.isWaterHole(world, this.getFlowing(), blockposition2, iblockdata1, blockposition3, iblockdata2);
            });
            if (flag) {
                return i;
            }
            if (i >= this.getSlopeFindDistance(world) || (k = this.getSlopeDistance(world, blockposition2, i + 1, enumdirection1.getOpposite(), iblockdata1, fromPos, stateCache, flowDownCache)) >= j) continue;
            j = k;
        }
        return j;
    }

    private boolean isWaterHole(BlockGetter world, Fluid fluid, BlockPos pos, BlockState state, BlockPos fromPos, BlockState fromState) {
        return !this.canPassThroughWall(Direction.DOWN, world, pos, state, fromPos, fromState) ? false : (fromState.getFluidState().getType().isSame(this) ? true : this.canHoldFluid(world, fromPos, fromState, fluid));
    }

    private boolean canPassThrough(BlockGetter world, Fluid fluid, BlockPos pos, BlockState state, Direction face, BlockPos fromPos, BlockState fromState, FluidState fluidState) {
        return !this.isSourceBlockOfThisType(fluidState) && this.canPassThroughWall(face, world, pos, state, fromPos, fromState) && this.canHoldFluid(world, fromPos, fromState, fluid);
    }

    private boolean isSourceBlockOfThisType(FluidState state) {
        return state.getType().isSame(this) && state.isSource();
    }

    protected abstract int getSlopeFindDistance(LevelReader var1);

    private int sourceNeighborCount(LevelReader world, BlockPos pos) {
        int i = 0;
        for (Direction enumdirection : Direction.Plane.HORIZONTAL) {
            BlockPos blockposition1 = pos.relative(enumdirection);
            FluidState fluid = world.getFluidState(blockposition1);
            if (!this.isSourceBlockOfThisType(fluid)) continue;
            ++i;
        }
        return i;
    }

    protected Map<Direction, FluidState> getSpread(Level world, BlockPos pos, BlockState state) {
        int i = 1000;
        EnumMap map = Maps.newEnumMap(Direction.class);
        Short2ObjectOpenHashMap short2objectmap = new Short2ObjectOpenHashMap();
        Short2BooleanOpenHashMap short2booleanopenhashmap = new Short2BooleanOpenHashMap();
        for (Direction enumdirection : Direction.Plane.HORIZONTAL) {
            BlockPos blockposition1 = pos.relative(enumdirection);
            short short0 = FlowingFluid.getCacheKey(pos, blockposition1);
            Pair pair = (Pair)short2objectmap.get(short0);
            if (pair == null) {
                BlockState iblockdatax = world.getBlockStateIfLoaded(blockposition1);
                if (iblockdatax == null) continue;
                pair = Pair.of((Object)iblockdatax, (Object)iblockdatax.getFluidState());
                short2objectmap.put(short0, (Object)pair);
            }
            BlockState iblockdata1 = (BlockState)pair.getFirst();
            FluidState fluid = (FluidState)pair.getSecond();
            FluidState fluid1 = this.getNewLiquid(world, blockposition1, iblockdata1);
            if (!this.canPassThrough(world, fluid1.getType(), pos, state, enumdirection, blockposition1, iblockdata1, fluid)) continue;
            BlockPos blockposition2 = blockposition1.below();
            boolean flag = short2booleanopenhashmap.computeIfAbsent(short0, short1 -> {
                BlockState iblockdata2 = world.getBlockState(blockposition2);
                return this.isWaterHole(world, this.getFlowing(), blockposition1, iblockdata1, blockposition2, iblockdata2);
            });
            int j = flag ? 0 : this.getSlopeDistance(world, blockposition1, 1, enumdirection.getOpposite(), iblockdata1, pos, (Short2ObjectMap<Pair<BlockState, FluidState>>)short2objectmap, (Short2BooleanMap)short2booleanopenhashmap);
            if (j < i) {
                map.clear();
            }
            if (j > i) continue;
            map.put(enumdirection, fluid1);
            i = j;
        }
        return map;
    }

    private boolean canHoldFluid(BlockGetter world, BlockPos pos, BlockState state, Fluid fluid) {
        Block block = state.getBlock();
        if (block instanceof LiquidBlockContainer) {
            LiquidBlockContainer ifluidcontainer = (LiquidBlockContainer)((Object)block);
            return ifluidcontainer.canPlaceLiquid(null, world, pos, state, fluid);
        }
        return !(block instanceof DoorBlock || state.is(BlockTags.SIGNS) || state.is(Blocks.LADDER) || state.is(Blocks.SUGAR_CANE) || state.is(Blocks.BUBBLE_COLUMN)) ? (!(state.is(Blocks.NETHER_PORTAL) || state.is(Blocks.END_PORTAL) || state.is(Blocks.END_GATEWAY) || state.is(Blocks.STRUCTURE_VOID)) ? !state.blocksMotion() : false) : false;
    }

    protected boolean canSpreadTo(BlockGetter world, BlockPos fluidPos, BlockState fluidBlockState, Direction flowDirection, BlockPos flowTo, BlockState flowToBlockState, FluidState fluidState, Fluid fluid) {
        return fluidState.canBeReplacedWith(world, flowTo, fluid, flowDirection) && this.canPassThroughWall(flowDirection, world, fluidPos, fluidBlockState, flowTo, flowToBlockState) && this.canHoldFluid(world, flowTo, flowToBlockState, fluid);
    }

    protected abstract int getDropOff(LevelReader var1);

    protected int getSpreadDelay(Level world, BlockPos pos, FluidState oldState, FluidState newState) {
        return this.getTickDelay(world);
    }

    @Override
    public void tick(Level world, BlockPos pos, FluidState state) {
        if (!state.isSource()) {
            FluidState fluid1 = this.getNewLiquid(world, pos, world.getBlockState(pos));
            int i = this.getSpreadDelay(world, pos, state, fluid1);
            if (fluid1.isEmpty()) {
                state = fluid1;
                FluidLevelChangeEvent event = CraftEventFactory.callFluidLevelChangeEvent(world, pos, Blocks.AIR.defaultBlockState());
                if (event.isCancelled()) {
                    return;
                }
                world.setBlock(pos, ((CraftBlockData)event.getNewData()).getState(), 3);
            } else if (!fluid1.equals(state)) {
                state = fluid1;
                BlockState iblockdata = fluid1.createLegacyBlock();
                FluidLevelChangeEvent event = CraftEventFactory.callFluidLevelChangeEvent(world, pos, iblockdata);
                if (event.isCancelled()) {
                    return;
                }
                world.setBlock(pos, ((CraftBlockData)event.getNewData()).getState(), 2);
                world.scheduleTick(pos, fluid1.getType(), i);
                world.updateNeighborsAt(pos, iblockdata.getBlock());
            }
        }
        this.spread(world, pos, state);
    }

    protected static int getLegacyLevel(FluidState state) {
        return state.isSource() ? 0 : 8 - Math.min(state.getAmount(), 8) + (state.getValue(FALLING) != false ? 8 : 0);
    }

    private static boolean hasSameAbove(FluidState state, BlockGetter world, BlockPos pos) {
        return state.getType().isSame(world.getFluidState(pos.above()).getType());
    }

    @Override
    public float getHeight(FluidState state, BlockGetter world, BlockPos pos) {
        return FlowingFluid.hasSameAbove(state, world, pos) ? 1.0f : state.getOwnHeight();
    }

    @Override
    public float getOwnHeight(FluidState state) {
        return (float)state.getAmount() / 9.0f;
    }

    @Override
    public abstract int getAmount(FluidState var1);

    @Override
    public VoxelShape getShape(FluidState state, BlockGetter world, BlockPos pos) {
        return state.getAmount() == 9 && FlowingFluid.hasSameAbove(state, world, pos) ? Shapes.block() : this.shapes.computeIfAbsent(state, fluid1 -> Shapes.box(0.0, 0.0, 0.0, 1.0, fluid1.getHeight(world, pos), 1.0));
    }
}

