/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.validation;

import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

public class PathAllowList
implements PathMatcher {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String COMMENT_PREFIX = "#";
    private final List<ConfigEntry> entries;
    private final Map<String, PathMatcher> compiledPaths = new ConcurrentHashMap<String, PathMatcher>();

    public PathAllowList(List<ConfigEntry> allowedEntries) {
        this.entries = allowedEntries;
    }

    public PathMatcher getForFileSystem(FileSystem fileSystem) {
        return this.compiledPaths.computeIfAbsent(fileSystem.provider().getScheme(), scheme -> {
            void list2;
            try {
                List<PathMatcher> list = this.entries.stream().map(entry -> entry.compile(fileSystem)).toList();
            }
            catch (Exception exception) {
                LOGGER.error("Failed to compile file pattern list", (Throwable)exception);
                return path -> false;
            }
            return switch (list2.size()) {
                case 0 -> path -> false;
                case 1 -> (PathMatcher)list2.get(0);
                default -> arg_0 -> PathAllowList.lambda$getForFileSystem$3((List)list2, arg_0);
            };
        });
    }

    @Override
    @Override
    public boolean matches(Path path) {
        return this.getForFileSystem(path.getFileSystem()).matches(path);
    }

    public static PathAllowList readPlain(BufferedReader reader) {
        return new PathAllowList(reader.lines().flatMap(line -> ConfigEntry.parse(line).stream()).toList());
    }

    private static /* synthetic */ boolean lambda$getForFileSystem$3(List list, Path path) {
        for (PathMatcher pathMatcher : list) {
            if (!pathMatcher.matches(path)) continue;
            return true;
        }
        return false;
    }

    public record ConfigEntry(EntryType type, String pattern) {
        public PathMatcher compile(FileSystem fileSystem) {
            return this.type().compile(fileSystem, this.pattern);
        }

        static Optional<ConfigEntry> parse(String line) {
            if (line.isBlank() || line.startsWith(PathAllowList.COMMENT_PREFIX)) {
                return Optional.empty();
            }
            if (!line.startsWith("[")) {
                return Optional.of(new ConfigEntry(EntryType.PREFIX, line));
            }
            int i = line.indexOf(93, 1);
            if (i == -1) {
                throw new IllegalArgumentException("Unterminated type in line '" + line + "'");
            }
            String string = line.substring(1, i);
            String string2 = line.substring(i + 1);
            return switch (string) {
                case "glob", "regex" -> Optional.of(new ConfigEntry(EntryType.FILESYSTEM, string + ":" + string2));
                case "prefix" -> Optional.of(new ConfigEntry(EntryType.PREFIX, string2));
                default -> throw new IllegalArgumentException("Unsupported definition type in line '" + line + "'");
            };
        }

        static ConfigEntry glob(String pattern) {
            return new ConfigEntry(EntryType.FILESYSTEM, "glob:" + pattern);
        }

        static ConfigEntry regex(String pattern) {
            return new ConfigEntry(EntryType.FILESYSTEM, "regex:" + pattern);
        }

        static ConfigEntry prefix(String prefix) {
            return new ConfigEntry(EntryType.PREFIX, prefix);
        }
    }

    @FunctionalInterface
    public static interface EntryType {
        public static final EntryType FILESYSTEM = FileSystem::getPathMatcher;
        public static final EntryType PREFIX = (fileSystem, prefix) -> path -> path.toString().startsWith(prefix);

        public PathMatcher compile(FileSystem var1, String var2);
    }
}

