/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import ca.spottedleaf.moonrise.patches.collisions.shape.CachedShapeData;
import ca.spottedleaf.moonrise.patches.collisions.shape.CollisionDiscreteVoxelShape;
import java.util.Arrays;
import net.minecraft.core.AxisCycle;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;

public abstract class DiscreteVoxelShape
implements CollisionDiscreteVoxelShape {
    private static final Direction.Axis[] AXIS_VALUES = Direction.Axis.values();
    protected final int xSize;
    protected final int ySize;
    protected final int zSize;
    private CachedShapeData cachedShapeData;

    @Override
    public final CachedShapeData moonrise$getOrCreateCachedShapeData() {
        long[] voxelSet;
        if (this.cachedShapeData != null) {
            return this.cachedShapeData;
        }
        DiscreteVoxelShape discreteVoxelShape = this;
        int sizeX = discreteVoxelShape.getXSize();
        int sizeY = discreteVoxelShape.getYSize();
        int sizeZ = discreteVoxelShape.getZSize();
        int maxIndex = sizeX * sizeY * sizeZ;
        int longsRequired = maxIndex + 63 >>> 6;
        boolean isEmpty = discreteVoxelShape.isEmpty();
        if (discreteVoxelShape instanceof BitSetDiscreteVoxelShape) {
            BitSetDiscreteVoxelShape bitsetShape = (BitSetDiscreteVoxelShape)discreteVoxelShape;
            voxelSet = bitsetShape.storage.toLongArray();
            if (voxelSet.length < longsRequired) {
                voxelSet = Arrays.copyOf(voxelSet, longsRequired);
            }
        } else {
            voxelSet = new long[longsRequired];
            if (!isEmpty) {
                int mulX = sizeZ * sizeY;
                for (int x = 0; x < sizeX; ++x) {
                    for (int y = 0; y < sizeY; ++y) {
                        for (int z = 0; z < sizeZ; ++z) {
                            if (!discreteVoxelShape.isFull(x, y, z)) continue;
                            int index = z + y * sizeZ + x * mulX;
                            int n = index >>> 6;
                            voxelSet[n] = voxelSet[n] | 1L << index;
                        }
                    }
                }
            }
        }
        boolean hasSingleAABB = sizeX == 1 && sizeY == 1 && sizeZ == 1 && !isEmpty && discreteVoxelShape.isFull(0, 0, 0);
        int minFullX = discreteVoxelShape.firstFull(Direction.Axis.X);
        int minFullY = discreteVoxelShape.firstFull(Direction.Axis.Y);
        int minFullZ = discreteVoxelShape.firstFull(Direction.Axis.Z);
        int maxFullX = discreteVoxelShape.lastFull(Direction.Axis.X);
        int maxFullY = discreteVoxelShape.lastFull(Direction.Axis.Y);
        int maxFullZ = discreteVoxelShape.lastFull(Direction.Axis.Z);
        this.cachedShapeData = new CachedShapeData(sizeX, sizeY, sizeZ, voxelSet, minFullX, minFullY, minFullZ, maxFullX, maxFullY, maxFullZ, isEmpty, hasSingleAABB);
        return this.cachedShapeData;
    }

    protected DiscreteVoxelShape(int sizeX, int sizeY, int sizeZ) {
        if (sizeX < 0 || sizeY < 0 || sizeZ < 0) {
            throw new IllegalArgumentException("Need all positive sizes: x: " + sizeX + ", y: " + sizeY + ", z: " + sizeZ);
        }
        this.xSize = sizeX;
        this.ySize = sizeY;
        this.zSize = sizeZ;
    }

    public boolean isFullWide(AxisCycle cycle, int x, int y, int z) {
        return this.isFullWide(cycle.cycle(x, y, z, Direction.Axis.X), cycle.cycle(x, y, z, Direction.Axis.Y), cycle.cycle(x, y, z, Direction.Axis.Z));
    }

    public boolean isFullWide(int x, int y, int z) {
        return x >= 0 && y >= 0 && z >= 0 && x < this.xSize && y < this.ySize && z < this.zSize && this.isFull(x, y, z);
    }

    public boolean isFull(AxisCycle cycle, int x, int y, int z) {
        return this.isFull(cycle.cycle(x, y, z, Direction.Axis.X), cycle.cycle(x, y, z, Direction.Axis.Y), cycle.cycle(x, y, z, Direction.Axis.Z));
    }

    public abstract boolean isFull(int var1, int var2, int var3);

    public abstract void fill(int var1, int var2, int var3);

    public boolean isEmpty() {
        for (Direction.Axis axis : AXIS_VALUES) {
            if (this.firstFull(axis) < this.lastFull(axis)) continue;
            return true;
        }
        return false;
    }

    public abstract int firstFull(Direction.Axis var1);

    public abstract int lastFull(Direction.Axis var1);

    public int firstFull(Direction.Axis axis, int from, int to) {
        int i = this.getSize(axis);
        if (from >= 0 && to >= 0) {
            Direction.Axis axis2 = AxisCycle.FORWARD.cycle(axis);
            Direction.Axis axis3 = AxisCycle.BACKWARD.cycle(axis);
            if (from < this.getSize(axis2) && to < this.getSize(axis3)) {
                AxisCycle axisCycle = AxisCycle.between(Direction.Axis.X, axis);
                for (int j = 0; j < i; ++j) {
                    if (!this.isFull(axisCycle, j, from, to)) continue;
                    return j;
                }
                return i;
            }
            return i;
        }
        return i;
    }

    public int lastFull(Direction.Axis axis, int from, int to) {
        if (from >= 0 && to >= 0) {
            Direction.Axis axis2 = AxisCycle.FORWARD.cycle(axis);
            Direction.Axis axis3 = AxisCycle.BACKWARD.cycle(axis);
            if (from < this.getSize(axis2) && to < this.getSize(axis3)) {
                int i = this.getSize(axis);
                AxisCycle axisCycle = AxisCycle.between(Direction.Axis.X, axis);
                for (int j = i - 1; j >= 0; --j) {
                    if (!this.isFull(axisCycle, j, from, to)) continue;
                    return j + 1;
                }
                return 0;
            }
            return 0;
        }
        return 0;
    }

    public int getSize(Direction.Axis axis) {
        return axis.choose(this.xSize, this.ySize, this.zSize);
    }

    public int getXSize() {
        return this.getSize(Direction.Axis.X);
    }

    public int getYSize() {
        return this.getSize(Direction.Axis.Y);
    }

    public int getZSize() {
        return this.getSize(Direction.Axis.Z);
    }

    public void forAllEdges(IntLineConsumer callback, boolean coalesce) {
        this.forAllAxisEdges(callback, AxisCycle.NONE, coalesce);
        this.forAllAxisEdges(callback, AxisCycle.FORWARD, coalesce);
        this.forAllAxisEdges(callback, AxisCycle.BACKWARD, coalesce);
    }

    private void forAllAxisEdges(IntLineConsumer callback, AxisCycle direction, boolean coalesce) {
        AxisCycle axisCycle = direction.inverse();
        int i = this.getSize(axisCycle.cycle(Direction.Axis.X));
        int j = this.getSize(axisCycle.cycle(Direction.Axis.Y));
        int k = this.getSize(axisCycle.cycle(Direction.Axis.Z));
        for (int l = 0; l <= i; ++l) {
            for (int m = 0; m <= j; ++m) {
                int n = -1;
                for (int o = 0; o <= k; ++o) {
                    int p = 0;
                    int q = 0;
                    for (int r = 0; r <= 1; ++r) {
                        for (int s = 0; s <= 1; ++s) {
                            if (!this.isFullWide(axisCycle, l + r - 1, m + s - 1, o)) continue;
                            ++p;
                            q ^= r ^ s;
                        }
                    }
                    if (p == 1 || p == 3 || p == 2 && !(q & true)) {
                        if (coalesce) {
                            if (n != -1) continue;
                            n = o;
                            continue;
                        }
                        callback.consume(axisCycle.cycle(l, m, o, Direction.Axis.X), axisCycle.cycle(l, m, o, Direction.Axis.Y), axisCycle.cycle(l, m, o, Direction.Axis.Z), axisCycle.cycle(l, m, o + 1, Direction.Axis.X), axisCycle.cycle(l, m, o + 1, Direction.Axis.Y), axisCycle.cycle(l, m, o + 1, Direction.Axis.Z));
                        continue;
                    }
                    if (n == -1) continue;
                    callback.consume(axisCycle.cycle(l, m, n, Direction.Axis.X), axisCycle.cycle(l, m, n, Direction.Axis.Y), axisCycle.cycle(l, m, n, Direction.Axis.Z), axisCycle.cycle(l, m, o, Direction.Axis.X), axisCycle.cycle(l, m, o, Direction.Axis.Y), axisCycle.cycle(l, m, o, Direction.Axis.Z));
                    n = -1;
                }
            }
        }
    }

    public void forAllBoxes(IntLineConsumer consumer, boolean coalesce) {
        BitSetDiscreteVoxelShape.forAllBoxes(this, consumer, coalesce);
    }

    public void forAllFaces(IntFaceConsumer consumer) {
        this.forAllAxisFaces(consumer, AxisCycle.NONE);
        this.forAllAxisFaces(consumer, AxisCycle.FORWARD);
        this.forAllAxisFaces(consumer, AxisCycle.BACKWARD);
    }

    private void forAllAxisFaces(IntFaceConsumer consumer, AxisCycle direction) {
        AxisCycle axisCycle = direction.inverse();
        Direction.Axis axis = axisCycle.cycle(Direction.Axis.Z);
        int i = this.getSize(axisCycle.cycle(Direction.Axis.X));
        int j = this.getSize(axisCycle.cycle(Direction.Axis.Y));
        int k = this.getSize(axis);
        Direction direction2 = Direction.fromAxisAndDirection(axis, Direction.AxisDirection.NEGATIVE);
        Direction direction3 = Direction.fromAxisAndDirection(axis, Direction.AxisDirection.POSITIVE);
        for (int l = 0; l < i; ++l) {
            for (int m = 0; m < j; ++m) {
                boolean bl = false;
                for (int n = 0; n <= k; ++n) {
                    boolean bl2;
                    boolean bl3 = bl2 = n != k && this.isFull(axisCycle, l, m, n);
                    if (!bl && bl2) {
                        consumer.consume(direction2, axisCycle.cycle(l, m, n, Direction.Axis.X), axisCycle.cycle(l, m, n, Direction.Axis.Y), axisCycle.cycle(l, m, n, Direction.Axis.Z));
                    }
                    if (bl && !bl2) {
                        consumer.consume(direction3, axisCycle.cycle(l, m, n - 1, Direction.Axis.X), axisCycle.cycle(l, m, n - 1, Direction.Axis.Y), axisCycle.cycle(l, m, n - 1, Direction.Axis.Z));
                    }
                    bl = bl2;
                }
            }
        }
    }

    public static interface IntLineConsumer {
        public void consume(int var1, int var2, int var3, int var4, int var5, int var6);
    }

    public static interface IntFaceConsumer {
        public void consume(Direction var1, int var2, int var3, int var4);
    }
}

