/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EntityCollisionContext
implements CollisionContext {
    protected static final CollisionContext EMPTY = new EntityCollisionContext(false, -1.7976931348623157E308, ItemStack.EMPTY, fluidState -> false, null){

        @Override
        public boolean isAbove(VoxelShape shape, BlockPos pos, boolean defaultValue) {
            return defaultValue;
        }
    };
    @Nullable
    private final Entity entity;

    protected EntityCollisionContext(boolean descending, double minY, ItemStack heldItem, Predicate<FluidState> walkOnFluidPredicate, @Nullable Entity entity) {
        this.entity = entity;
    }

    @Deprecated
    protected EntityCollisionContext(Entity entity) {
        this.entity = entity;
    }

    @Override
    public boolean isHoldingItem(Item item) {
        Entity entity = this.entity;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity.getMainHandItem().is(item);
        }
        return ItemStack.EMPTY.is(item);
    }

    @Override
    public boolean canStandOnFluid(FluidState stateAbove, FluidState state) {
        Entity entity = this.entity;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity.canStandOnFluid(state) && !stateAbove.getType().isSame(state.getType());
        }
        return false;
    }

    @Override
    public boolean isDescending() {
        return this.entity != null && this.entity.isDescending();
    }

    @Override
    public boolean isAbove(VoxelShape shape, BlockPos pos, boolean defaultValue) {
        return (this.entity == null ? -1.7976931348623157E308 : this.entity.getY()) > (double)pos.getY() + shape.max(Direction.Axis.Y) - (double)1.0E-5f;
    }

    @Nullable
    public Entity getEntity() {
        return this.entity;
    }
}

