/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import io.papermc.paper.persistence.PaperPersistentDataContainerView;
import io.papermc.paper.persistence.PersistentDataContainerView;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.inventory.CraftItemFactory;
import org.bukkit.craftbukkit.inventory.CraftItemType;
import org.bukkit.craftbukkit.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.util.CraftMagicNumbers;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.meta.BlockDataMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.Repairable;
import org.bukkit.material.MaterialData;

@DelegateDeserialization(value=ItemStack.class)
public final class CraftItemStack
extends ItemStack {
    private static final VarHandle API_ITEM_STACK_CRAFT_DELEGATE_FIELD;
    public net.minecraft.world.item.ItemStack handle;
    private boolean isForInventoryDrop;
    private static final CraftPersistentDataTypeRegistry REGISTRY;
    private final PaperPersistentDataContainerView pdcView = new PaperPersistentDataContainerView(REGISTRY){

        @Override
        public CompoundTag toTagCompound() {
            return CraftItemStack.this.getPdcTag();
        }

        @Override
        public Tag getTag(String key) {
            return CraftItemStack.this.getPdcTag().get(key);
        }
    };

    private static CraftItemStack getCraftStack(ItemStack bukkit) {
        if (bukkit instanceof CraftItemStack) {
            CraftItemStack craftItemStack = (CraftItemStack)bukkit;
            return craftItemStack;
        }
        return API_ITEM_STACK_CRAFT_DELEGATE_FIELD.get(bukkit);
    }

    public int hashCode() {
        if (this.handle == null || this.handle.isEmpty()) {
            return net.minecraft.world.item.ItemStack.EMPTY.hashCode();
        }
        int hash = net.minecraft.world.item.ItemStack.hashItemAndComponents(this.handle);
        hash = hash * 31 + this.handle.getCount();
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ItemStack)) {
            return false;
        }
        ItemStack bukkit = (ItemStack)obj;
        CraftItemStack craftStack = CraftItemStack.getCraftStack(bukkit);
        if (this.handle == craftStack.handle) {
            return true;
        }
        if (this.handle == null || craftStack.handle == null) {
            return false;
        }
        if (this.handle.isEmpty() && craftStack.handle.isEmpty()) {
            return true;
        }
        return net.minecraft.world.item.ItemStack.matches(this.handle, craftStack.handle);
    }

    public static net.minecraft.world.item.ItemStack unwrap(ItemStack bukkit) {
        CraftItemStack craftItemStack = CraftItemStack.getCraftStack(bukkit);
        return craftItemStack.handle == null ? net.minecraft.world.item.ItemStack.EMPTY : craftItemStack.handle;
    }

    public static net.minecraft.world.item.ItemStack getOrCloneOnMutation(ItemStack old, ItemStack newInstance) {
        return old == newInstance ? CraftItemStack.unwrap(old) : CraftItemStack.asNMSCopy(newInstance);
    }

    public boolean isEmpty() {
        return this.handle == null || this.handle.isEmpty();
    }

    public static net.minecraft.world.item.ItemStack asNMSCopy(ItemStack original) {
        if (original == null || original.isEmpty()) {
            return net.minecraft.world.item.ItemStack.EMPTY;
        }
        CraftItemStack stack = CraftItemStack.getCraftStack(original);
        return stack.handle == null ? net.minecraft.world.item.ItemStack.EMPTY : stack.handle.copy();
    }

    public static List<net.minecraft.world.item.ItemStack> asNMSCopy(List<? extends ItemStack> originals) {
        ArrayList<net.minecraft.world.item.ItemStack> items = new ArrayList<net.minecraft.world.item.ItemStack>(originals.size());
        for (ItemStack itemStack : originals) {
            items.add(CraftItemStack.asNMSCopy(itemStack));
        }
        return items;
    }

    public static net.minecraft.world.item.ItemStack copyNMSStack(net.minecraft.world.item.ItemStack original, int amount) {
        net.minecraft.world.item.ItemStack stack = original.copy();
        stack.setCount(amount);
        return stack;
    }

    public static ItemStack asBukkitCopy(net.minecraft.world.item.ItemStack original) {
        return CraftItemStack.asCraftMirror(original.copy());
    }

    public static CraftItemStack asCraftMirror(net.minecraft.world.item.ItemStack original) {
        return new CraftItemStack(original == null || original.isEmpty() ? null : original);
    }

    public static CraftItemStack asCraftCopy(ItemStack original) {
        if (original instanceof CraftItemStack) {
            CraftItemStack stack = (CraftItemStack)original;
            return new CraftItemStack(stack.handle == null ? null : stack.handle.copy());
        }
        return new CraftItemStack(original);
    }

    public static CraftItemStack asNewCraftStack(Item item) {
        return CraftItemStack.asNewCraftStack(item, 1);
    }

    public static CraftItemStack asNewCraftStack(Item item, int amount) {
        return new CraftItemStack(CraftItemType.minecraftToBukkit(item), amount, 0, null);
    }

    private CraftItemStack(net.minecraft.world.item.ItemStack item) {
        this.handle = item;
    }

    private CraftItemStack(ItemStack item) {
        this(item.getType(), item.getAmount(), item.getDurability(), item.hasItemMeta() ? item.getItemMeta() : null);
    }

    private CraftItemStack(Material type, int amount, short durability, ItemMeta itemMeta) {
        this.setType(type);
        this.setAmount(amount);
        this.setDurability(durability);
        this.setItemMeta(itemMeta);
    }

    public MaterialData getData() {
        return this.handle != null ? CraftMagicNumbers.getMaterialData(this.handle.getItem()) : super.getData();
    }

    public Material getType() {
        return this.handle != null ? CraftItemType.minecraftToBukkit(this.handle.getItem()) : Material.AIR;
    }

    public void setType(Material type) {
        if (this.getType() == type) {
            return;
        }
        if (type == Material.AIR) {
            this.handle = null;
        } else if (CraftItemType.bukkitToMinecraft(type) == null) {
            this.handle = null;
        } else if (this.handle == null) {
            this.handle = new net.minecraft.world.item.ItemStack(CraftItemType.bukkitToMinecraft(type), 1);
        } else {
            Material oldType = CraftMagicNumbers.getMaterial(this.handle.getItem());
            this.handle.setItem(CraftItemType.bukkitToMinecraft(type));
            if (this.hasItemMeta()) {
                this.adjustTagForItemMeta(oldType);
            }
        }
        this.setData(null);
    }

    public int getAmount() {
        return this.handle != null ? this.handle.getCount() : 0;
    }

    public void setAmount(int amount) {
        if (this.handle == null) {
            return;
        }
        this.handle.setCount(amount);
    }

    public void setDurability(short durability) {
        if (this.handle != null) {
            this.handle.setDamageValue(durability);
        }
    }

    public short getDurability() {
        if (this.handle != null) {
            return (short)this.handle.getDamageValue();
        }
        return -1;
    }

    public int getMaxStackSize() {
        return this.handle == null ? Material.AIR.getMaxStackSize() : this.handle.getMaxStackSize();
    }

    public int getMaxItemUseDuration(LivingEntity entity) {
        if (this.handle == null) {
            return 0;
        }
        if (entity == null && this.handle.is(Items.CROSSBOW)) {
            throw new UnsupportedOperationException("This item requires an entity to determine the max use duration");
        }
        return this.handle.getUseDuration(entity != null ? ((CraftLivingEntity)entity).getHandle() : null);
    }

    public void addUnsafeEnchantment(Enchantment ench, int level) {
        Preconditions.checkArgument((ench != null ? 1 : 0) != 0, (Object)"Enchantment cannot be null");
        ItemMeta itemMeta = this.getItemMeta();
        if (itemMeta != null) {
            itemMeta.addEnchant(ench, level, true);
            this.setItemMeta(itemMeta);
        }
    }

    static boolean makeTag(net.minecraft.world.item.ItemStack item) {
        return item != null;
    }

    public boolean containsEnchantment(Enchantment ench) {
        return this.getEnchantmentLevel(ench) > 0;
    }

    public int getEnchantmentLevel(Enchantment ench) {
        Preconditions.checkArgument((ench != null ? 1 : 0) != 0, (Object)"Enchantment cannot be null");
        if (this.handle == null) {
            return 0;
        }
        return EnchantmentHelper.getItemEnchantmentLevel(CraftEnchantment.bukkitToMinecraftHolder(ench), this.handle);
    }

    public int removeEnchantment(Enchantment ench) {
        Preconditions.checkArgument((ench != null ? 1 : 0) != 0, (Object)"Enchantment cannot be null");
        int level = this.getEnchantmentLevel(ench);
        if (level > 0) {
            ItemMeta itemMeta = this.getItemMeta();
            if (itemMeta == null) {
                return 0;
            }
            itemMeta.removeEnchant(ench);
            this.setItemMeta(itemMeta);
        }
        return level;
    }

    public void removeEnchantments() {
        if (this.handle != null) {
            this.handle.set(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY);
        }
    }

    public Map<Enchantment, Integer> getEnchantments() {
        return this.hasItemMeta() ? this.getItemMeta().getEnchants() : ImmutableMap.of();
    }

    static Map<Enchantment, Integer> getEnchantments(net.minecraft.world.item.ItemStack item) {
        ItemEnchantments list;
        ItemEnchantments itemEnchantments = list = item != null && item.isEnchanted() ? item.get(DataComponents.ENCHANTMENTS) : null;
        if (list == null || list.size() == 0) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder result = ImmutableMap.builder();
        list.entrySet().forEach(entry -> {
            Holder id = (Holder)entry.getKey();
            int level = entry.getIntValue();
            Enchantment enchant = CraftEnchantment.minecraftHolderToBukkit(id);
            if (enchant != null) {
                result.put((Object)enchant, (Object)level);
            }
        });
        return result.build();
    }

    static ItemEnchantments getEnchantmentList(net.minecraft.world.item.ItemStack item) {
        return item != null && item.isEnchanted() ? item.get(DataComponents.ENCHANTMENTS) : null;
    }

    public CraftItemStack clone() {
        return new CraftItemStack(this.handle != null ? this.handle.copy() : null);
    }

    public ItemMeta getItemMeta() {
        return CraftItemStack.getItemMeta(this.handle);
    }

    public void adjustTagForItemMeta(Material oldType) {
        ItemMeta newMeta;
        CraftMetaItem oldMeta = (CraftMetaItem)CraftItemFactory.instance().getItemMeta(oldType);
        if (oldMeta == null) {
            newMeta = CraftItemStack.getItemMeta(this.handle);
        } else {
            HashSet extraHandledDcts = new HashSet(CraftMetaItem.getTopLevelHandledDcts(oldMeta.getClass()));
            newMeta = CraftItemStack.getItemMeta(this.handle, CraftItemType.minecraftToBukkitNew(this.handle.getItem()), extraHandledDcts);
        }
        this.setItemMeta(newMeta);
    }

    public static void applyMetaToItem(final net.minecraft.world.item.ItemStack itemStack, ItemMeta itemMeta) {
        CraftMetaItem.Applicator tag = new CraftMetaItem.Applicator(){

            @Override
            void skullCallback(ResolvableProfile profile) {
                itemStack.set(DataComponents.PROFILE, profile);
            }
        };
        ((CraftMetaItem)itemMeta).applyToItem(tag);
        itemStack.applyComponents(tag.build());
    }

    public static ItemMeta getItemMeta(net.minecraft.world.item.ItemStack item) {
        return CraftItemStack.getItemMeta(item, null);
    }

    public static ItemMeta getItemMeta(net.minecraft.world.item.ItemStack item, ItemType metaForType) {
        return CraftItemStack.getItemMeta(item, metaForType, null);
    }

    public static ItemMeta getItemMeta(net.minecraft.world.item.ItemStack item, ItemType metaForType, Set<DataComponentType<?>> extraHandledDcts) {
        if (!CraftItemStack.hasItemMeta(item)) {
            return CraftItemFactory.instance().getItemMeta(CraftItemStack.getType(item));
        }
        if (metaForType != null) {
            return ((CraftItemType)metaForType).getItemMeta(item, extraHandledDcts);
        }
        return ((CraftItemType)CraftItemType.minecraftToBukkitNew(item.getItem())).getItemMeta(item, extraHandledDcts);
    }

    static Material getType(net.minecraft.world.item.ItemStack item) {
        return item == null ? Material.AIR : CraftItemType.minecraftToBukkit(item.getItem());
    }

    public boolean setItemMeta(ItemMeta itemMeta) {
        return CraftItemStack.setItemMeta(this.handle, itemMeta);
    }

    public static boolean setItemMeta(final net.minecraft.world.item.ItemStack item, ItemMeta itemMeta) {
        if (item == null) {
            return false;
        }
        if (CraftItemFactory.instance().equals(itemMeta, null)) {
            item.restorePatch(DataComponentPatch.EMPTY);
            return true;
        }
        if (!CraftItemFactory.instance().isApplicable(itemMeta, CraftItemStack.getType(item))) {
            return false;
        }
        itemMeta = CraftItemFactory.instance().asMetaFor(itemMeta, CraftItemStack.getType(item));
        if (itemMeta == null) {
            return true;
        }
        if (!((CraftMetaItem)itemMeta).isEmpty()) {
            CraftMetaItem.Applicator tag = new CraftMetaItem.Applicator(){

                @Override
                void skullCallback(ResolvableProfile resolvableProfile) {
                    item.set(DataComponents.PROFILE, resolvableProfile);
                }
            };
            ((CraftMetaItem)itemMeta).applyToItem(tag);
            item.restorePatch(DataComponentPatch.EMPTY);
            item.applyComponents(tag.build());
        }
        return true;
    }

    public boolean isSimilar(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack == this) {
            return true;
        }
        CraftItemStack that = CraftItemStack.getCraftStack(stack);
        if (this.handle == that.handle) {
            return true;
        }
        if (this.handle == null || that.handle == null) {
            return false;
        }
        return net.minecraft.world.item.ItemStack.isSameItemSameComponents(this.handle, that.handle);
    }

    public boolean hasItemMeta() {
        return CraftItemStack.hasItemMeta(this.handle) && !CraftItemFactory.instance().equals(this.getItemMeta(), null);
    }

    static boolean hasItemMeta(net.minecraft.world.item.ItemStack item) {
        return item != null && !item.getComponentsPatch().isEmpty();
    }

    public ItemStack withType(Material type) {
        if (type == Material.AIR) {
            return CraftItemStack.asCraftMirror(null);
        }
        net.minecraft.world.item.ItemStack copy = new net.minecraft.world.item.ItemStack(CraftItemType.bukkitToMinecraft(type), this.getAmount());
        if (this.handle != null) {
            copy.applyComponents(this.handle.getComponentsPatch());
        }
        CraftItemStack mirrored = CraftItemStack.asCraftMirror(copy);
        mirrored.setItemMeta(mirrored.getItemMeta());
        return mirrored;
    }

    private CompoundTag getPdcTag() {
        if (this.handle == null) {
            return new CompoundTag();
        }
        CustomData customData = this.handle.getOrDefault(DataComponents.CUSTOM_DATA, CustomData.EMPTY);
        return customData.getUnsafe().getCompound("PublicBukkitValues");
    }

    public PersistentDataContainerView getPersistentDataContainer() {
        return this.pdcView;
    }

    public String getDisplayName() {
        return this.getItemMeta().getDisplayName();
    }

    public void setDisplayName(String name) {
        ItemMeta itemMeta = this.getItemMeta();
        itemMeta.setDisplayName(name);
        this.setItemMeta(itemMeta);
    }

    public boolean hasDisplayName() {
        return this.hasItemMeta() && this.getItemMeta().hasDisplayName();
    }

    public String getLocalizedName() {
        return this.getItemMeta().getLocalizedName();
    }

    public void setLocalizedName(String name) {
        ItemMeta itemMeta = this.getItemMeta();
        itemMeta.setLocalizedName(name);
        this.setItemMeta(itemMeta);
    }

    public boolean hasLocalizedName() {
        return this.hasItemMeta() && this.getItemMeta().hasLocalizedName();
    }

    public boolean hasLore() {
        return this.hasItemMeta() && this.getItemMeta().hasLore();
    }

    public boolean hasEnchant(Enchantment ench) {
        return this.hasItemMeta() && this.getItemMeta().hasEnchant(ench);
    }

    public int getEnchantLevel(Enchantment ench) {
        return this.getItemMeta().getEnchantLevel(ench);
    }

    public Map<Enchantment, Integer> getEnchants() {
        return this.getItemMeta().getEnchants();
    }

    public boolean addEnchant(Enchantment ench, int level, boolean ignoreLevelRestriction) {
        ItemMeta itemMeta = this.getItemMeta();
        boolean result = itemMeta.addEnchant(ench, level, ignoreLevelRestriction);
        this.setItemMeta(itemMeta);
        return result;
    }

    public boolean removeEnchant(Enchantment ench) {
        ItemMeta itemMeta = this.getItemMeta();
        boolean result = itemMeta.removeEnchant(ench);
        this.setItemMeta(itemMeta);
        return result;
    }

    public boolean hasEnchants() {
        return this.hasItemMeta() && this.getItemMeta().hasEnchants();
    }

    public boolean hasConflictingEnchant(Enchantment ench) {
        return this.hasItemMeta() && this.getItemMeta().hasConflictingEnchant(ench);
    }

    public void setCustomModelData(Integer data) {
        ItemMeta itemMeta = this.getItemMeta();
        itemMeta.setCustomModelData(data);
        this.setItemMeta(itemMeta);
    }

    public int getCustomModelData() {
        return this.getItemMeta().getCustomModelData();
    }

    public boolean hasCustomModelData() {
        return this.hasItemMeta() && this.getItemMeta().hasCustomModelData();
    }

    public boolean hasBlockData() {
        return this.hasItemMeta() && ((BlockDataMeta)this.getItemMeta()).hasBlockData();
    }

    public BlockData getBlockData(Material material) {
        return ((BlockDataMeta)this.getItemMeta()).getBlockData(material);
    }

    public void setBlockData(BlockData blockData) {
        ItemMeta itemMeta = this.getItemMeta();
        ((BlockDataMeta)itemMeta).setBlockData(blockData);
        this.setItemMeta(itemMeta);
    }

    public int getRepairCost() {
        return ((Repairable)this.getItemMeta()).getRepairCost();
    }

    public void setRepairCost(int cost) {
        ItemMeta itemMeta = this.getItemMeta();
        ((Repairable)itemMeta).setRepairCost(cost);
        this.setItemMeta(itemMeta);
    }

    public boolean hasRepairCost() {
        return this.hasItemMeta() && ((Repairable)this.getItemMeta()).hasRepairCost();
    }

    public boolean isUnbreakable() {
        return this.hasItemMeta() && this.getItemMeta().isUnbreakable();
    }

    public void setUnbreakable(boolean unbreakable) {
        ItemMeta itemMeta = this.getItemMeta();
        itemMeta.setUnbreakable(unbreakable);
        this.setItemMeta(itemMeta);
    }

    public boolean hasAttributeModifiers() {
        return this.hasItemMeta() && this.getItemMeta().hasAttributeModifiers();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers() {
        return this.getItemMeta().getAttributeModifiers();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot) {
        return this.getItemMeta().getAttributeModifiers(slot);
    }

    public Collection<AttributeModifier> getAttributeModifiers(Attribute attribute) {
        return this.getItemMeta().getAttributeModifiers(attribute);
    }

    public boolean addAttributeModifier(Attribute attribute, AttributeModifier modifier) {
        ItemMeta itemMeta = this.getItemMeta();
        boolean result = itemMeta.addAttributeModifier(attribute, modifier);
        this.setItemMeta(itemMeta);
        return result;
    }

    public void setAttributeModifiers(Multimap<Attribute, AttributeModifier> attributeModifiers) {
        ItemMeta itemMeta = this.getItemMeta();
        itemMeta.setAttributeModifiers(attributeModifiers);
        this.setItemMeta(itemMeta);
    }

    public boolean removeAttributeModifier(Attribute attribute) {
        ItemMeta itemMeta = this.getItemMeta();
        boolean result = itemMeta.removeAttributeModifier(attribute);
        this.setItemMeta(itemMeta);
        return result;
    }

    public boolean removeAttributeModifier(EquipmentSlot slot) {
        ItemMeta itemMeta = this.getItemMeta();
        boolean result = itemMeta.removeAttributeModifier(slot);
        this.setItemMeta(itemMeta);
        return result;
    }

    public boolean removeAttributeModifier(Attribute attribute, AttributeModifier modifier) {
        ItemMeta itemMeta = this.getItemMeta();
        boolean result = itemMeta.removeAttributeModifier(attribute, modifier);
        this.setItemMeta(itemMeta);
        return result;
    }

    public boolean hasDamage() {
        return this.hasItemMeta() && ((Damageable)this.getItemMeta()).hasDamage();
    }

    public int getDamage() {
        return ((Damageable)this.getItemMeta()).getDamage();
    }

    public void setDamage(int damage) {
        ItemMeta itemMeta = this.getItemMeta();
        ((Damageable)itemMeta).setDamage(damage);
        this.setItemMeta(itemMeta);
    }

    public void repair() {
        this.repair(1);
    }

    public boolean damage() {
        return this.damage(1);
    }

    public void repair(int amount) {
        this.damage(-amount);
    }

    public boolean damage(int amount) {
        return this.damage(amount, false);
    }

    public boolean damage(int amount, boolean ignoreUnbreaking) {
        Damageable damageable = (Damageable)this.getItemMeta();
        if (amount > 0) {
            int unbreaking = this.getEnchantLevel(Enchantment.UNBREAKING);
            int reduce = 0;
            for (int i = 0; unbreaking > 0 && i < amount; ++i) {
                if (!this.reduceDamage(ThreadLocalRandom.current(), unbreaking)) continue;
                ++reduce;
            }
            if ((amount -= reduce) <= 0) {
                return this.isBroke(damageable.getDamage());
            }
        }
        int damage = damageable.getDamage() + amount;
        damageable.setDamage(damage);
        this.setItemMeta((ItemMeta)damageable);
        return this.isBroke(damage);
    }

    private boolean isBroke(int damage) {
        if (damage > this.getType().getMaxDurability()) {
            if (this.getAmount() > 0) {
                this.setAmount(0);
            }
            return true;
        }
        return false;
    }

    private boolean reduceDamage(Random random, int unbreaking) {
        if (this.getType().isArmor()) {
            return random.nextFloat() < 0.6f;
        }
        return random.nextInt(unbreaking + 1) > 0;
    }

    static {
        try {
            API_ITEM_STACK_CRAFT_DELEGATE_FIELD = MethodHandles.privateLookupIn(ItemStack.class, MethodHandles.lookup()).findVarHandle(ItemStack.class, "craftDelegate", ItemStack.class);
        }
        catch (IllegalAccessException | NoSuchFieldException exception) {
            throw new RuntimeException(exception);
        }
        REGISTRY = new CraftPersistentDataTypeRegistry();
    }
}

