/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory.util;

import net.minecraft.network.chat.Component;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.CartographyTableMenu;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.inventory.GrindstoneMenu;
import net.minecraft.world.inventory.SmithingMenu;
import net.minecraft.world.inventory.StonecutterMenu;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.BlastFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.entity.SmokerBlockEntity;
import org.bukkit.craftbukkit.inventory.CraftMenuType;
import org.bukkit.craftbukkit.inventory.util.CraftMenuBuilder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.MenuType;
import org.bukkit.inventory.view.AnvilView;
import org.bukkit.inventory.view.BeaconView;
import org.bukkit.inventory.view.BrewingStandView;
import org.bukkit.inventory.view.CrafterView;
import org.bukkit.inventory.view.EnchantmentView;
import org.bukkit.inventory.view.FurnaceView;
import org.bukkit.inventory.view.LecternView;
import org.bukkit.inventory.view.LoomView;
import org.bukkit.inventory.view.MerchantView;
import org.bukkit.inventory.view.StonecutterView;

public final class CraftMenus {
    private static final CraftMenuBuilder STANDARD = (player, menuType) -> menuType.create(player.nextContainerCounter(), player.getInventory());

    public static <V extends InventoryView> MenuTypeData<V> getMenuTypeData(CraftMenuType<?> menuType) {
        if (menuType == MenuType.GENERIC_3X3) {
            return CraftMenus.asType(new MenuTypeData<InventoryView>(InventoryView.class, CraftMenuBuilder.tileEntity(DispenserBlockEntity::new, Blocks.DISPENSER)));
        }
        if (menuType == MenuType.CRAFTER_3X3) {
            return CraftMenus.asType(new MenuTypeData<CrafterView>(CrafterView.class, CraftMenuBuilder.tileEntity(CrafterBlockEntity::new, Blocks.CRAFTER)));
        }
        if (menuType == MenuType.ANVIL) {
            return CraftMenus.asType(new MenuTypeData<AnvilView>(AnvilView.class, CraftMenuBuilder.worldAccess(AnvilMenu::new)));
        }
        if (menuType == MenuType.BEACON) {
            return CraftMenus.asType(new MenuTypeData<BeaconView>(BeaconView.class, CraftMenuBuilder.tileEntity(BeaconBlockEntity::new, Blocks.BEACON)));
        }
        if (menuType == MenuType.BLAST_FURNACE) {
            return CraftMenus.asType(new MenuTypeData<FurnaceView>(FurnaceView.class, CraftMenuBuilder.tileEntity(BlastFurnaceBlockEntity::new, Blocks.BLAST_FURNACE)));
        }
        if (menuType == MenuType.BREWING_STAND) {
            return CraftMenus.asType(new MenuTypeData<BrewingStandView>(BrewingStandView.class, CraftMenuBuilder.tileEntity(BrewingStandBlockEntity::new, Blocks.BREWING_STAND)));
        }
        if (menuType == MenuType.CRAFTING) {
            return CraftMenus.asType(new MenuTypeData<InventoryView>(InventoryView.class, CraftMenuBuilder.worldAccess(CraftingMenu::new)));
        }
        if (menuType == MenuType.ENCHANTMENT) {
            return CraftMenus.asType(new MenuTypeData<EnchantmentView>(EnchantmentView.class, (player, type) -> new SimpleMenuProvider((syncId, inventory, human) -> CraftMenuBuilder.worldAccess(EnchantmentMenu::new).build(player, type), Component.empty()).createMenu(player.nextContainerCounter(), player.getInventory(), player)));
        }
        if (menuType == MenuType.FURNACE) {
            return CraftMenus.asType(new MenuTypeData<FurnaceView>(FurnaceView.class, CraftMenuBuilder.tileEntity(FurnaceBlockEntity::new, Blocks.FURNACE)));
        }
        if (menuType == MenuType.GRINDSTONE) {
            return CraftMenus.asType(new MenuTypeData<InventoryView>(InventoryView.class, CraftMenuBuilder.worldAccess(GrindstoneMenu::new)));
        }
        if (menuType == MenuType.HOPPER) {
            return CraftMenus.asType(new MenuTypeData<InventoryView>(InventoryView.class, CraftMenuBuilder.tileEntity(HopperBlockEntity::new, Blocks.HOPPER)));
        }
        if (menuType == MenuType.LECTERN) {
            return CraftMenus.asType(new MenuTypeData<LecternView>(LecternView.class, CraftMenuBuilder.tileEntity(LecternBlockEntity::new, Blocks.LECTERN)));
        }
        if (menuType == MenuType.LOOM) {
            return CraftMenus.asType(new MenuTypeData<LoomView>(LoomView.class, STANDARD));
        }
        if (menuType == MenuType.MERCHANT) {
            return CraftMenus.asType(new MenuTypeData<MerchantView>(MerchantView.class, STANDARD));
        }
        if (menuType == MenuType.SMITHING) {
            return CraftMenus.asType(new MenuTypeData<InventoryView>(InventoryView.class, CraftMenuBuilder.worldAccess(SmithingMenu::new)));
        }
        if (menuType == MenuType.SMOKER) {
            return CraftMenus.asType(new MenuTypeData<FurnaceView>(FurnaceView.class, CraftMenuBuilder.tileEntity(SmokerBlockEntity::new, Blocks.SMOKER)));
        }
        if (menuType == MenuType.CARTOGRAPHY_TABLE) {
            return CraftMenus.asType(new MenuTypeData<InventoryView>(InventoryView.class, CraftMenuBuilder.worldAccess(CartographyTableMenu::new)));
        }
        if (menuType == MenuType.STONECUTTER) {
            return CraftMenus.asType(new MenuTypeData<StonecutterView>(StonecutterView.class, CraftMenuBuilder.worldAccess(StonecutterMenu::new)));
        }
        return CraftMenus.asType(new MenuTypeData<InventoryView>(InventoryView.class, STANDARD));
    }

    private static <V extends InventoryView> MenuTypeData<V> asType(MenuTypeData<?> data) {
        return data;
    }

    public record MenuTypeData<V extends InventoryView>(Class<V> viewClass, CraftMenuBuilder menuBuilder) {
    }
}

