/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpur;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import io.papermc.paper.ServerBuildInfo;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.plugin.java.JavaPluginLoader;
import org.purpurmc.purpur.command.PurpurCommand;
import org.purpurmc.purpur.task.TPSBarTask;

public class PurpurConfig {
    private static final String HEADER = "This is the main configuration file for Purpur.\nAs you can see, there's tons to configure. Some options may impact gameplay, so use\nwith caution, and make sure you know what each option does before configuring.\n\nIf you need help with the configuration or have any questions related to Purpur,\njoin us in our Discord guild.\n\nWebsite: https://purpurmc.org \nDocs: https://purpurmc.org/docs \n";
    private static File CONFIG_FILE;
    public static YamlConfiguration config;
    private static Map<String, Command> commands;
    public static int version;
    static boolean verbose;
    public static String cannotRideMob;
    public static String afkBroadcastAway;
    public static String afkBroadcastBack;
    public static boolean afkBroadcastUseDisplayName;
    public static String afkTabListPrefix;
    public static String afkTabListSuffix;
    public static String creditsCommandOutput;
    public static String demoCommandOutput;
    public static String pingCommandOutput;
    public static String ramCommandOutput;
    public static String rambarCommandOutput;
    public static String tpsbarCommandOutput;
    public static String dontRunWithScissors;
    public static String uptimeCommandOutput;
    public static String unverifiedUsername;
    public static String sleepSkippingNight;
    public static String sleepingPlayersPercent;
    public static String sleepNotPossible;
    public static String deathMsgRunWithScissors;
    public static String deathMsgStonecutter;
    public static boolean advancementOnlyBroadcastToAffectedPlayer;
    public static boolean deathMessageOnlyBroadcastToAffectedPlayer;
    public static String serverModName;
    public static double laggingThreshold;
    public static boolean useAlternateKeepAlive;
    public static boolean disableGiveCommandDrops;
    public static String commandRamBarTitle;
    public static BossBar.Overlay commandRamBarProgressOverlay;
    public static BossBar.Color commandRamBarProgressColorGood;
    public static BossBar.Color commandRamBarProgressColorMedium;
    public static BossBar.Color commandRamBarProgressColorLow;
    public static String commandRamBarTextColorGood;
    public static String commandRamBarTextColorMedium;
    public static String commandRamBarTextColorLow;
    public static int commandRamBarTickInterval;
    public static String commandTPSBarTitle;
    public static BossBar.Overlay commandTPSBarProgressOverlay;
    public static TPSBarTask.FillMode commandTPSBarProgressFillMode;
    public static BossBar.Color commandTPSBarProgressColorGood;
    public static BossBar.Color commandTPSBarProgressColorMedium;
    public static BossBar.Color commandTPSBarProgressColorLow;
    public static String commandTPSBarTextColorGood;
    public static String commandTPSBarTextColorMedium;
    public static String commandTPSBarTextColorLow;
    public static int commandTPSBarTickInterval;
    public static String commandCompassBarTitle;
    public static BossBar.Overlay commandCompassBarProgressOverlay;
    public static BossBar.Color commandCompassBarProgressColor;
    public static float commandCompassBarProgressPercent;
    public static int commandCompassBarTickInterval;
    public static boolean commandGamemodeRequiresPermission;
    public static boolean hideHiddenPlayersFromEntitySelector;
    public static String uptimeFormat;
    public static String uptimeDay;
    public static String uptimeDays;
    public static String uptimeHour;
    public static String uptimeHours;
    public static String uptimeMinute;
    public static String uptimeMinutes;
    public static String uptimeSecond;
    public static String uptimeSeconds;
    public static int barrelRows;
    public static boolean enderChestSixRows;
    public static boolean enderChestPermissionRows;
    public static boolean cryingObsidianValidForPortalFrame;
    public static int beeInsideBeeHive;
    public static boolean anvilCumulativeCost;
    public static int lightningRodRange;
    public static Set<Enchantment> grindstoneIgnoredEnchants;
    public static boolean grindstoneRemoveAttributes;
    public static boolean grindstoneRemoveDisplay;
    public static int caveVinesMaxGrowthAge;
    public static int kelpMaxGrowthAge;
    public static int twistingVinesMaxGrowthAge;
    public static int weepingVinesMaxGrowthAge;
    public static boolean magmaBlockReverseBubbleColumnFlow;
    public static boolean soulSandBlockReverseBubbleColumnFlow;
    public static boolean allowShearsLooting;
    public static boolean allowInapplicableEnchants;
    public static boolean allowIncompatibleEnchants;
    public static boolean allowHigherEnchantsLevels;
    public static boolean allowUnsafeEnchantCommand;
    public static boolean replaceIncompatibleEnchants;
    public static boolean clampEnchantLevels;
    public static boolean endermanShortHeight;
    public static boolean allowWaterPlacementInTheEnd;
    public static boolean beeCountPayload;
    public static boolean loggerSuppressInitLegacyMaterialError;
    public static boolean loggerSuppressIgnoredAdvancementWarnings;
    public static boolean loggerSuppressUnrecognizedRecipeErrors;
    public static boolean loggerSuppressSetBlockFarChunk;
    public static boolean loggerSuppressLibraryLoader;
    public static boolean tpsCatchup;
    public static boolean useUPnP;
    public static boolean maxJoinsPerSecond;
    public static boolean kickForOutOfOrderChat;
    public static Pattern usernameValidCharactersPattern;
    public static boolean fixProjectileLootingTransfer;
    public static boolean clampAttributes;
    public static boolean limitArmor;
    public static boolean playerDeathsAlwaysShowItem;
    public static boolean registerMinecraftDebugCommands;
    public static List<String> startupCommands;

    public static void init(File configFile) {
        CONFIG_FILE = configFile;
        config = new YamlConfiguration();
        try {
            config.load(CONFIG_FILE);
        }
        catch (IOException iOException) {
        }
        catch (InvalidConfigurationException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Could not load purpur.yml, please correct your syntax errors", ex);
            throw Throwables.propagate((Throwable)ex);
        }
        config.options().header(HEADER);
        config.options().copyDefaults(true);
        verbose = PurpurConfig.getBoolean("verbose", false);
        commands = new HashMap<String, Command>();
        commands.put("purpur", new PurpurCommand("purpur"));
        version = PurpurConfig.getInt("config-version", 37);
        PurpurConfig.set("config-version", 37);
        PurpurConfig.readConfig(PurpurConfig.class, null);
        Blocks.rebuildCache();
    }

    protected static void log(String s) {
        if (verbose) {
            PurpurConfig.log(Level.INFO, s);
        }
    }

    protected static void log(Level level, String s) {
        Bukkit.getLogger().log(level, s);
    }

    public static void registerCommands() {
        for (Map.Entry<String, Command> entry : commands.entrySet()) {
            MinecraftServer.getServer().server.getCommandMap().register(entry.getKey(), "Purpur", entry.getValue());
        }
    }

    static void readConfig(Class<?> clazz, Object instance) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!Modifier.isPrivate(method.getModifiers()) || method.getParameterTypes().length != 0 || method.getReturnType() != Void.TYPE) continue;
            try {
                method.setAccessible(true);
                method.invoke(instance, new Object[0]);
            }
            catch (InvocationTargetException ex) {
                throw Throwables.propagate((Throwable)ex.getCause());
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.SEVERE, "Error invoking " + String.valueOf(method), ex);
            }
        }
        try {
            config.save(CONFIG_FILE);
        }
        catch (IOException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Could not save " + String.valueOf(CONFIG_FILE), ex);
        }
    }

    private static void set(String path, Object val) {
        config.addDefault(path, val);
        config.set(path, val);
    }

    private static String getString(String path, String def) {
        config.addDefault(path, (Object)def);
        return config.getString(path, config.getString(path));
    }

    private static boolean getBoolean(String path, boolean def) {
        config.addDefault(path, (Object)def);
        return config.getBoolean(path, config.getBoolean(path));
    }

    private static double getDouble(String path, double def) {
        config.addDefault(path, (Object)def);
        return config.getDouble(path, config.getDouble(path));
    }

    private static int getInt(String path, int def) {
        config.addDefault(path, (Object)def);
        return config.getInt(path, config.getInt(path));
    }

    private static <T> List<?> getList(String path, T def) {
        config.addDefault(path, def);
        return config.getList(path, config.getList(path));
    }

    static Map<String, Object> getMap(String path, Map<String, Object> def) {
        if (def != null && config.getConfigurationSection(path) == null) {
            config.addDefault(path, def);
            return def;
        }
        return PurpurConfig.toMap(config.getConfigurationSection(path));
    }

    private static Map<String, Object> toMap(ConfigurationSection section) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (section != null) {
            for (String key : section.getKeys(false)) {
                Map<String, Object> map;
                Map<String, Object> obj = section.get(key);
                if (obj == null) continue;
                if (obj instanceof ConfigurationSection) {
                    ConfigurationSection val = (ConfigurationSection)obj;
                    map = PurpurConfig.toMap(val);
                } else {
                    map = obj;
                }
                builder.put((Object)key, (Object)map);
            }
        }
        return builder.build();
    }

    private static void messages() {
        cannotRideMob = PurpurConfig.getString("settings.messages.cannot-ride-mob", cannotRideMob);
        afkBroadcastAway = PurpurConfig.getString("settings.messages.afk-broadcast-away", afkBroadcastAway);
        afkBroadcastBack = PurpurConfig.getString("settings.messages.afk-broadcast-back", afkBroadcastBack);
        afkBroadcastUseDisplayName = PurpurConfig.getBoolean("settings.messages.afk-broadcast-use-display-name", afkBroadcastUseDisplayName);
        afkTabListPrefix = (String)MiniMessage.miniMessage().serialize(MiniMessage.miniMessage().deserialize((Object)PurpurConfig.getString("settings.messages.afk-tab-list-prefix", afkTabListPrefix)));
        afkTabListSuffix = (String)MiniMessage.miniMessage().serialize(MiniMessage.miniMessage().deserialize((Object)PurpurConfig.getString("settings.messages.afk-tab-list-suffix", afkTabListSuffix)));
        creditsCommandOutput = PurpurConfig.getString("settings.messages.credits-command-output", creditsCommandOutput);
        demoCommandOutput = PurpurConfig.getString("settings.messages.demo-command-output", demoCommandOutput);
        pingCommandOutput = PurpurConfig.getString("settings.messages.ping-command-output", pingCommandOutput);
        ramCommandOutput = PurpurConfig.getString("settings.messages.ram-command-output", ramCommandOutput);
        rambarCommandOutput = PurpurConfig.getString("settings.messages.rambar-command-output", rambarCommandOutput);
        tpsbarCommandOutput = PurpurConfig.getString("settings.messages.tpsbar-command-output", tpsbarCommandOutput);
        dontRunWithScissors = PurpurConfig.getString("settings.messages.dont-run-with-scissors", dontRunWithScissors);
        uptimeCommandOutput = PurpurConfig.getString("settings.messages.uptime-command-output", uptimeCommandOutput);
        unverifiedUsername = PurpurConfig.getString("settings.messages.unverified-username", unverifiedUsername);
        sleepSkippingNight = PurpurConfig.getString("settings.messages.sleep-skipping-night", sleepSkippingNight);
        sleepingPlayersPercent = PurpurConfig.getString("settings.messages.sleeping-players-percent", sleepingPlayersPercent);
        sleepNotPossible = PurpurConfig.getString("settings.messages.sleep-not-possible", sleepNotPossible);
    }

    private static void deathMessages() {
        deathMsgRunWithScissors = PurpurConfig.getString("settings.messages.death-message.run-with-scissors", deathMsgRunWithScissors);
        deathMsgStonecutter = PurpurConfig.getString("settings.messages.death-message.stonecutter", deathMsgStonecutter);
    }

    private static void broadcastSettings() {
        if (version < 13) {
            boolean oldValue = PurpurConfig.getBoolean("settings.advancement.only-broadcast-to-affected-player", false);
            PurpurConfig.set("settings.broadcasts.advancement.only-broadcast-to-affected-player", oldValue);
            PurpurConfig.set("settings.advancement.only-broadcast-to-affected-player", null);
        }
        advancementOnlyBroadcastToAffectedPlayer = PurpurConfig.getBoolean("settings.broadcasts.advancement.only-broadcast-to-affected-player", advancementOnlyBroadcastToAffectedPlayer);
        deathMessageOnlyBroadcastToAffectedPlayer = PurpurConfig.getBoolean("settings.broadcasts.death.only-broadcast-to-affected-player", deathMessageOnlyBroadcastToAffectedPlayer);
    }

    private static void serverModName() {
        serverModName = PurpurConfig.getString("settings.server-mod-name", serverModName);
    }

    private static void tickLoopSettings() {
        laggingThreshold = PurpurConfig.getDouble("settings.lagging-threshold", laggingThreshold);
    }

    private static void useAlternateKeepAlive() {
        useAlternateKeepAlive = PurpurConfig.getBoolean("settings.use-alternate-keepalive", useAlternateKeepAlive);
    }

    private static void disableGiveCommandDrops() {
        disableGiveCommandDrops = PurpurConfig.getBoolean("settings.disable-give-dropping", disableGiveCommandDrops);
    }

    private static void commandSettings() {
        commandRamBarTitle = PurpurConfig.getString("settings.command.rambar.title", commandRamBarTitle);
        commandRamBarProgressOverlay = BossBar.Overlay.valueOf((String)PurpurConfig.getString("settings.command.rambar.overlay", commandRamBarProgressOverlay.name()));
        commandRamBarProgressColorGood = BossBar.Color.valueOf((String)PurpurConfig.getString("settings.command.rambar.progress-color.good", commandRamBarProgressColorGood.name()));
        commandRamBarProgressColorMedium = BossBar.Color.valueOf((String)PurpurConfig.getString("settings.command.rambar.progress-color.medium", commandRamBarProgressColorMedium.name()));
        commandRamBarProgressColorLow = BossBar.Color.valueOf((String)PurpurConfig.getString("settings.command.rambar.progress-color.low", commandRamBarProgressColorLow.name()));
        commandRamBarTextColorGood = PurpurConfig.getString("settings.command.rambar.text-color.good", commandRamBarTextColorGood);
        commandRamBarTextColorMedium = PurpurConfig.getString("settings.command.rambar.text-color.medium", commandRamBarTextColorMedium);
        commandRamBarTextColorLow = PurpurConfig.getString("settings.command.rambar.text-color.low", commandRamBarTextColorLow);
        commandRamBarTickInterval = PurpurConfig.getInt("settings.command.rambar.tick-interval", commandRamBarTickInterval);
        commandTPSBarTitle = PurpurConfig.getString("settings.command.tpsbar.title", commandTPSBarTitle);
        commandTPSBarProgressOverlay = BossBar.Overlay.valueOf((String)PurpurConfig.getString("settings.command.tpsbar.overlay", commandTPSBarProgressOverlay.name()));
        commandTPSBarProgressFillMode = TPSBarTask.FillMode.valueOf(PurpurConfig.getString("settings.command.tpsbar.fill-mode", commandTPSBarProgressFillMode.name()));
        commandTPSBarProgressColorGood = BossBar.Color.valueOf((String)PurpurConfig.getString("settings.command.tpsbar.progress-color.good", commandTPSBarProgressColorGood.name()));
        commandTPSBarProgressColorMedium = BossBar.Color.valueOf((String)PurpurConfig.getString("settings.command.tpsbar.progress-color.medium", commandTPSBarProgressColorMedium.name()));
        commandTPSBarProgressColorLow = BossBar.Color.valueOf((String)PurpurConfig.getString("settings.command.tpsbar.progress-color.low", commandTPSBarProgressColorLow.name()));
        commandTPSBarTextColorGood = PurpurConfig.getString("settings.command.tpsbar.text-color.good", commandTPSBarTextColorGood);
        commandTPSBarTextColorMedium = PurpurConfig.getString("settings.command.tpsbar.text-color.medium", commandTPSBarTextColorMedium);
        commandTPSBarTextColorLow = PurpurConfig.getString("settings.command.tpsbar.text-color.low", commandTPSBarTextColorLow);
        commandTPSBarTickInterval = PurpurConfig.getInt("settings.command.tpsbar.tick-interval", commandTPSBarTickInterval);
        commandCompassBarTitle = PurpurConfig.getString("settings.command.compass.title", commandCompassBarTitle);
        commandCompassBarProgressOverlay = BossBar.Overlay.valueOf((String)PurpurConfig.getString("settings.command.compass.overlay", commandCompassBarProgressOverlay.name()));
        commandCompassBarProgressColor = BossBar.Color.valueOf((String)PurpurConfig.getString("settings.command.compass.progress-color", commandCompassBarProgressColor.name()));
        commandCompassBarProgressPercent = (float)PurpurConfig.getDouble("settings.command.compass.percent", commandCompassBarProgressPercent);
        commandCompassBarTickInterval = PurpurConfig.getInt("settings.command.compass.tick-interval", commandCompassBarTickInterval);
        commandGamemodeRequiresPermission = PurpurConfig.getBoolean("settings.command.gamemode.requires-specific-permission", commandGamemodeRequiresPermission);
        hideHiddenPlayersFromEntitySelector = PurpurConfig.getBoolean("settings.command.hide-hidden-players-from-entity-selector", hideHiddenPlayersFromEntitySelector);
        uptimeFormat = PurpurConfig.getString("settings.command.uptime.format", uptimeFormat);
        uptimeDay = PurpurConfig.getString("settings.command.uptime.day", uptimeDay);
        uptimeDays = PurpurConfig.getString("settings.command.uptime.days", uptimeDays);
        uptimeHour = PurpurConfig.getString("settings.command.uptime.hour", uptimeHour);
        uptimeHours = PurpurConfig.getString("settings.command.uptime.hours", uptimeHours);
        uptimeMinute = PurpurConfig.getString("settings.command.uptime.minute", uptimeMinute);
        uptimeMinutes = PurpurConfig.getString("settings.command.uptime.minutes", uptimeMinutes);
        uptimeSecond = PurpurConfig.getString("settings.command.uptime.second", uptimeSecond);
        uptimeSeconds = PurpurConfig.getString("settings.command.uptime.seconds", uptimeSeconds);
    }

    private static void blockSettings() {
        boolean oldValue;
        if (version < 3) {
            oldValue = PurpurConfig.getBoolean("settings.barrel.packed-barrels", true);
            PurpurConfig.set("settings.blocks.barrel.six-rows", oldValue);
            PurpurConfig.set("settings.packed-barrels", null);
            oldValue = PurpurConfig.getBoolean("settings.large-ender-chests", true);
            PurpurConfig.set("settings.blocks.ender_chest.six-rows", oldValue);
            PurpurConfig.set("settings.large-ender-chests", null);
        }
        if (version < 20) {
            oldValue = PurpurConfig.getBoolean("settings.blocks.barrel.six-rows", false);
            PurpurConfig.set("settings.blocks.barrel.rows", oldValue ? 6 : 3);
            PurpurConfig.set("settings.blocks.barrel.six-rows", null);
        }
        if ((barrelRows = PurpurConfig.getInt("settings.blocks.barrel.rows", barrelRows)) < 1 || barrelRows > 6) {
            Bukkit.getLogger().severe("settings.blocks.barrel.rows must be 1-6, resetting to default");
            barrelRows = 3;
        }
        InventoryType.BARREL.setDefaultSize(switch (barrelRows) {
            case 6 -> 54;
            case 5 -> 45;
            case 4 -> 36;
            case 2 -> 18;
            case 1 -> 9;
            default -> 27;
        });
        enderChestSixRows = PurpurConfig.getBoolean("settings.blocks.ender_chest.six-rows", enderChestSixRows);
        InventoryType.ENDER_CHEST.setDefaultSize(enderChestSixRows ? 54 : 27);
        enderChestPermissionRows = PurpurConfig.getBoolean("settings.blocks.ender_chest.use-permissions-for-rows", enderChestPermissionRows);
        cryingObsidianValidForPortalFrame = PurpurConfig.getBoolean("settings.blocks.crying_obsidian.valid-for-portal-frame", cryingObsidianValidForPortalFrame);
        beeInsideBeeHive = PurpurConfig.getInt("settings.blocks.beehive.max-bees-inside", beeInsideBeeHive);
        anvilCumulativeCost = PurpurConfig.getBoolean("settings.blocks.anvil.cumulative-cost", anvilCumulativeCost);
        lightningRodRange = PurpurConfig.getInt("settings.blocks.lightning_rod.range", lightningRodRange);
        ArrayList<String> defaultCurses = new ArrayList<String>(){
            {
                this.add("minecraft:binding_curse");
                this.add("minecraft:vanishing_curse");
            }
        };
        if (version < 24 && !PurpurConfig.getBoolean("settings.blocks.grindstone.ignore-curses", true)) {
            defaultCurses.clear();
        }
        PurpurConfig.getList("settings.blocks.grindstone.ignored-enchants", defaultCurses).forEach(key -> {
            Registry<Enchantment> registry = MinecraftServer.getServer().registryAccess().registryOrThrow(Registries.ENCHANTMENT);
            Enchantment enchantment = registry.get(ResourceLocation.parse(key.toString()));
            if (enchantment == null) {
                return;
            }
            grindstoneIgnoredEnchants.add(enchantment);
        });
        grindstoneRemoveAttributes = PurpurConfig.getBoolean("settings.blocks.grindstone.remove-attributes", grindstoneRemoveAttributes);
        grindstoneRemoveDisplay = PurpurConfig.getBoolean("settings.blocks.grindstone.remove-name-and-lore", grindstoneRemoveDisplay);
        caveVinesMaxGrowthAge = PurpurConfig.getInt("settings.blocks.cave_vines.max-growth-age", caveVinesMaxGrowthAge);
        if (caveVinesMaxGrowthAge > 25) {
            caveVinesMaxGrowthAge = 25;
            PurpurConfig.log(Level.WARNING, "blocks.cave_vines.max-growth-age is set to above maximum allowed value of 25");
            PurpurConfig.log(Level.WARNING, "Using value of 25 to prevent issues");
        }
        if ((kelpMaxGrowthAge = PurpurConfig.getInt("settings.blocks.kelp.max-growth-age", kelpMaxGrowthAge)) > 25) {
            kelpMaxGrowthAge = 25;
            PurpurConfig.log(Level.WARNING, "blocks.kelp.max-growth-age is set to above maximum allowed value of 25");
            PurpurConfig.log(Level.WARNING, "Using value of 25 to prevent issues");
        }
        if ((twistingVinesMaxGrowthAge = PurpurConfig.getInt("settings.blocks.twisting_vines.max-growth-age", twistingVinesMaxGrowthAge)) > 25) {
            twistingVinesMaxGrowthAge = 25;
            PurpurConfig.log(Level.WARNING, "blocks.twisting_vines.max-growth-age is set to above maximum allowed value of 25");
            PurpurConfig.log(Level.WARNING, "Using value of 25 to prevent issues");
        }
        if ((weepingVinesMaxGrowthAge = PurpurConfig.getInt("settings.blocks.weeping_vines.max-growth-age", weepingVinesMaxGrowthAge)) > 25) {
            weepingVinesMaxGrowthAge = 25;
            PurpurConfig.log(Level.WARNING, "blocks.weeping_vines.max-growth-age is set to above maximum allowed value of 25");
            PurpurConfig.log(Level.WARNING, "Using value of 25 to prevent issues");
        }
        magmaBlockReverseBubbleColumnFlow = PurpurConfig.getBoolean("settings.blocks.magma-block.reverse-bubble-column-flow", magmaBlockReverseBubbleColumnFlow);
        soulSandBlockReverseBubbleColumnFlow = PurpurConfig.getBoolean("settings.blocks.soul-sand.reverse-bubble-column-flow", soulSandBlockReverseBubbleColumnFlow);
    }

    private static void enchantmentSettings() {
        if (version < 30) {
            boolean oldValue = PurpurConfig.getBoolean("settings.enchantment.allow-unsafe-enchants", false);
            PurpurConfig.set("settings.enchantment.anvil.allow-unsafe-enchants", oldValue);
            PurpurConfig.set("settings.enchantment.anvil.allow-inapplicable-enchants", true);
            PurpurConfig.set("settings.enchantment.anvil.allow-incompatible-enchants", true);
            PurpurConfig.set("settings.enchantment.anvil.allow-higher-enchants-levels", true);
            PurpurConfig.set("settings.enchantment.allow-unsafe-enchants", null);
        }
        if (version < 37) {
            boolean allowUnsafeEnchants = PurpurConfig.getBoolean("settings.enchantment.anvil.allow-unsafe-enchants", false);
            if (!allowUnsafeEnchants) {
                PurpurConfig.set("settings.enchantment.anvil.allow-inapplicable-enchants", false);
                PurpurConfig.set("settings.enchantment.anvil.allow-incompatible-enchants", false);
                PurpurConfig.set("settings.enchantment.anvil.allow-higher-enchants-levels", false);
            }
            PurpurConfig.set("settings.enchantment.anvil.allow-unsafe-enchants", null);
        }
        allowShearsLooting = PurpurConfig.getBoolean("settings.enchantment.allow-looting-on-shears", allowShearsLooting);
        allowInapplicableEnchants = PurpurConfig.getBoolean("settings.enchantment.anvil.allow-inapplicable-enchants", allowInapplicableEnchants);
        allowIncompatibleEnchants = PurpurConfig.getBoolean("settings.enchantment.anvil.allow-incompatible-enchants", allowIncompatibleEnchants);
        allowHigherEnchantsLevels = PurpurConfig.getBoolean("settings.enchantment.anvil.allow-higher-enchants-levels", allowHigherEnchantsLevels);
        allowUnsafeEnchantCommand = PurpurConfig.getBoolean("settings.enchantment.allow-unsafe-enchant-command", allowUnsafeEnchantCommand);
        replaceIncompatibleEnchants = PurpurConfig.getBoolean("settings.enchantment.anvil.replace-incompatible-enchants", replaceIncompatibleEnchants);
        clampEnchantLevels = PurpurConfig.getBoolean("settings.enchantment.clamp-levels", clampEnchantLevels);
    }

    private static void entitySettings() {
        if (endermanShortHeight = PurpurConfig.getBoolean("settings.entity.enderman.short-height", endermanShortHeight)) {
            EntityType.ENDERMAN.setDimensions(EntityDimensions.scalable(0.6f, 1.9f));
        }
    }

    private static void allowWaterPlacementInEnd() {
        allowWaterPlacementInTheEnd = PurpurConfig.getBoolean("settings.allow-water-placement-in-the-end", allowWaterPlacementInTheEnd);
    }

    private static void beeCountPayload() {
        beeCountPayload = PurpurConfig.getBoolean("settings.bee-count-payload", beeCountPayload);
    }

    private static void loggerSettings() {
        loggerSuppressInitLegacyMaterialError = PurpurConfig.getBoolean("settings.logger.suppress-init-legacy-material-errors", loggerSuppressInitLegacyMaterialError);
        loggerSuppressIgnoredAdvancementWarnings = PurpurConfig.getBoolean("settings.logger.suppress-ignored-advancement-warnings", loggerSuppressIgnoredAdvancementWarnings);
        loggerSuppressUnrecognizedRecipeErrors = PurpurConfig.getBoolean("settings.logger.suppress-unrecognized-recipe-errors", loggerSuppressUnrecognizedRecipeErrors);
        loggerSuppressSetBlockFarChunk = PurpurConfig.getBoolean("settings.logger.suppress-setblock-in-far-chunk-errors", loggerSuppressSetBlockFarChunk);
        JavaPluginLoader.SuppressLibraryLoaderLogger = loggerSuppressLibraryLoader = PurpurConfig.getBoolean("settings.logger.suppress-library-loader", loggerSuppressLibraryLoader);
    }

    private static void tpsCatchup() {
        tpsCatchup = PurpurConfig.getBoolean("settings.tps-catchup", tpsCatchup);
    }

    private static void networkSettings() {
        useUPnP = PurpurConfig.getBoolean("settings.network.upnp-port-forwarding", useUPnP);
        maxJoinsPerSecond = PurpurConfig.getBoolean("settings.network.max-joins-per-second", maxJoinsPerSecond);
        kickForOutOfOrderChat = PurpurConfig.getBoolean("settings.network.kick-for-out-of-order-chat", kickForOutOfOrderChat);
    }

    private static void usernameValidationSettings() {
        String defaultPattern = "^[a-zA-Z0-9_.]*$";
        String setPattern = PurpurConfig.getString("settings.username-valid-characters", defaultPattern);
        usernameValidCharactersPattern = Pattern.compile(setPattern == null || setPattern.isBlank() ? defaultPattern : setPattern);
    }

    private static void fixProjectileLootingTransfer() {
        fixProjectileLootingTransfer = PurpurConfig.getBoolean("settings.fix-projectile-looting-transfer", fixProjectileLootingTransfer);
    }

    private static void clampAttributes() {
        clampAttributes = PurpurConfig.getBoolean("settings.clamp-attributes", clampAttributes);
    }

    private static void limitArmor() {
        limitArmor = PurpurConfig.getBoolean("settings.limit-armor", limitArmor);
    }

    private static void blastResistanceSettings() {
        PurpurConfig.getMap("settings.blast-resistance-overrides", Collections.emptyMap()).forEach((blockId, value) -> {
            Block block = BuiltInRegistries.BLOCK.get(ResourceLocation.parse(blockId));
            if (block == Blocks.AIR) {
                PurpurConfig.log(Level.SEVERE, "Invalid block for `settings.blast-resistance-overrides`: " + blockId);
                return;
            }
            if (!(value instanceof Number)) {
                PurpurConfig.log(Level.SEVERE, "Invalid blast resistance for `settings.blast-resistance-overrides." + blockId + "`: " + String.valueOf(value));
                return;
            }
            Number blastResistance = (Number)value;
            block.explosionResistance = blastResistance.floatValue();
        });
    }

    private static void blockFallMultiplierSettings() {
        PurpurConfig.getMap("settings.block-fall-multipliers", Map.ofEntries(Map.entry("minecraft:hay_block", Map.of("damage", Float.valueOf(0.2f))), Map.entry("minecraft:white_bed", Map.of("distance", Float.valueOf(0.5f))), Map.entry("minecraft:light_gray_bed", Map.of("distance", Float.valueOf(0.5f))), Map.entry("minecraft:gray_bed", Map.of("distance", Float.valueOf(0.5f))), Map.entry("minecraft:black_bed", Map.of("distance", Float.valueOf(0.5f))), Map.entry("minecraft:brown_bed", Map.of("distance", Float.valueOf(0.5f))), Map.entry("minecraft:pink_bed", Map.of("distance", Float.valueOf(0.5f))), Map.entry("minecraft:red_bed", Map.of("distance", Float.valueOf(0.5f))), Map.entry("minecraft:orange_bed", Map.of("distance", Float.valueOf(0.5f))), Map.entry("minecraft:yellow_bed", Map.of("distance", Float.valueOf(0.5f))), Map.entry("minecraft:green_bed", Map.of("distance", Float.valueOf(0.5f))), Map.entry("minecraft:lime_bed", Map.of("distance", Float.valueOf(0.5f))), Map.entry("minecraft:cyan_bed", Map.of("distance", Float.valueOf(0.5f))), Map.entry("minecraft:light_blue_bed", Map.of("distance", Float.valueOf(0.5f))), Map.entry("minecraft:blue_bed", Map.of("distance", Float.valueOf(0.5f))), Map.entry("minecraft:purple_bed", Map.of("distance", Float.valueOf(0.5f))), Map.entry("minecraft:magenta_bed", Map.of("distance", Float.valueOf(0.5f))))).forEach((blockId, value) -> {
            Block block = BuiltInRegistries.BLOCK.get(ResourceLocation.parse(blockId));
            if (block == Blocks.AIR) {
                PurpurConfig.log(Level.SEVERE, "Invalid block for `settings.block-fall-multipliers`: " + blockId);
                return;
            }
            if (!(value instanceof Map)) {
                PurpurConfig.log(Level.SEVERE, "Invalid fall multiplier for `settings.block-fall-multipliers." + blockId + "`: " + String.valueOf(value) + ", expected a map with keys `damage` and `distance` to floats.");
                return;
            }
            Map map = (Map)value;
            Object rawFallDamageMultiplier = map.get("damage");
            if (rawFallDamageMultiplier == null) {
                rawFallDamageMultiplier = Float.valueOf(1.0f);
            }
            if (!(rawFallDamageMultiplier instanceof Number)) {
                PurpurConfig.log(Level.SEVERE, "Invalid multiplier for `settings.block-fall-multipliers." + blockId + ".damage`: " + String.valueOf(map.get("damage")));
                return;
            }
            Number fallDamageMultiplier = (Number)rawFallDamageMultiplier;
            Object rawFallDistanceMultiplier = map.get("distance");
            if (rawFallDistanceMultiplier == null) {
                rawFallDistanceMultiplier = Float.valueOf(1.0f);
            }
            if (!(rawFallDistanceMultiplier instanceof Number)) {
                PurpurConfig.log(Level.SEVERE, "Invalid multiplier for `settings.block-fall-multipliers." + blockId + ".distance`: " + String.valueOf(map.get("distance")));
                return;
            }
            Number fallDistanceMultiplier = (Number)rawFallDistanceMultiplier;
            block.fallDamageMultiplier = fallDamageMultiplier.floatValue();
            block.fallDistanceMultiplier = fallDistanceMultiplier.floatValue();
        });
    }

    private static void playerDeathsAlwaysShowItem() {
        playerDeathsAlwaysShowItem = PurpurConfig.getBoolean("settings.player-deaths-always-show-item", playerDeathsAlwaysShowItem);
    }

    private static void registerMinecraftDebugCommands() {
        registerMinecraftDebugCommands = PurpurConfig.getBoolean("settings.register-minecraft-debug-commands", registerMinecraftDebugCommands);
    }

    private static void startupCommands() {
        startupCommands.clear();
        PurpurConfig.getList("settings.startup-commands", new ArrayList()).forEach(line -> {
            String command = line.toString();
            if (command.startsWith("/")) {
                command = command.substring(1);
            }
            startupCommands.add(command);
        });
    }

    static {
        cannotRideMob = "<red>You cannot mount that mob";
        afkBroadcastAway = "<yellow><italic>%s is now AFK";
        afkBroadcastBack = "<yellow><italic>%s is no longer AFK";
        afkBroadcastUseDisplayName = false;
        afkTabListPrefix = "[AFK] ";
        afkTabListSuffix = "";
        creditsCommandOutput = "<green>%s has been shown the end credits";
        demoCommandOutput = "<green>%s has been shown the demo screen";
        pingCommandOutput = "<green>%s's ping is %sms";
        ramCommandOutput = "<green>Ram Usage: <used>/<xmx> (<percent>)";
        rambarCommandOutput = "<green>Rambar toggled <onoff> for <target>";
        tpsbarCommandOutput = "<green>Tpsbar toggled <onoff> for <target>";
        dontRunWithScissors = "<red><italic>Don't run with scissors!";
        uptimeCommandOutput = "<green>Server uptime is <uptime>";
        unverifiedUsername = "default";
        sleepSkippingNight = "default";
        sleepingPlayersPercent = "default";
        sleepNotPossible = "default";
        deathMsgRunWithScissors = "<player> slipped and fell on their shears";
        deathMsgStonecutter = "<player> has sawed themself in half";
        advancementOnlyBroadcastToAffectedPlayer = false;
        deathMessageOnlyBroadcastToAffectedPlayer = false;
        serverModName = ServerBuildInfo.buildInfo().brandName();
        laggingThreshold = 19.0;
        useAlternateKeepAlive = false;
        disableGiveCommandDrops = false;
        commandRamBarTitle = "<gray>Ram<yellow>:</yellow> <used>/<xmx> (<percent>)";
        commandRamBarProgressOverlay = BossBar.Overlay.NOTCHED_20;
        commandRamBarProgressColorGood = BossBar.Color.GREEN;
        commandRamBarProgressColorMedium = BossBar.Color.YELLOW;
        commandRamBarProgressColorLow = BossBar.Color.RED;
        commandRamBarTextColorGood = "<gradient:#55ff55:#00aa00><text></gradient>";
        commandRamBarTextColorMedium = "<gradient:#ffff55:#ffaa00><text></gradient>";
        commandRamBarTextColorLow = "<gradient:#ff5555:#aa0000><text></gradient>";
        commandRamBarTickInterval = 20;
        commandTPSBarTitle = "<gray>TPS<yellow>:</yellow> <tps> MSPT<yellow>:</yellow> <mspt> Ping<yellow>:</yellow> <ping>ms";
        commandTPSBarProgressOverlay = BossBar.Overlay.NOTCHED_20;
        commandTPSBarProgressFillMode = TPSBarTask.FillMode.MSPT;
        commandTPSBarProgressColorGood = BossBar.Color.GREEN;
        commandTPSBarProgressColorMedium = BossBar.Color.YELLOW;
        commandTPSBarProgressColorLow = BossBar.Color.RED;
        commandTPSBarTextColorGood = "<gradient:#55ff55:#00aa00><text></gradient>";
        commandTPSBarTextColorMedium = "<gradient:#ffff55:#ffaa00><text></gradient>";
        commandTPSBarTextColorLow = "<gradient:#ff5555:#aa0000><text></gradient>";
        commandTPSBarTickInterval = 20;
        commandCompassBarTitle = "S  \u00b7  \u25c8  \u00b7  \u25c8  \u00b7  \u25c8  \u00b7  SW  \u00b7  \u25c8  \u00b7  \u25c8  \u00b7  \u25c8  \u00b7  W  \u00b7  \u25c8  \u00b7  \u25c8  \u00b7  \u25c8  \u00b7  NW  \u00b7  \u25c8  \u00b7  \u25c8  \u00b7  \u25c8  \u00b7  N  \u00b7  \u25c8  \u00b7  \u25c8  \u00b7  \u25c8  \u00b7  NE  \u00b7  \u25c8  \u00b7  \u25c8  \u00b7  \u25c8  \u00b7  E  \u00b7  \u25c8  \u00b7  \u25c8  \u00b7  \u25c8  \u00b7  SE  \u00b7  \u25c8  \u00b7  \u25c8  \u00b7  \u25c8  \u00b7  S  \u00b7  \u25c8  \u00b7  \u25c8  \u00b7  \u25c8  \u00b7  SW  \u00b7  \u25c8  \u00b7  \u25c8  \u00b7  \u25c8  \u00b7  W  \u00b7  \u25c8  \u00b7  \u25c8  \u00b7  \u25c8  \u00b7  NW  \u00b7  \u25c8  \u00b7  \u25c8  \u00b7  \u25c8  \u00b7  N  \u00b7  \u25c8  \u00b7  \u25c8  \u00b7  \u25c8  \u00b7  NE  \u00b7  \u25c8  \u00b7  \u25c8  \u00b7  \u25c8  \u00b7  E  \u00b7  \u25c8  \u00b7  \u25c8  \u00b7  \u25c8  \u00b7  SE  \u00b7  \u25c8  \u00b7  \u25c8  \u00b7  \u25c8  \u00b7  ";
        commandCompassBarProgressOverlay = BossBar.Overlay.PROGRESS;
        commandCompassBarProgressColor = BossBar.Color.BLUE;
        commandCompassBarProgressPercent = 1.0f;
        commandCompassBarTickInterval = 5;
        commandGamemodeRequiresPermission = false;
        hideHiddenPlayersFromEntitySelector = false;
        uptimeFormat = "<days><hours><minutes><seconds>";
        uptimeDay = "%02d day, ";
        uptimeDays = "%02d days, ";
        uptimeHour = "%02d hour, ";
        uptimeHours = "%02d hours, ";
        uptimeMinute = "%02d minute, and ";
        uptimeMinutes = "%02d minutes, and ";
        uptimeSecond = "%02d second";
        uptimeSeconds = "%02d seconds";
        barrelRows = 3;
        enderChestSixRows = false;
        enderChestPermissionRows = false;
        cryingObsidianValidForPortalFrame = false;
        beeInsideBeeHive = 3;
        anvilCumulativeCost = true;
        lightningRodRange = 128;
        grindstoneIgnoredEnchants = new HashSet<Enchantment>();
        grindstoneRemoveAttributes = false;
        grindstoneRemoveDisplay = false;
        caveVinesMaxGrowthAge = 25;
        kelpMaxGrowthAge = 25;
        twistingVinesMaxGrowthAge = 25;
        weepingVinesMaxGrowthAge = 25;
        magmaBlockReverseBubbleColumnFlow = false;
        soulSandBlockReverseBubbleColumnFlow = false;
        allowShearsLooting = false;
        allowInapplicableEnchants = false;
        allowIncompatibleEnchants = false;
        allowHigherEnchantsLevels = false;
        allowUnsafeEnchantCommand = false;
        replaceIncompatibleEnchants = false;
        clampEnchantLevels = true;
        endermanShortHeight = false;
        allowWaterPlacementInTheEnd = true;
        beeCountPayload = false;
        loggerSuppressInitLegacyMaterialError = false;
        loggerSuppressIgnoredAdvancementWarnings = false;
        loggerSuppressUnrecognizedRecipeErrors = false;
        loggerSuppressSetBlockFarChunk = false;
        loggerSuppressLibraryLoader = false;
        tpsCatchup = true;
        useUPnP = false;
        maxJoinsPerSecond = false;
        kickForOutOfOrderChat = true;
        fixProjectileLootingTransfer = false;
        clampAttributes = true;
        limitArmor = true;
        playerDeathsAlwaysShowItem = false;
        registerMinecraftDebugCommands = false;
        startupCommands = new ArrayList<String>();
    }
}

