/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc;

import gg.pufferfish.pufferfish.PufferfishConfig;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Marker;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ambient.AmbientCreature;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.EyeOfEnder;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spigotmc.SpigotWorldConfig;

public class ActivationRange {
    static Activity[] VILLAGER_PANIC_IMMUNITIES = new Activity[]{Activity.HIDE, Activity.PRE_RAID, Activity.RAID, Activity.PANIC};
    static AABB maxBB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    private static int checkInactiveWakeup(Entity entity) {
        Level world = entity.level();
        SpigotWorldConfig config = world.spigotConfig;
        long inactiveFor = (long)MinecraftServer.currentTick - entity.activatedTick;
        if (entity.activationType == ActivationType.VILLAGER) {
            if (inactiveFor > (long)config.wakeUpInactiveVillagersEvery && world.wakeupInactiveRemainingVillagers > 0) {
                --world.wakeupInactiveRemainingVillagers;
                return config.wakeUpInactiveVillagersFor;
            }
        } else if (entity.activationType == ActivationType.ANIMAL) {
            if (inactiveFor > (long)config.wakeUpInactiveAnimalsEvery && world.wakeupInactiveRemainingAnimals > 0) {
                --world.wakeupInactiveRemainingAnimals;
                return config.wakeUpInactiveAnimalsFor;
            }
        } else if (entity.activationType == ActivationType.FLYING_MONSTER) {
            if (inactiveFor > (long)config.wakeUpInactiveFlyingEvery && world.wakeupInactiveRemainingFlying > 0) {
                --world.wakeupInactiveRemainingFlying;
                return config.wakeUpInactiveFlyingFor;
            }
        } else if ((entity.activationType == ActivationType.MONSTER || entity.activationType == ActivationType.RAIDER) && inactiveFor > (long)config.wakeUpInactiveMonstersEvery && world.wakeupInactiveRemainingMonsters > 0) {
            --world.wakeupInactiveRemainingMonsters;
            return config.wakeUpInactiveMonstersFor;
        }
        return -1;
    }

    public static ActivationType initializeEntityActivationType(Entity entity) {
        if (entity instanceof WaterAnimal) {
            return ActivationType.WATER;
        }
        if (entity instanceof Villager) {
            return ActivationType.VILLAGER;
        }
        if (entity instanceof FlyingMob && entity instanceof Enemy) {
            return ActivationType.FLYING_MONSTER;
        }
        if (entity instanceof Raider) {
            return ActivationType.RAIDER;
        }
        if (entity instanceof Enemy) {
            return ActivationType.MONSTER;
        }
        if (entity instanceof PathfinderMob || entity instanceof AmbientCreature) {
            return ActivationType.ANIMAL;
        }
        return ActivationType.MISC;
    }

    public static boolean initializeEntityActivationState(Entity entity, SpigotWorldConfig config) {
        return entity.activationType == ActivationType.MISC && config.miscActivationRange <= 0 || entity.activationType == ActivationType.RAIDER && config.raiderActivationRange <= 0 || entity.activationType == ActivationType.ANIMAL && config.animalActivationRange <= 0 || entity.activationType == ActivationType.MONSTER && config.monsterActivationRange <= 0 || entity.activationType == ActivationType.VILLAGER && config.villagerActivationRange <= 0 || entity.activationType == ActivationType.WATER && config.waterActivationRange <= 0 || entity.activationType == ActivationType.FLYING_MONSTER && config.flyingMonsterActivationRange <= 0 || entity instanceof EyeOfEnder || entity instanceof Player || entity instanceof ThrowableProjectile || entity instanceof EnderDragon || entity instanceof EnderDragonPart || entity instanceof WitherBoss || entity instanceof AbstractHurtingProjectile || entity instanceof LightningBolt || entity instanceof PrimedTnt || entity instanceof FallingBlockEntity || entity instanceof AbstractMinecart || entity instanceof Boat || entity instanceof EndCrystal || entity instanceof FireworkRocketEntity || entity instanceof ThrownTrident;
    }

    public static void activateEntities(Level world) {
        int miscActivationRange = world.spigotConfig.miscActivationRange;
        int raiderActivationRange = world.spigotConfig.raiderActivationRange;
        int animalActivationRange = world.spigotConfig.animalActivationRange;
        int monsterActivationRange = world.spigotConfig.monsterActivationRange;
        int waterActivationRange = world.spigotConfig.waterActivationRange;
        int flyingActivationRange = world.spigotConfig.flyingMonsterActivationRange;
        int villagerActivationRange = world.spigotConfig.villagerActivationRange;
        world.wakeupInactiveRemainingAnimals = Math.min(world.wakeupInactiveRemainingAnimals + 1, world.spigotConfig.wakeUpInactiveAnimals);
        world.wakeupInactiveRemainingVillagers = Math.min(world.wakeupInactiveRemainingVillagers + 1, world.spigotConfig.wakeUpInactiveVillagers);
        world.wakeupInactiveRemainingMonsters = Math.min(world.wakeupInactiveRemainingMonsters + 1, world.spigotConfig.wakeUpInactiveMonsters);
        world.wakeupInactiveRemainingFlying = Math.min(world.wakeupInactiveRemainingFlying + 1, world.spigotConfig.wakeUpInactiveFlying);
        ServerChunkCache chunkProvider = (ServerChunkCache)world.getChunkSource();
        int maxRange = Math.max(monsterActivationRange, animalActivationRange);
        maxRange = Math.max(maxRange, raiderActivationRange);
        maxRange = Math.max(maxRange, miscActivationRange);
        maxRange = Math.max(maxRange, flyingActivationRange);
        maxRange = Math.max(maxRange, waterActivationRange);
        maxRange = Math.max(maxRange, villagerActivationRange);
        maxRange = Math.min((world.spigotConfig.simulationDistance << 4) - 8, maxRange);
        for (Player player : world.players()) {
            player.activatedTick = MinecraftServer.currentTick;
            if (world.spigotConfig.ignoreSpectatorActivation && player.isSpectator() || !player.level().purpurConfig.idleTimeoutTickNearbyEntities && player.isAfk()) continue;
            int worldHeight = world.getHeight();
            maxBB = player.getBoundingBox().inflate(maxRange, worldHeight, maxRange);
            ActivationType.MISC.boundingBox = player.getBoundingBox().inflate(miscActivationRange, worldHeight, miscActivationRange);
            ActivationType.RAIDER.boundingBox = player.getBoundingBox().inflate(raiderActivationRange, worldHeight, raiderActivationRange);
            ActivationType.ANIMAL.boundingBox = player.getBoundingBox().inflate(animalActivationRange, worldHeight, animalActivationRange);
            ActivationType.MONSTER.boundingBox = player.getBoundingBox().inflate(monsterActivationRange, worldHeight, monsterActivationRange);
            ActivationType.WATER.boundingBox = player.getBoundingBox().inflate(waterActivationRange, worldHeight, waterActivationRange);
            ActivationType.FLYING_MONSTER.boundingBox = player.getBoundingBox().inflate(flyingActivationRange, worldHeight, flyingActivationRange);
            ActivationType.VILLAGER.boundingBox = player.getBoundingBox().inflate(villagerActivationRange, worldHeight, villagerActivationRange);
            List<Entity> entities = world.getEntities((Entity)null, maxBB, null);
            boolean tickMarkers = world.paperConfig().entities.markers.tick;
            for (Entity entity : entities) {
                if (!tickMarkers && entity instanceof Marker) continue;
                ActivationRange.activateEntity(entity);
                if (PufferfishConfig.dearEnabled && entity.getType().dabEnabled) {
                    if (!entity.activatedPriorityReset) {
                        entity.activatedPriorityReset = true;
                        entity.activatedPriority = PufferfishConfig.maximumActivationPrio;
                    }
                    Vec3 playerVec = player.position();
                    Vec3 entityVec = entity.position();
                    double diffX = playerVec.x - entityVec.x;
                    double diffY = playerVec.y - entityVec.y;
                    double diffZ = playerVec.z - entityVec.z;
                    int squaredDistance = (int)(diffX * diffX + diffY * diffY + diffZ * diffZ);
                    entity.activatedPriority = squaredDistance > PufferfishConfig.startDistanceSquared ? Math.max(1, Math.min(squaredDistance >> PufferfishConfig.activationDistanceMod, entity.activatedPriority)) : 1;
                    continue;
                }
                entity.activatedPriority = 1;
            }
        }
    }

    private static void activateEntity(Entity entity) {
        if ((long)MinecraftServer.currentTick > entity.activatedTick) {
            if (entity.defaultActivationState) {
                entity.activatedTick = MinecraftServer.currentTick;
                return;
            }
            if (entity.activationType.boundingBox.intersects(entity.getBoundingBox())) {
                entity.activatedTick = MinecraftServer.currentTick;
            }
        }
    }

    public static int checkEntityImmunities(Entity entity) {
        SpigotWorldConfig config = entity.level().spigotConfig;
        int inactiveWakeUpImmunity = ActivationRange.checkInactiveWakeup(entity);
        if (inactiveWakeUpImmunity > -1) {
            return inactiveWakeUpImmunity;
        }
        if (entity.getRemainingFireTicks() > 0) {
            return 2;
        }
        if (entity.activatedImmunityTick >= (long)MinecraftServer.currentTick) {
            return 1;
        }
        long inactiveFor = (long)MinecraftServer.currentTick - entity.activatedTick;
        if (entity.activationType != ActivationType.WATER && entity.wasTouchingWater && entity.isPushedByFluid()) {
            return 100;
        }
        if (!entity.onGround() || entity.getDeltaMovement().horizontalDistanceSqr() > (double)1.0E-5f) {
            return 100;
        }
        if (!(entity instanceof AbstractArrow)) {
            if (!entity.onGround() && !(entity instanceof FlyingMob)) {
                return 10;
            }
        } else if (!((AbstractArrow)entity).inGround) {
            return 1;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (living.onClimableCached() || living.jumping || living.hurtTime > 0 || living.activeEffects.size() > 0 || living.isFreezing()) {
                return 1;
            }
            if (entity instanceof Mob && ((Mob)entity).getTarget() != null) {
                return 20;
            }
            if (entity instanceof Bee) {
                Bee bee = (Bee)entity;
                BlockPos movingTarget = bee.getMovingTarget();
                if (bee.isAngry() || bee.getHivePos() != null && bee.getHivePos().equals(movingTarget) || bee.getSavedFlowerPos() != null && bee.getSavedFlowerPos().equals(movingTarget)) {
                    return 20;
                }
            }
            if (entity instanceof Villager) {
                Brain<Villager> behaviorController = ((Villager)entity).getBrain();
                if (config.villagersActiveForPanic) {
                    for (Activity activity : VILLAGER_PANIC_IMMUNITIES) {
                        if (!behaviorController.isActive(activity)) continue;
                        return 100;
                    }
                }
                if (config.villagersWorkImmunityAfter > 0 && inactiveFor >= (long)config.villagersWorkImmunityAfter && behaviorController.isActive(Activity.WORK)) {
                    return config.villagersWorkImmunityFor;
                }
            }
            if (entity instanceof Llama && ((Llama)entity).inCaravan()) {
                return 1;
            }
            if (entity instanceof Animal) {
                Animal animal = (Animal)entity;
                if (animal.isBaby() || animal.isInLove()) {
                    return 5;
                }
                if (entity instanceof Sheep && ((Sheep)entity).isSheared()) {
                    return 1;
                }
            }
            if (entity instanceof Creeper && ((Creeper)entity).isIgnited()) {
                return 20;
            }
            if (entity instanceof Mob && ((Mob)entity).targetSelector.hasTasks()) {
                return 0;
            }
            if (entity instanceof Pillager) {
                Pillager pillager = (Pillager)entity;
            }
        }
        if (entity instanceof ExperienceOrb) {
            return 20;
        }
        return -1;
    }

    public static boolean checkIfActive(Entity entity) {
        if (entity.level().purpurConfig.squidImmuneToEAR && entity instanceof Squid) {
            return true;
        }
        if (entity instanceof FireworkRocketEntity) {
            return true;
        }
        if (entity.defaultActivationState || entity.tickCount < 200 || !entity.isAlive() || entity.portalProcess != null && !entity.portalProcess.hasExpired() || entity.portalCooldown > 0) {
            return true;
        }
        if (entity instanceof Mob && ((Mob)entity).getLeashHolder() instanceof Player) {
            return true;
        }
        boolean isActive = entity.activatedTick >= (long)MinecraftServer.currentTick;
        entity.isTemporarilyActive = false;
        if (!isActive) {
            if (((long)MinecraftServer.currentTick - entity.activatedTick - 1L) % 20L == 0L) {
                int immunity = ActivationRange.checkEntityImmunities(entity);
                if (immunity >= 0) {
                    entity.activatedTick = MinecraftServer.currentTick + immunity;
                } else {
                    entity.isTemporarilyActive = true;
                }
                isActive = true;
            } else if (entity instanceof ItemEntity && (entity.tickCount + 1 + entity.getId()) % 4 == 0) {
                isActive = true;
            }
        }
        return isActive;
    }

    public static enum ActivationType {
        WATER,
        FLYING_MONSTER,
        VILLAGER,
        MONSTER,
        ANIMAL,
        RAIDER,
        MISC;

        AABB boundingBox = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }
}

