/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.mariadb.jdbc.Connection;
import org.mariadb.jdbc.MariaDbBlob;
import org.mariadb.jdbc.Statement;
import org.mariadb.jdbc.client.Column;
import org.mariadb.jdbc.client.util.Parameter;
import org.mariadb.jdbc.client.util.Parameters;
import org.mariadb.jdbc.codec.ParameterWithCal;
import org.mariadb.jdbc.export.ExceptionFactory;
import org.mariadb.jdbc.export.Prepare;
import org.mariadb.jdbc.plugin.Codec;
import org.mariadb.jdbc.plugin.codec.BigDecimalCodec;
import org.mariadb.jdbc.plugin.codec.BlobCodec;
import org.mariadb.jdbc.plugin.codec.BooleanCodec;
import org.mariadb.jdbc.plugin.codec.ByteArrayCodec;
import org.mariadb.jdbc.plugin.codec.ByteCodec;
import org.mariadb.jdbc.plugin.codec.ClobCodec;
import org.mariadb.jdbc.plugin.codec.DateCodec;
import org.mariadb.jdbc.plugin.codec.DoubleCodec;
import org.mariadb.jdbc.plugin.codec.FloatCodec;
import org.mariadb.jdbc.plugin.codec.IntCodec;
import org.mariadb.jdbc.plugin.codec.LongCodec;
import org.mariadb.jdbc.plugin.codec.ReaderCodec;
import org.mariadb.jdbc.plugin.codec.ShortCodec;
import org.mariadb.jdbc.plugin.codec.StreamCodec;
import org.mariadb.jdbc.plugin.codec.StringCodec;
import org.mariadb.jdbc.plugin.codec.TimeCodec;
import org.mariadb.jdbc.plugin.codec.TimestampCodec;
import org.mariadb.jdbc.util.ParameterList;

public abstract class BasePreparedStatement
extends Statement
implements PreparedStatement {
    protected Parameters parameters;
    protected List<Parameters> batchParameters;
    protected final String sql;
    protected Prepare prepareResult = null;

    public BasePreparedStatement(String sql, Connection con, ReentrantLock lock, boolean canUseServerTimeout, boolean canUseServerMaxRows, int autoGeneratedKeys, int resultSetType, int resultSetConcurrency, int defaultFetchSize) {
        super(con, lock, canUseServerTimeout, canUseServerMaxRows, autoGeneratedKeys, resultSetType, resultSetConcurrency, defaultFetchSize);
        this.sql = sql;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("sql:'" + this.sql + "'");
        sb.append(", parameters:[");
        for (int i = 0; i < this.parameters.size(); ++i) {
            Parameter param = this.parameters.get(i);
            if (param == null) {
                sb.append("null");
            } else {
                sb.append(param.bestEffortStringValue(this.con.getContext()));
            }
            if (i == this.parameters.size() - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    public void setPrepareResult(Prepare prepareResult) {
        this.prepareResult = prepareResult;
    }

    public Column[] getMeta() {
        return this.prepareResult.getColumns();
    }

    public void updateMeta(Column[] ci) {
        this.prepareResult.setColumns(ci);
    }

    @Override
    public abstract boolean execute() throws SQLException;

    @Override
    public abstract ResultSet executeQuery() throws SQLException;

    @Override
    public abstract int executeUpdate() throws SQLException;

    @Override
    public abstract long executeLargeUpdate() throws SQLException;

    @Override
    public abstract void addBatch() throws SQLException;

    @Override
    public abstract ResultSetMetaData getMetaData() throws SQLException;

    @Override
    public abstract ParameterMetaData getParameterMetaData() throws SQLException;

    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
    }

    public void setParameter(int index, Parameter param) {
        this.parameters.set(index, param);
    }

    @Override
    public abstract int[] executeBatch() throws SQLException;

    @Override
    public abstract long[] executeLargeBatch() throws SQLException;

    @Override
    public void addBatch(String sql) throws SQLException {
        throw this.exceptionFactory().create("addBatch(String sql) cannot be called on preparedStatement");
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        throw this.exceptionFactory().create("execute(String sql) cannot be called on preparedStatement");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw this.exceptionFactory().create("execute(String sql, int autoGeneratedKeys) cannot be called on preparedStatement");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw this.exceptionFactory().create("execute(String sql, int[] columnIndexes) cannot be called on preparedStatement");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw this.exceptionFactory().create("execute(String sql, String[] columnNames) cannot be called on preparedStatement");
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        throw this.exceptionFactory().create("executeQuery(String sql) cannot be called on preparedStatement");
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw this.exceptionFactory().create("executeUpdate(String sql) cannot be called on preparedStatement");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw this.exceptionFactory().create("executeUpdate(String sql, int autoGeneratedKeys) cannot be called on preparedStatement");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw this.exceptionFactory().create("executeUpdate(String sql, int[] columnIndexes) cannot be called on preparedStatement");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw this.exceptionFactory().create("executeUpdate(String sql, String[] columnNames) cannot be called on preparedStatement");
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        throw this.exceptionFactory().create("executeLargeUpdate(String sql) cannot be called on preparedStatement");
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw this.exceptionFactory().create("executeLargeUpdate(String sql, int autoGeneratedKeys) cannot be called on preparedStatement");
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw this.exceptionFactory().create("executeLargeUpdate(String sql, int[] columnIndexes) cannot be called on preparedStatement");
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        throw this.exceptionFactory().create("executeLargeUpdate(String sql, String[] columnNames) cannot be called on preparedStatement");
    }

    private void checkIndex(int index) throws SQLException {
        if (index <= 0) {
            throw this.exceptionFactory().create(String.format("wrong parameter index %s", index));
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, org.mariadb.jdbc.codec.Parameter.NULL_PARAMETER);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<Boolean>(BooleanCodec.INSTANCE, x));
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<Byte>(ByteCodec.INSTANCE, x));
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<Short>(ShortCodec.INSTANCE, x));
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<Integer>(IntCodec.INSTANCE, x));
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<Long>(LongCodec.INSTANCE, x));
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<Float>(FloatCodec.INSTANCE, Float.valueOf(x)));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<Double>(DoubleCodec.INSTANCE, x));
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<BigDecimal>(BigDecimalCodec.INSTANCE, x));
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<String>(StringCodec.INSTANCE, x));
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<byte[]>(ByteArrayCodec.INSTANCE, x));
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<Date>(DateCodec.INSTANCE, x));
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<Time>(TimeCodec.INSTANCE, x));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<Timestamp>(TimestampCodec.INSTANCE, x));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<InputStream>(StreamCodec.INSTANCE, x, Long.valueOf(length)));
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<InputStream>(StreamCodec.INSTANCE, x, Long.valueOf(length)));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<InputStream>(StreamCodec.INSTANCE, x, Long.valueOf(length)));
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkNotClosed();
        this.parameters = new ParameterList();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setInternalObject(parameterIndex, x, targetSqlType, null);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.setInternalObject(parameterIndex, x, null, null);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<Reader>(ReaderCodec.INSTANCE, reader, Long.valueOf(length)));
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw this.exceptionFactory().notSupported("REF parameter are not supported");
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<Blob>(BlobCodec.INSTANCE, x));
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<Clob>(ClobCodec.INSTANCE, x));
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw this.exceptionFactory().notSupported("Array parameter are not supported");
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new ParameterWithCal<Date>(DateCodec.INSTANCE, x, cal));
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new ParameterWithCal<Time>(TimeCodec.INSTANCE, x, cal));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new ParameterWithCal<Timestamp>(TimestampCodec.INSTANCE, x, cal));
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, org.mariadb.jdbc.codec.Parameter.NULL_PARAMETER);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<String>(StringCodec.INSTANCE, x.toString()));
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw this.exceptionFactory().notSupported("RowId parameter are not supported");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<String>(StringCodec.INSTANCE, value));
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<Reader>(ReaderCodec.INSTANCE, value, length));
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<NClob>(ClobCodec.INSTANCE, value));
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<Reader>(ReaderCodec.INSTANCE, reader, length));
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<InputStream>(StreamCodec.INSTANCE, inputStream, length));
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<Reader>(ReaderCodec.INSTANCE, reader, length));
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw this.exceptionFactory().notSupported("SQLXML parameter are not supported");
    }

    private ExceptionFactory exceptionFactory() {
        return this.con.getExceptionFactory().of(this);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.setInternalObject(parameterIndex, x, targetSqlType, Long.valueOf(scaleOrLength));
    }

    private void setInternalObject(int parameterIndex, Object obj, Integer targetSqlType, Long scaleOrLength) throws SQLException {
        this.checkIndex(parameterIndex);
        if (obj == null) {
            this.parameters.set(parameterIndex - 1, org.mariadb.jdbc.codec.Parameter.NULL_PARAMETER);
            return;
        }
        if (targetSqlType != null) {
            switch (targetSqlType) {
                case -8: 
                case 70: 
                case 2000: 
                case 2002: 
                case 2003: 
                case 2006: 
                case 2009: {
                    throw this.exceptionFactory().notSupported("Type not supported");
                }
            }
            if (obj instanceof String || obj instanceof Character) {
                if (targetSqlType == 2004) {
                    throw this.exceptionFactory().create(String.format("Cannot convert a %s to a Blob", obj instanceof String ? "string" : "character"));
                }
                String str = obj instanceof String ? (String)obj : ((Character)obj).toString();
                try {
                    switch (targetSqlType) {
                        case -7: 
                        case 16: {
                            this.setBoolean(parameterIndex, !"false".equalsIgnoreCase(str) && !"0".equals(str));
                            return;
                        }
                        case -6: {
                            this.setByte(parameterIndex, Byte.parseByte(str));
                            return;
                        }
                        case 5: {
                            this.setShort(parameterIndex, Short.parseShort(str));
                            return;
                        }
                        case 4: {
                            this.setInt(parameterIndex, Integer.parseInt(str));
                            return;
                        }
                        case 6: 
                        case 8: {
                            this.setDouble(parameterIndex, Double.valueOf(str));
                            return;
                        }
                        case 7: {
                            this.setFloat(parameterIndex, Float.valueOf(str).floatValue());
                            return;
                        }
                        case -5: {
                            this.setLong(parameterIndex, Long.valueOf(str));
                            return;
                        }
                        case 2: 
                        case 3: {
                            this.setBigDecimal(parameterIndex, new BigDecimal(str));
                            return;
                        }
                        case -16: 
                        case -15: 
                        case -9: 
                        case -1: 
                        case 1: 
                        case 12: 
                        case 2005: 
                        case 2011: {
                            this.setString(parameterIndex, str);
                            return;
                        }
                        case 93: {
                            if (str.startsWith("0000-00-00")) {
                                this.setTimestamp(parameterIndex, null);
                            } else {
                                this.setTimestamp(parameterIndex, Timestamp.valueOf(str));
                            }
                            return;
                        }
                        case 92: {
                            this.setTime(parameterIndex, Time.valueOf((String)obj));
                            return;
                        }
                    }
                    throw this.exceptionFactory().create(String.format("Could not convert [%s] to %s", str, targetSqlType));
                }
                catch (IllegalArgumentException e) {
                    throw this.exceptionFactory().create(String.format("Could not convert [%s] to java.sql.Type %s", str, targetSqlType), "HY000", e);
                }
            }
            if (obj instanceof Number) {
                Number bd = (Number)obj;
                switch (targetSqlType) {
                    case -6: {
                        this.setByte(parameterIndex, bd.byteValue());
                        return;
                    }
                    case 5: {
                        this.setShort(parameterIndex, bd.shortValue());
                        return;
                    }
                    case 4: {
                        this.setInt(parameterIndex, bd.intValue());
                        return;
                    }
                    case -5: {
                        this.setLong(parameterIndex, bd.longValue());
                        return;
                    }
                    case 6: 
                    case 8: {
                        this.setDouble(parameterIndex, bd.doubleValue());
                        return;
                    }
                    case 7: {
                        this.setFloat(parameterIndex, bd.floatValue());
                        return;
                    }
                    case 2: 
                    case 3: {
                        if (obj instanceof BigDecimal) {
                            this.setBigDecimal(parameterIndex, (BigDecimal)obj);
                        } else if (obj instanceof Double || obj instanceof Float) {
                            this.setDouble(parameterIndex, bd.doubleValue());
                        } else {
                            this.setLong(parameterIndex, bd.longValue());
                        }
                        return;
                    }
                    case -7: {
                        this.setBoolean(parameterIndex, bd.shortValue() != 0);
                        return;
                    }
                    case 1: 
                    case 12: {
                        this.setString(parameterIndex, bd.toString());
                        return;
                    }
                }
                throw this.exceptionFactory().create(String.format("Could not convert [%s] to %s", bd, targetSqlType));
            }
            if (obj instanceof byte[]) {
                if (targetSqlType == -2 || targetSqlType == -3 || targetSqlType == -4) {
                    this.setBytes(parameterIndex, (byte[])obj);
                    return;
                }
                if (targetSqlType == 2004) {
                    this.setBlob(parameterIndex, new MariaDbBlob((byte[])obj));
                } else {
                    throw this.exceptionFactory().create("Can only convert a byte[] to BINARY, VARBINARY, LONGVARBINARY or BLOB type");
                }
            }
        }
        for (Codec<?> codec : this.con.getContext().getConf().codecs()) {
            if (!codec.canEncode(obj)) continue;
            org.mariadb.jdbc.codec.Parameter<Object> p = new org.mariadb.jdbc.codec.Parameter<Object>(codec, obj, scaleOrLength);
            this.parameters.set(parameterIndex - 1, p);
            return;
        }
        throw new SQLException(String.format("Type %s not supported type", obj.getClass().getName()));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<InputStream>(StreamCodec.INSTANCE, x, length));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<InputStream>(StreamCodec.INSTANCE, x, length));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<Reader>(ReaderCodec.INSTANCE, reader, length));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<InputStream>(StreamCodec.INSTANCE, x));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<InputStream>(StreamCodec.INSTANCE, x));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<Reader>(ReaderCodec.INSTANCE, reader));
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<Reader>(ReaderCodec.INSTANCE, value));
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<Reader>(ReaderCodec.INSTANCE, reader));
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<InputStream>(StreamCodec.INSTANCE, inputStream));
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<Reader>(ReaderCodec.INSTANCE, reader));
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.setInternalObject(parameterIndex, x, targetSqlType == null ? null : targetSqlType.getVendorTypeNumber(), Long.valueOf(scaleOrLength));
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        this.setInternalObject(parameterIndex, x, targetSqlType == null ? null : targetSqlType.getVendorTypeNumber(), null);
    }
}

