/*
 * Decompiled with CFR 0.152.
 */
package gg.pufferfish.pufferfish.sentry;

import com.google.gson.Gson;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.ThreadContext;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;
import org.jetbrains.annotations.Nullable;

public class SentryContext {
    private static final Gson GSON = new Gson();

    public static void setPluginContext(@Nullable Plugin plugin) {
        if (plugin != null) {
            ThreadContext.put((String)"pufferfishsentry_pluginname", (String)plugin.getName());
            ThreadContext.put((String)"pufferfishsentry_pluginversion", (String)plugin.getDescription().getVersion());
        }
    }

    public static void removePluginContext() {
        ThreadContext.remove((String)"pufferfishsentry_pluginname");
        ThreadContext.remove((String)"pufferfishsentry_pluginversion");
    }

    public static void setSenderContext(@Nullable CommandSender sender) {
        if (sender != null) {
            ThreadContext.put((String)"pufferfishsentry_playername", (String)sender.getName());
            if (sender instanceof Player) {
                Player player = (Player)sender;
                ThreadContext.put((String)"pufferfishsentry_playerid", (String)player.getUniqueId().toString());
            }
        }
    }

    public static void removeSenderContext() {
        ThreadContext.remove((String)"pufferfishsentry_playername");
        ThreadContext.remove((String)"pufferfishsentry_playerid");
    }

    public static void setEventContext(Event event, RegisteredListener registration) {
        SentryContext.setPluginContext(registration.getPlugin());
        try {
            Player player = null;
            if (event instanceof PlayerEvent) {
                player = ((PlayerEvent)event).getPlayer();
            } else {
                Class<?> eventClass = event.getClass();
                Field playerField = null;
                for (Field field : eventClass.getDeclaredFields()) {
                    if (!field.getType().equals(Player.class)) continue;
                    playerField = field;
                    break;
                }
                if (playerField != null) {
                    playerField.setAccessible(true);
                    player = (Player)playerField.get(event);
                }
            }
            if (player != null) {
                SentryContext.setSenderContext(player);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ThreadContext.put((String)"pufferfishsentry_eventdata", (String)GSON.toJson(SentryContext.serializeFields(event)));
    }

    public static void removeEventContext() {
        SentryContext.removePluginContext();
        SentryContext.removeSenderContext();
        ThreadContext.remove((String)"pufferfishsentry_eventdata");
    }

    private static Map<String, String> serializeFields(Object object) {
        TreeMap<String, String> fields = new TreeMap<String, String>();
        fields.put("_class", object.getClass().getName());
        for (Field declaredField : object.getClass().getDeclaredFields()) {
            try {
                String fieldName;
                if (Modifier.isStatic(declaredField.getModifiers()) || (fieldName = declaredField.getName()).equals("handlers")) continue;
                declaredField.setAccessible(true);
                Object value = declaredField.get(object);
                if (value != null) {
                    fields.put(fieldName, value.toString());
                    continue;
                }
                fields.put(fieldName, "<null>");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return fields;
    }

    public static class State {
        private Plugin plugin;
        private Command command;
        private String commandLine;
        private Event event;
        private RegisteredListener registeredListener;

        public Plugin getPlugin() {
            return this.plugin;
        }

        public void setPlugin(Plugin plugin) {
            this.plugin = plugin;
        }

        public Command getCommand() {
            return this.command;
        }

        public void setCommand(Command command) {
            this.command = command;
        }

        public String getCommandLine() {
            return this.commandLine;
        }

        public void setCommandLine(String commandLine) {
            this.commandLine = commandLine;
        }

        public Event getEvent() {
            return this.event;
        }

        public void setEvent(Event event) {
            this.event = event;
        }

        public RegisteredListener getRegisteredListener() {
            return this.registeredListener;
        }

        public void setRegisteredListener(RegisteredListener registeredListener) {
            this.registeredListener = registeredListener;
        }
    }
}

