/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.math;

import io.papermc.paper.math.BlockPosition;
import io.papermc.paper.math.BlockPositionImpl;
import io.papermc.paper.math.FinePosition;
import io.papermc.paper.math.FinePositionImpl;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public interface Position {
    public static final FinePosition FINE_ZERO = new FinePositionImpl(0.0, 0.0, 0.0);
    public static final BlockPosition BLOCK_ZERO = new BlockPositionImpl(0, 0, 0);

    public int blockX();

    public int blockY();

    public int blockZ();

    public double x();

    public double y();

    public double z();

    public boolean isBlock();

    public boolean isFine();

    @NotNull
    public Position offset(int var1, int var2, int var3);

    @NotNull
    public FinePosition offset(double var1, double var3, double var5);

    @Contract(value="-> new", pure=true)
    @NotNull
    default public FinePosition toCenter() {
        return new FinePositionImpl((double)this.blockX() + 0.5, (double)this.blockY() + 0.5, (double)this.blockZ() + 0.5);
    }

    @Contract(pure=true)
    @NotNull
    public BlockPosition toBlock();

    @Contract(value="-> new", pure=true)
    @NotNull
    default public Vector toVector() {
        return new Vector(this.x(), this.y(), this.z());
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    default public Location toLocation(@NotNull World world) {
        return new Location(world, this.x(), this.y(), this.z());
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static BlockPosition block(int x, int y, int z) {
        return new BlockPositionImpl(x, y, z);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static BlockPosition block(@NotNull Location location) {
        return new BlockPositionImpl(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static FinePosition fine(double x, double y, double z) {
        return new FinePositionImpl(x, y, z);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static FinePosition fine(@NotNull Location location) {
        return new FinePositionImpl(location.getX(), location.getY(), location.getZ());
    }
}

