/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.paper;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import me.lucko.spark.api.Spark;
import me.lucko.spark.paper.PaperClassSourceLookup;
import me.lucko.spark.paper.PaperCommandSender;
import me.lucko.spark.paper.PaperPlatformInfo;
import me.lucko.spark.paper.PaperPlayerPingProvider;
import me.lucko.spark.paper.PaperServerConfigProvider;
import me.lucko.spark.paper.PaperTickHook;
import me.lucko.spark.paper.PaperTickReporter;
import me.lucko.spark.paper.PaperWorldInfoProvider;
import me.lucko.spark.paper.api.PaperClassLookup;
import me.lucko.spark.paper.api.PaperScheduler;
import me.lucko.spark.paper.api.PaperSparkModule;
import me.lucko.spark.paper.common.SparkPlatform;
import me.lucko.spark.paper.common.SparkPlugin;
import me.lucko.spark.paper.common.monitor.ping.PlayerPingProvider;
import me.lucko.spark.paper.common.platform.PlatformInfo;
import me.lucko.spark.paper.common.platform.serverconfig.ServerConfigProvider;
import me.lucko.spark.paper.common.platform.world.WorldInfoProvider;
import me.lucko.spark.paper.common.sampler.ThreadDumper;
import me.lucko.spark.paper.common.sampler.source.ClassSourceLookup;
import me.lucko.spark.paper.common.sampler.source.SourceMetadata;
import me.lucko.spark.paper.common.tick.TickHook;
import me.lucko.spark.paper.common.tick.TickReporter;
import me.lucko.spark.paper.common.util.classfinder.ClassFinder;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class PaperSparkPlugin
implements PaperSparkModule,
SparkPlugin {
    private final Server server;
    private final Logger logger;
    private final PaperScheduler scheduler;
    private final PaperClassLookup classLookup;
    private final PaperTickHook tickHook;
    private final PaperTickReporter tickReporter;
    private final ThreadDumper gameThreadDumper;
    private final SparkPlatform platform;

    public PaperSparkPlugin(Server server, Logger logger, PaperScheduler scheduler, PaperClassLookup classLookup) {
        this.server = server;
        this.logger = logger;
        this.scheduler = scheduler;
        this.classLookup = classLookup;
        this.tickHook = new PaperTickHook();
        this.tickReporter = new PaperTickReporter();
        this.gameThreadDumper = new ThreadDumper.Specific(Thread.currentThread());
        this.platform = new SparkPlatform(this);
    }

    @Override
    public void enable() {
        this.platform.enable();
    }

    @Override
    public void disable() {
        this.platform.disable();
    }

    @Override
    public void executeCommand(CommandSender sender, String[] args) {
        this.platform.executeCommand(new PaperCommandSender(sender), args);
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String[] args) {
        return this.platform.tabCompleteCommand(new PaperCommandSender(sender), args);
    }

    @Override
    public boolean hasPermission(CommandSender sender) {
        return this.platform.hasPermissionForAnyCommand(new PaperCommandSender(sender));
    }

    @Override
    public Collection<String> getPermissions() {
        return this.platform.getAllSparkPermissions();
    }

    @Override
    public void onServerTickStart() {
        this.tickHook.onTick();
    }

    @Override
    public void onServerTickEnd(double duration) {
        this.tickReporter.onTick(duration);
    }

    @Override
    public String getVersion() {
        return "1.10.105";
    }

    @Override
    public Path getPluginDirectory() {
        return this.server.getPluginsFolder().toPath().resolve("spark");
    }

    @Override
    public String getCommandName() {
        return "spark";
    }

    public Stream<PaperCommandSender> getCommandSenders() {
        return Stream.concat(this.server.getOnlinePlayers().stream(), Stream.of(this.server.getConsoleSender())).map(x$0 -> new PaperCommandSender((CommandSender)x$0));
    }

    @Override
    public void executeAsync(Runnable task) {
        this.scheduler.executeAsync(task);
    }

    @Override
    public void executeSync(Runnable task) {
        this.scheduler.executeSync(task);
    }

    @Override
    public void log(Level level, String msg) {
        this.logger.log(level, msg);
    }

    @Override
    public ThreadDumper getDefaultThreadDumper() {
        return this.gameThreadDumper;
    }

    @Override
    public TickHook createTickHook() {
        return this.tickHook;
    }

    @Override
    public TickReporter createTickReporter() {
        return this.tickReporter;
    }

    @Override
    public ClassSourceLookup createClassSourceLookup() {
        return new PaperClassSourceLookup();
    }

    @Override
    public ClassFinder createClassFinder() {
        return className -> {
            try {
                return this.classLookup.lookup(className);
            }
            catch (Exception e) {
                return null;
            }
        };
    }

    @Override
    public Collection<SourceMetadata> getKnownSources() {
        return SourceMetadata.gather(Arrays.asList(this.server.getPluginManager().getPlugins()), Plugin::getName, plugin -> plugin.getPluginMeta().getVersion(), plugin -> String.join((CharSequence)", ", plugin.getPluginMeta().getAuthors()), plugin -> plugin.getPluginMeta().getDescription());
    }

    @Override
    public PlayerPingProvider createPlayerPingProvider() {
        return new PaperPlayerPingProvider(this.server);
    }

    @Override
    public ServerConfigProvider createServerConfigProvider() {
        return new PaperServerConfigProvider();
    }

    @Override
    public WorldInfoProvider createWorldInfoProvider() {
        return new PaperWorldInfoProvider(this.server);
    }

    @Override
    public PlatformInfo getPlatformInfo() {
        return PaperPlatformInfo.INSTANCE;
    }

    @Override
    public void registerApi(Spark api) {
    }
}

