/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.concurrentutil.executor.queue;

import ca.spottedleaf.concurrentutil.executor.PrioritisedExecutor;
import ca.spottedleaf.concurrentutil.util.ConcurrentUtil;
import ca.spottedleaf.concurrentutil.util.Priority;
import java.lang.invoke.VarHandle;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public final class PrioritisedTaskQueue
implements PrioritisedExecutor {
    private final AtomicLong taskIdGenerator = new AtomicLong();
    private final AtomicLong scheduledTasks = new AtomicLong();
    private final AtomicLong executedTasks = new AtomicLong();
    private final AtomicLong subOrderGenerator = new AtomicLong();
    private final AtomicBoolean shutdown = new AtomicBoolean();
    private final ConcurrentSkipListMap<PrioritisedQueuedTask.Holder, Boolean> tasks = new ConcurrentSkipListMap(PrioritisedQueuedTask.COMPARATOR);

    @Override
    public long getTotalTasksScheduled() {
        return this.scheduledTasks.get();
    }

    @Override
    public long getTotalTasksExecuted() {
        return this.executedTasks.get();
    }

    @Override
    public long generateNextSubOrder() {
        return this.subOrderGenerator.getAndIncrement();
    }

    @Override
    public boolean shutdown() {
        return !this.shutdown.getAndSet(true);
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown.get();
    }

    public PrioritisedExecutor.PrioritisedTask peekFirst() {
        Map.Entry<PrioritisedQueuedTask.Holder, Boolean> firstEntry = this.tasks.firstEntry();
        return firstEntry == null ? null : firstEntry.getKey().task;
    }

    public Priority getHighestPriority() {
        Map.Entry<PrioritisedQueuedTask.Holder, Boolean> firstEntry = this.tasks.firstEntry();
        return firstEntry == null ? null : Priority.getPriority(firstEntry.getKey().priority);
    }

    public boolean hasNoScheduledTasks() {
        long scheduledTasks;
        long executedTasks = this.executedTasks.get();
        return executedTasks == (scheduledTasks = this.scheduledTasks.get());
    }

    public PrioritySubOrderPair getHighestPrioritySubOrder() {
        Map.Entry<PrioritisedQueuedTask.Holder, Boolean> firstEntry = this.tasks.firstEntry();
        if (firstEntry == null) {
            return null;
        }
        PrioritisedQueuedTask.Holder holder = firstEntry.getKey();
        return new PrioritySubOrderPair(Priority.getPriority(holder.priority), holder.subOrder);
    }

    public Runnable pollTask() {
        Map.Entry<PrioritisedQueuedTask.Holder, Boolean> firstEntry;
        while ((firstEntry = this.tasks.pollFirstEntry()) != null) {
            PrioritisedQueuedTask.Holder task = firstEntry.getKey();
            task.markRemoved();
            if (!task.task.cancel()) continue;
            return task.task.execute;
        }
        return null;
    }

    @Override
    public boolean executeTask() {
        Map.Entry<PrioritisedQueuedTask.Holder, Boolean> firstEntry;
        while ((firstEntry = this.tasks.pollFirstEntry()) != null) {
            PrioritisedQueuedTask.Holder task = firstEntry.getKey();
            task.markRemoved();
            if (!task.task.execute()) continue;
            return true;
        }
        return false;
    }

    @Override
    public PrioritisedExecutor.PrioritisedTask createTask(Runnable task) {
        return this.createTask(task, Priority.NORMAL, this.generateNextSubOrder());
    }

    @Override
    public PrioritisedExecutor.PrioritisedTask createTask(Runnable task, Priority priority) {
        return this.createTask(task, priority, this.generateNextSubOrder());
    }

    @Override
    public PrioritisedExecutor.PrioritisedTask createTask(Runnable task, Priority priority, long subOrder) {
        return new PrioritisedQueuedTask(task, priority, subOrder);
    }

    @Override
    public PrioritisedExecutor.PrioritisedTask queueTask(Runnable task) {
        return this.queueTask(task, Priority.NORMAL, this.generateNextSubOrder());
    }

    @Override
    public PrioritisedExecutor.PrioritisedTask queueTask(Runnable task, Priority priority) {
        return this.queueTask(task, priority, this.generateNextSubOrder());
    }

    @Override
    public PrioritisedExecutor.PrioritisedTask queueTask(Runnable task, Priority priority, long subOrder) {
        PrioritisedQueuedTask ret = new PrioritisedQueuedTask(task, priority, subOrder);
        ret.queue();
        return ret;
    }

    private final class PrioritisedQueuedTask
    implements PrioritisedExecutor.PrioritisedTask {
        public static final Comparator<Holder> COMPARATOR = (t1, t2) -> {
            int priorityCompare = t1.priority - t2.priority;
            if (priorityCompare != 0) {
                return priorityCompare;
            }
            int subOrderCompare = Long.compare(t1.subOrder, t2.subOrder);
            if (subOrderCompare != 0) {
                return subOrderCompare;
            }
            return Long.compare(t1.id, t2.id);
        };
        private final long id;
        private final Runnable execute;
        private Priority priority;
        private long subOrder;
        private Holder holder;

        public PrioritisedQueuedTask(Runnable execute, Priority priority, long subOrder) {
            if (!Priority.isValidPriority(priority)) {
                throw new IllegalArgumentException("Invalid priority " + String.valueOf((Object)priority));
            }
            this.execute = execute;
            this.priority = priority;
            this.subOrder = subOrder;
            this.id = PrioritisedTaskQueue.this.taskIdGenerator.getAndIncrement();
        }

        @Override
        public PrioritisedExecutor getExecutor() {
            return PrioritisedTaskQueue.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean queue() {
            PrioritisedQueuedTask prioritisedQueuedTask = this;
            synchronized (prioritisedQueuedTask) {
                Holder holder;
                if (this.holder != null || this.priority == Priority.COMPLETING) {
                    return false;
                }
                if (PrioritisedTaskQueue.this.isShutdown()) {
                    throw new IllegalStateException("Queue is shutdown");
                }
                this.holder = holder = new Holder(this, this.priority.priority, this.subOrder, this.id);
                PrioritisedTaskQueue.this.scheduledTasks.getAndIncrement();
                PrioritisedTaskQueue.this.tasks.put(holder, Boolean.TRUE);
            }
            if (PrioritisedTaskQueue.this.isShutdown()) {
                this.cancel();
                throw new IllegalStateException("Queue is shutdown");
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isQueued() {
            PrioritisedQueuedTask prioritisedQueuedTask = this;
            synchronized (prioritisedQueuedTask) {
                return this.holder != null && this.priority != Priority.COMPLETING;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel() {
            PrioritisedQueuedTask prioritisedQueuedTask = this;
            synchronized (prioritisedQueuedTask) {
                if (this.priority == Priority.COMPLETING) {
                    return false;
                }
                this.priority = Priority.COMPLETING;
                if (this.holder != null) {
                    if (this.holder.markRemoved()) {
                        PrioritisedTaskQueue.this.tasks.remove(this.holder);
                    }
                    PrioritisedTaskQueue.this.executedTasks.getAndIncrement();
                }
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean execute() {
            boolean increaseExecuted;
            PrioritisedQueuedTask prioritisedQueuedTask = this;
            synchronized (prioritisedQueuedTask) {
                if (this.priority == Priority.COMPLETING) {
                    return false;
                }
                this.priority = Priority.COMPLETING;
                increaseExecuted = this.holder != null;
                if (increaseExecuted && this.holder.markRemoved()) {
                    PrioritisedTaskQueue.this.tasks.remove(this.holder);
                }
            }
            try {
                this.execute.run();
                boolean bl = true;
                return bl;
            }
            finally {
                if (increaseExecuted) {
                    PrioritisedTaskQueue.this.executedTasks.getAndIncrement();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Priority getPriority() {
            PrioritisedQueuedTask prioritisedQueuedTask = this;
            synchronized (prioritisedQueuedTask) {
                return this.priority;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setPriority(Priority priority) {
            PrioritisedQueuedTask prioritisedQueuedTask = this;
            synchronized (prioritisedQueuedTask) {
                if (this.priority == Priority.COMPLETING || this.priority == priority) {
                    return false;
                }
                this.priority = priority;
                if (this.holder != null) {
                    if (this.holder.markRemoved()) {
                        PrioritisedTaskQueue.this.tasks.remove(this.holder);
                    }
                    this.holder = new Holder(this, priority.priority, this.subOrder, this.id);
                    PrioritisedTaskQueue.this.tasks.put(this.holder, Boolean.TRUE);
                }
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean raisePriority(Priority priority) {
            PrioritisedQueuedTask prioritisedQueuedTask = this;
            synchronized (prioritisedQueuedTask) {
                if (this.priority == Priority.COMPLETING || this.priority.isHigherOrEqualPriority(priority)) {
                    return false;
                }
                this.priority = priority;
                if (this.holder != null) {
                    if (this.holder.markRemoved()) {
                        PrioritisedTaskQueue.this.tasks.remove(this.holder);
                    }
                    this.holder = new Holder(this, priority.priority, this.subOrder, this.id);
                    PrioritisedTaskQueue.this.tasks.put(this.holder, Boolean.TRUE);
                }
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean lowerPriority(Priority priority) {
            PrioritisedQueuedTask prioritisedQueuedTask = this;
            synchronized (prioritisedQueuedTask) {
                if (this.priority == Priority.COMPLETING || this.priority.isLowerOrEqualPriority(priority)) {
                    return false;
                }
                this.priority = priority;
                if (this.holder != null) {
                    if (this.holder.markRemoved()) {
                        PrioritisedTaskQueue.this.tasks.remove(this.holder);
                    }
                    this.holder = new Holder(this, priority.priority, this.subOrder, this.id);
                    PrioritisedTaskQueue.this.tasks.put(this.holder, Boolean.TRUE);
                }
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getSubOrder() {
            PrioritisedQueuedTask prioritisedQueuedTask = this;
            synchronized (prioritisedQueuedTask) {
                return this.subOrder;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setSubOrder(long subOrder) {
            PrioritisedQueuedTask prioritisedQueuedTask = this;
            synchronized (prioritisedQueuedTask) {
                if (this.priority == Priority.COMPLETING || this.subOrder == subOrder) {
                    return false;
                }
                this.subOrder = subOrder;
                if (this.holder != null) {
                    if (this.holder.markRemoved()) {
                        PrioritisedTaskQueue.this.tasks.remove(this.holder);
                    }
                    this.holder = new Holder(this, this.priority.priority, this.subOrder, this.id);
                    PrioritisedTaskQueue.this.tasks.put(this.holder, Boolean.TRUE);
                }
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean raiseSubOrder(long subOrder) {
            PrioritisedQueuedTask prioritisedQueuedTask = this;
            synchronized (prioritisedQueuedTask) {
                if (this.priority == Priority.COMPLETING || this.subOrder >= subOrder) {
                    return false;
                }
                this.subOrder = subOrder;
                if (this.holder != null) {
                    if (this.holder.markRemoved()) {
                        PrioritisedTaskQueue.this.tasks.remove(this.holder);
                    }
                    this.holder = new Holder(this, this.priority.priority, this.subOrder, this.id);
                    PrioritisedTaskQueue.this.tasks.put(this.holder, Boolean.TRUE);
                }
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean lowerSubOrder(long subOrder) {
            PrioritisedQueuedTask prioritisedQueuedTask = this;
            synchronized (prioritisedQueuedTask) {
                if (this.priority == Priority.COMPLETING || this.subOrder <= subOrder) {
                    return false;
                }
                this.subOrder = subOrder;
                if (this.holder != null) {
                    if (this.holder.markRemoved()) {
                        PrioritisedTaskQueue.this.tasks.remove(this.holder);
                    }
                    this.holder = new Holder(this, this.priority.priority, this.subOrder, this.id);
                    PrioritisedTaskQueue.this.tasks.put(this.holder, Boolean.TRUE);
                }
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setPriorityAndSubOrder(Priority priority, long subOrder) {
            PrioritisedQueuedTask prioritisedQueuedTask = this;
            synchronized (prioritisedQueuedTask) {
                if (this.priority == Priority.COMPLETING || this.priority == priority && this.subOrder == subOrder) {
                    return false;
                }
                this.priority = priority;
                this.subOrder = subOrder;
                if (this.holder != null) {
                    if (this.holder.markRemoved()) {
                        PrioritisedTaskQueue.this.tasks.remove(this.holder);
                    }
                    this.holder = new Holder(this, priority.priority, this.subOrder, this.id);
                    PrioritisedTaskQueue.this.tasks.put(this.holder, Boolean.TRUE);
                }
                return true;
            }
        }

        private static final class Holder {
            private final PrioritisedQueuedTask task;
            private final int priority;
            private final long subOrder;
            private final long id;
            private volatile boolean removed;
            private static final VarHandle REMOVED_HANDLE = ConcurrentUtil.getVarHandle(Holder.class, "removed", Boolean.TYPE);

            private Holder(PrioritisedQueuedTask task, int priority, long subOrder, long id) {
                this.task = task;
                this.priority = priority;
                this.subOrder = subOrder;
                this.id = id;
            }

            public boolean markRemoved() {
                return !REMOVED_HANDLE.getAndSet(this, true);
            }
        }
    }

    public record PrioritySubOrderPair(Priority priority, long subOrder) {
    }
}

