/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.TypeUtil;
import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;

public final class V4068 {
    public static final Escaper ESCAPER = Escapers.builder().addEscape('\"', "\\\"").addEscape('\\', "\\\\").build();
    private static final int VERSION = 4068;

    private static void convertLock(MapType<String> root, String srcPath, String dstPath) {
        if (root == null) {
            return;
        }
        Object lockGeneric = root.getGeneric(srcPath);
        if (lockGeneric == null) {
            return;
        }
        TypeUtil typeUtil = root.getTypeUtil();
        MapType<String> newLock = typeUtil.createEmptyMap();
        root.remove(srcPath);
        root.setMap(dstPath, newLock);
        if (lockGeneric instanceof String) {
            String lock = (String)lockGeneric;
            MapType<String> lockComponents = typeUtil.createEmptyMap();
            newLock.setMap("components", lockComponents);
            lockComponents.setString("minecraft:custom_name", ESCAPER.escape(lock));
        }
    }

    public static void register() {
        MCTypeRegistry.ITEM_STACK.addStructureConverter(new DataConverter<MapType<String>, MapType<String>>(4068){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                MapType<String> components = data.getMap("components");
                if (components == null) {
                    return null;
                }
                V4068.convertLock(components, "minecraft:lock", "minecraft:lock");
                return null;
            }
        });
        MCTypeRegistry.TILE_ENTITY.addStructureConverter(new DataConverter<MapType<String>, MapType<String>>(4068){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                V4068.convertLock(data, "Lock", "lock");
                return null;
            }
        });
    }

    private V4068() {
    }
}

