/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.common.util;

import ca.spottedleaf.concurrentutil.util.Priority;
import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.patches.chunk_system.player.RegionizedPlayerChunkLoader;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.slf4j.Logger;

public final class ChunkSystem {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void scheduleChunkTask(ServerLevel level, int chunkX, int chunkZ, Runnable run) {
        ChunkSystem.scheduleChunkTask(level, chunkX, chunkZ, run, Priority.NORMAL);
    }

    public static void scheduleChunkTask(ServerLevel level, int chunkX, int chunkZ, Runnable run, Priority priority) {
        level.moonrise$getChunkTaskScheduler().scheduleChunkTask(chunkX, chunkZ, run, priority);
    }

    public static void scheduleChunkLoad(ServerLevel level, int chunkX, int chunkZ, boolean gen, ChunkStatus toStatus, boolean addTicket, Priority priority, Consumer<ChunkAccess> onComplete) {
        level.moonrise$getChunkTaskScheduler().scheduleChunkLoad(chunkX, chunkZ, gen, toStatus, addTicket, priority, onComplete);
    }

    public static void scheduleChunkLoad(ServerLevel level, int chunkX, int chunkZ, ChunkStatus toStatus, boolean addTicket, Priority priority, Consumer<ChunkAccess> onComplete) {
        level.moonrise$getChunkTaskScheduler().scheduleChunkLoad(chunkX, chunkZ, toStatus, addTicket, priority, onComplete);
    }

    public static void scheduleTickingState(ServerLevel level, int chunkX, int chunkZ, FullChunkStatus toStatus, boolean addTicket, Priority priority, Consumer<LevelChunk> onComplete) {
        level.moonrise$getChunkTaskScheduler().scheduleTickingState(chunkX, chunkZ, toStatus, addTicket, priority, onComplete);
    }

    public static List<ChunkHolder> getVisibleChunkHolders(ServerLevel level) {
        return level.moonrise$getChunkTaskScheduler().chunkHolderManager.getOldChunkHolders();
    }

    public static List<ChunkHolder> getUpdatingChunkHolders(ServerLevel level) {
        return level.moonrise$getChunkTaskScheduler().chunkHolderManager.getOldChunkHolders();
    }

    public static int getVisibleChunkHolderCount(ServerLevel level) {
        return level.moonrise$getChunkTaskScheduler().chunkHolderManager.size();
    }

    public static int getUpdatingChunkHolderCount(ServerLevel level) {
        return level.moonrise$getChunkTaskScheduler().chunkHolderManager.size();
    }

    public static boolean hasAnyChunkHolders(ServerLevel level) {
        return ChunkSystem.getUpdatingChunkHolderCount(level) != 0;
    }

    public static boolean screenEntity(ServerLevel level, Entity entity, boolean fromDisk, boolean event) {
        return PlatformHooks.get().screenEntity(level, entity, fromDisk, event);
    }

    public static void onChunkHolderCreate(ServerLevel level, ChunkHolder holder) {
    }

    public static void onChunkHolderDelete(ServerLevel level, ChunkHolder holder) {
        ChunkProgressListener progressListener = level.getChunkSource().chunkMap.progressListener;
        if (progressListener != null) {
            ChunkSystem.scheduleChunkTask(level, holder.getPos().x, holder.getPos().z, () -> progressListener.onStatusChange(holder.getPos(), null));
        }
    }

    public static void onChunkPreBorder(LevelChunk chunk, ChunkHolder holder) {
        ((ServerLevel)chunk.getLevel()).getChunkSource().moonrise$setFullChunk(chunk.getPos().x, chunk.getPos().z, chunk);
    }

    public static void onChunkBorder(LevelChunk chunk, ChunkHolder holder) {
        ((ServerLevel)chunk.getLevel()).moonrise$getLoadedChunks().add(chunk.moonrise$getChunkAndHolder());
        chunk.loadCallback();
    }

    public static void onChunkNotBorder(LevelChunk chunk, ChunkHolder holder) {
        ((ServerLevel)chunk.getLevel()).moonrise$getLoadedChunks().remove(chunk.moonrise$getChunkAndHolder());
        chunk.unloadCallback();
    }

    public static void onChunkPostNotBorder(LevelChunk chunk, ChunkHolder holder) {
        ((ServerLevel)chunk.getLevel()).getChunkSource().moonrise$setFullChunk(chunk.getPos().x, chunk.getPos().z, null);
    }

    public static void onChunkTicking(LevelChunk chunk, ChunkHolder holder) {
        ((ServerLevel)chunk.getLevel()).moonrise$getTickingChunks().add(chunk.moonrise$getChunkAndHolder());
        if (!chunk.moonrise$isPostProcessingDone()) {
            chunk.postProcessGeneration((ServerLevel)chunk.getLevel());
        }
        ((ServerLevel)chunk.getLevel()).startTickingChunk(chunk);
        ((ServerLevel)chunk.getLevel()).getChunkSource().chunkMap.tickingGenerated.incrementAndGet();
        ((ServerLevel)chunk.getLevel()).moonrise$markChunkForPlayerTicking(chunk);
    }

    public static void onChunkNotTicking(LevelChunk chunk, ChunkHolder holder) {
        ((ServerLevel)chunk.getLevel()).moonrise$getTickingChunks().remove(chunk.moonrise$getChunkAndHolder());
        ((ServerLevel)chunk.getLevel()).moonrise$removeChunkForPlayerTicking(chunk);
    }

    public static void onChunkEntityTicking(LevelChunk chunk, ChunkHolder holder) {
        ((ServerLevel)chunk.getLevel()).moonrise$getEntityTickingChunks().add(chunk.moonrise$getChunkAndHolder());
    }

    public static void onChunkNotEntityTicking(LevelChunk chunk, ChunkHolder holder) {
        ((ServerLevel)chunk.getLevel()).moonrise$getEntityTickingChunks().remove(chunk.moonrise$getChunkAndHolder());
    }

    public static ChunkHolder getUnloadingChunkHolder(ServerLevel level, int chunkX, int chunkZ) {
        return null;
    }

    public static int getSendViewDistance(ServerPlayer player) {
        return RegionizedPlayerChunkLoader.getAPISendViewDistance(player);
    }

    public static int getViewDistance(ServerPlayer player) {
        return RegionizedPlayerChunkLoader.getAPIViewDistance(player);
    }

    public static int getTickViewDistance(ServerPlayer player) {
        return RegionizedPlayerChunkLoader.getAPITickViewDistance(player);
    }

    public static void addPlayerToDistanceMaps(ServerLevel world, ServerPlayer player) {
        world.moonrise$getPlayerChunkLoader().addPlayer(player);
    }

    public static void removePlayerFromDistanceMaps(ServerLevel world, ServerPlayer player) {
        world.moonrise$getPlayerChunkLoader().removePlayer(player);
    }

    public static void updateMaps(ServerLevel world, ServerPlayer player) {
        world.moonrise$getPlayerChunkLoader().updatePlayer(player);
    }

    private ChunkSystem() {
    }
}

