/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.loottable;

import com.destroystokyo.paper.loottable.LootableInventory;
import com.destroystokyo.paper.loottable.LootableInventoryReplenishEvent;
import io.papermc.paper.configuration.WorldConfiguration;
import io.papermc.paper.configuration.type.DurationOrDisabled;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public class PaperLootableInventoryData {
    private static final Random RANDOM = new Random();
    private long lastFill = -1L;
    private long nextRefill = -1L;
    private int numRefills = 0;
    private @Nullable Map<UUID, Long> lootedPlayers;
    public static final LootTableInterface<RandomizableContainer> CONTAINER = new LootTableInterface<RandomizableContainer>(){

        @Override
        public WorldConfiguration paperConfig(RandomizableContainer holder) {
            return Objects.requireNonNull(holder.getLevel(), "Can only manager loot replenishment on block entities in a world").paperConfig();
        }

        @Override
        public void setSeed(RandomizableContainer holder, long seed) {
            holder.setLootTableSeed(seed);
        }

        @Override
        public boolean hasLootTable(RandomizableContainer holder) {
            return holder.getLootTable() != null;
        }

        @Override
        public LootableInventory getInventoryForEvent(RandomizableContainer holder) {
            return holder.getLootableInventory();
        }
    };
    public static final LootTableInterface<ContainerEntity> ENTITY = new LootTableInterface<ContainerEntity>(){

        @Override
        public WorldConfiguration paperConfig(ContainerEntity holder) {
            return holder.level().paperConfig();
        }

        @Override
        public void setSeed(ContainerEntity holder, long seed) {
            holder.setContainerLootTableSeed(seed);
        }

        @Override
        public boolean hasLootTable(ContainerEntity holder) {
            return holder.getContainerLootTable() != null;
        }

        @Override
        public LootableInventory getInventoryForEvent(ContainerEntity holder) {
            return holder.getLootableInventory();
        }
    };
    private static final String ROOT = "Paper.LootableData";
    private static final String LAST_FILL = "lastFill";
    private static final String NEXT_REFILL = "nextRefill";
    private static final String NUM_REFILLS = "numRefills";
    private static final String LOOTED_PLAYERS = "lootedPlayers";

    public long getLastFill() {
        return this.lastFill;
    }

    long getNextRefill() {
        return this.nextRefill;
    }

    long setNextRefill(long nextRefill) {
        long prev = this.nextRefill;
        this.nextRefill = nextRefill;
        return prev;
    }

    public <T> boolean shouldReplenish(T lootTableHolder, LootTableInterface<T> holderInterface, @Nullable Player player) {
        if (!holderInterface.hasLootTable(lootTableHolder)) {
            return false;
        }
        if (this.lastFill == -1L || !holderInterface.paperConfig(lootTableHolder).lootables.autoReplenish) {
            return true;
        }
        if (player == null) {
            return false;
        }
        if (this.nextRefill == -1L) {
            return false;
        }
        WorldConfiguration paperConfig = holderInterface.paperConfig(lootTableHolder);
        if (paperConfig.lootables.maxRefills != -1 && this.numRefills >= paperConfig.lootables.maxRefills) {
            return false;
        }
        if (this.nextRefill > System.currentTimeMillis()) {
            return false;
        }
        org.bukkit.entity.Player bukkitPlayer = (org.bukkit.entity.Player)player.getBukkitEntity();
        LootableInventoryReplenishEvent event = new LootableInventoryReplenishEvent(bukkitPlayer, holderInterface.getInventoryForEvent(lootTableHolder));
        event.setCancelled(!this.canPlayerLoot(player.getUUID(), paperConfig));
        return event.callEvent();
    }

    public <T> boolean shouldClearLootTable(T lootTableHolder, LootTableInterface<T> holderInterface, @Nullable Player player) {
        this.lastFill = System.currentTimeMillis();
        WorldConfiguration paperConfig = holderInterface.paperConfig(lootTableHolder);
        if (paperConfig.lootables.autoReplenish) {
            long min = paperConfig.lootables.refreshMin.seconds();
            long max = paperConfig.lootables.refreshMax.seconds();
            this.nextRefill = this.lastFill + (min + RANDOM.nextLong(max - min + 1L)) * 1000L;
            ++this.numRefills;
            if (paperConfig.lootables.resetSeedOnFill) {
                holderInterface.setSeed(lootTableHolder, 0L);
            }
            if (player != null) {
                this.setPlayerLootedState(player.getUUID(), true);
            }
            return false;
        }
        return true;
    }

    public void loadNbt(CompoundTag base) {
        if (!base.contains(ROOT, 10)) {
            return;
        }
        CompoundTag comp = base.getCompound(ROOT);
        if (comp.contains(LAST_FILL)) {
            this.lastFill = comp.getLong(LAST_FILL);
        }
        if (comp.contains(NEXT_REFILL)) {
            this.nextRefill = comp.getLong(NEXT_REFILL);
        }
        if (comp.contains(NUM_REFILLS)) {
            this.numRefills = comp.getInt(NUM_REFILLS);
        }
        if (comp.contains(LOOTED_PLAYERS, 9)) {
            ListTag list = comp.getList(LOOTED_PLAYERS, 10);
            int size = list.size();
            if (size > 0) {
                this.lootedPlayers = new HashMap<UUID, Long>(list.size());
            }
            for (int i = 0; i < size; ++i) {
                CompoundTag cmp = list.getCompound(i);
                this.lootedPlayers.put(cmp.getUUID("UUID"), cmp.getLong("Time"));
            }
        }
    }

    public void saveNbt(CompoundTag base) {
        CompoundTag comp = new CompoundTag();
        if (this.nextRefill != -1L) {
            comp.putLong(NEXT_REFILL, this.nextRefill);
        }
        if (this.lastFill != -1L) {
            comp.putLong(LAST_FILL, this.lastFill);
        }
        if (this.numRefills != 0) {
            comp.putInt(NUM_REFILLS, this.numRefills);
        }
        if (this.lootedPlayers != null && !this.lootedPlayers.isEmpty()) {
            ListTag list = new ListTag();
            for (Map.Entry<UUID, Long> entry : this.lootedPlayers.entrySet()) {
                CompoundTag cmp = new CompoundTag();
                cmp.putUUID("UUID", entry.getKey());
                cmp.putLong("Time", entry.getValue());
                list.add(cmp);
            }
            comp.put(LOOTED_PLAYERS, list);
        }
        if (!comp.isEmpty()) {
            base.put(ROOT, comp);
        }
    }

    void setPlayerLootedState(UUID player, boolean looted) {
        if (looted && this.lootedPlayers == null) {
            this.lootedPlayers = new HashMap<UUID, Long>();
        }
        if (looted) {
            this.lootedPlayers.put(player, System.currentTimeMillis());
        } else if (this.lootedPlayers != null) {
            this.lootedPlayers.remove(player);
        }
    }

    boolean canPlayerLoot(UUID player, WorldConfiguration worldConfiguration) {
        @Nullable Long lastLooted = this.getLastLooted(player);
        if (!worldConfiguration.lootables.restrictPlayerReloot || lastLooted == null) {
            return true;
        }
        DurationOrDisabled restrictPlayerRelootTime = worldConfiguration.lootables.restrictPlayerRelootTime;
        if (restrictPlayerRelootTime.value().isEmpty()) {
            return false;
        }
        return TimeUnit.SECONDS.toMillis(restrictPlayerRelootTime.value().get().seconds()) + lastLooted < System.currentTimeMillis();
    }

    boolean hasPlayerLooted(UUID player) {
        return this.lootedPlayers != null && this.lootedPlayers.containsKey(player);
    }

    @Nullable Long getLastLooted(UUID player) {
        return this.lootedPlayers != null ? this.lootedPlayers.get(player) : null;
    }

    public static interface LootTableInterface<T> {
        public WorldConfiguration paperConfig(T var1);

        public void setSeed(T var1, long var2);

        public boolean hasLootTable(T var1);

        public LootableInventory getInventoryForEvent(T var1);
    }
}

