/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.command;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public final class MSPTCommand
extends Command {
    private static final DecimalFormat DF = new DecimalFormat("########0.0");
    private static final Component SLASH = Component.text((String)"/");

    public MSPTCommand(String name) {
        super(name);
        this.description = "View server tick times";
        this.usageMessage = "/mspt";
        this.setPermission("bukkit.command.mspt");
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args, Location location) throws IllegalArgumentException {
        return Collections.emptyList();
    }

    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        MinecraftServer server = MinecraftServer.getServer();
        ArrayList<Component> times = new ArrayList<Component>();
        times.addAll(MSPTCommand.eval(server.tickTimes5s.getTimes()));
        times.addAll(MSPTCommand.eval(server.tickTimes10s.getTimes()));
        times.addAll(MSPTCommand.eval(server.tickTimes60s.getTimes()));
        sender.sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("Server tick times ").color((TextColor)NamedTextColor.GOLD)).append(((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.YELLOW)).append(new Component[]{Component.text((String)"("), Component.text((String)"avg", (TextColor)NamedTextColor.GRAY), Component.text((String)"/"), Component.text((String)"min", (TextColor)NamedTextColor.GRAY), Component.text((String)"/"), Component.text((String)"max", (TextColor)NamedTextColor.GRAY), Component.text((String)")")}))).append(new Component[]{Component.text((String)" from last 5s"), Component.text((String)",", (TextColor)NamedTextColor.GRAY), Component.text((String)" 10s"), Component.text((String)",", (TextColor)NamedTextColor.GRAY), Component.text((String)" 1m"), Component.text((String)":", (TextColor)NamedTextColor.YELLOW)}));
        sender.sendMessage((ComponentLike)((TextComponent.Builder)Component.text().content("\u25f4 ").color((TextColor)NamedTextColor.GOLD)).append(((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append(new Component[]{(Component)times.get(0), SLASH, (Component)times.get(1), SLASH, (Component)times.get(2), Component.text((String)", ", (TextColor)NamedTextColor.YELLOW), (Component)times.get(3), SLASH, (Component)times.get(4), SLASH, (Component)times.get(5), Component.text((String)", ", (TextColor)NamedTextColor.YELLOW), (Component)times.get(6), SLASH, (Component)times.get(7), SLASH, (Component)times.get(8)})));
        return true;
    }

    private static List<Component> eval(long[] times) {
        long min = Integer.MAX_VALUE;
        long max = 0L;
        long total = 0L;
        for (long value : times) {
            if (value > 0L && value < min) {
                min = value;
            }
            if (value > max) {
                max = value;
            }
            total += value;
        }
        double avgD = (double)total / (double)times.length * 1.0E-6;
        double minD = (double)min * 1.0E-6;
        double maxD = (double)max * 1.0E-6;
        return Arrays.asList(MSPTCommand.getColor(avgD), MSPTCommand.getColor(minD), MSPTCommand.getColor(maxD));
    }

    private static Component getColor(double avg) {
        return Component.text((String)DF.format(avg), (TextColor)(avg >= 50.0 ? NamedTextColor.RED : (avg >= 40.0 ? NamedTextColor.YELLOW : NamedTextColor.GREEN)));
    }
}

