/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.configuration.serializer.collections;

import com.mojang.logging.LogUtils;
import io.leangen.geantyref.TypeToken;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.configurate.BasicConfigurationNode;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.NodePath;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;
import org.spongepowered.configurate.serialize.TypeSerializerCollection;

public class MapSerializer
implements TypeSerializer.Annotated<Map<?, ?>> {
    public static final TypeToken<Map<?, ?>> TYPE = new TypeToken<Map<?, ?>>(){};
    private static final Logger LOGGER = LogUtils.getClassLogger();
    private final boolean clearInvalids;
    private final TypeSerializer<Map<?, ?>> fallback;

    public MapSerializer(boolean clearInvalids) {
        this.clearInvalids = clearInvalids;
        this.fallback = Objects.requireNonNull(TypeSerializerCollection.defaults().get(TYPE), "Could not find default Map<?, ?> serializer");
    }

    public Map<?, ?> deserialize(AnnotatedType annotatedType, ConfigurationNode node) throws SerializationException {
        if (annotatedType.isAnnotationPresent(ThrowExceptions.class)) {
            return (Map)this.fallback.deserialize(annotatedType, node);
        }
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        Type type = annotatedType.getType();
        if (node.isMap()) {
            if (!(type instanceof ParameterizedType)) {
                throw new SerializationException(type, "Raw types are not supported for collections");
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            if (parameterizedType.getActualTypeArguments().length != 2) {
                throw new SerializationException(type, "Map expected two type arguments!");
            }
            Type key = parameterizedType.getActualTypeArguments()[0];
            Type value = parameterizedType.getActualTypeArguments()[1];
            @Nullable TypeSerializer keySerializer = node.options().serializers().get(key);
            @Nullable TypeSerializer valueSerializer = node.options().serializers().get(value);
            if (keySerializer == null) {
                throw new SerializationException(type, "No type serializer available for key type " + String.valueOf(key));
            }
            if (valueSerializer == null) {
                throw new SerializationException(type, "No type serializer available for value type " + String.valueOf(value));
            }
            BasicConfigurationNode keyNode = BasicConfigurationNode.root((ConfigurationOptions)node.options());
            HashSet keysToClear = new HashSet();
            for (Map.Entry ent : node.childrenMap().entrySet()) {
                @Nullable Object deserializedKey = this.deserialize(key, keySerializer, "key", (ConfigurationNode)keyNode.set(ent.getKey()), node.path());
                @Nullable Object deserializedValue = this.deserialize(value, valueSerializer, "value", (ConfigurationNode)ent.getValue(), ((ConfigurationNode)ent.getValue()).path());
                if (deserializedKey == null || deserializedValue == null) continue;
                if (keySerializer instanceof WriteBack && this.serialize(key, keySerializer, deserializedKey, "key", (ConfigurationNode)keyNode, node.path()) && !ent.getKey().equals(Objects.requireNonNull(keyNode.raw(), "Key must not be null!"))) {
                    keysToClear.add(ent.getKey());
                }
                map.put(deserializedKey, deserializedValue);
            }
            if (keySerializer instanceof WriteBack) {
                for (Map.Entry keyToClear : keysToClear) {
                    node.node(new Object[]{keyToClear}).raw(null);
                }
            }
        }
        return map;
    }

    private @Nullable Object deserialize(Type type, TypeSerializer<?> serializer, String mapPart, ConfigurationNode node, NodePath path) {
        try {
            return serializer.deserialize(type, node);
        }
        catch (SerializationException ex) {
            ex.initPath(() -> ((ConfigurationNode)node).path());
            LOGGER.error("Could not deserialize {} {} into {} at {}: {}", new Object[]{mapPart, node.raw(), type, path, ex.rawMessage()});
            return null;
        }
    }

    public void serialize(AnnotatedType annotatedType, @Nullable Map<?, ?> obj, ConfigurationNode node) throws SerializationException {
        if (annotatedType.isAnnotationPresent(ThrowExceptions.class)) {
            this.fallback.serialize(annotatedType, obj, node);
            return;
        }
        Type type = annotatedType.getType();
        if (!(type instanceof ParameterizedType)) {
            throw new SerializationException(type, "Raw types are not supported for collections");
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        if (parameterizedType.getActualTypeArguments().length != 2) {
            throw new SerializationException(type, "Map expected two type arguments!");
        }
        Type key = parameterizedType.getActualTypeArguments()[0];
        Type value = parameterizedType.getActualTypeArguments()[1];
        @Nullable TypeSerializer keySerializer = node.options().serializers().get(key);
        @Nullable TypeSerializer valueSerializer = node.options().serializers().get(value);
        if (keySerializer == null) {
            throw new SerializationException(type, "No type serializer available for key type " + String.valueOf(key));
        }
        if (valueSerializer == null) {
            throw new SerializationException(type, "No type serializer available for value type " + String.valueOf(value));
        }
        if (obj == null || obj.isEmpty()) {
            node.set(Collections.emptyMap());
        } else {
            Set<Map.Entry<Object, Object>> unvisitedKeys;
            if (node.empty()) {
                node.raw(Collections.emptyMap());
                unvisitedKeys = Collections.emptySet();
            } else {
                unvisitedKeys = new HashSet(node.childrenMap().keySet());
            }
            BasicConfigurationNode keyNode = BasicConfigurationNode.root((ConfigurationOptions)node.options());
            for (Map.Entry<?, ?> ent : obj.entrySet()) {
                if (!this.serialize(key, keySerializer, ent.getKey(), "key", (ConfigurationNode)keyNode, node.path())) continue;
                Object keyObj = Objects.requireNonNull(keyNode.raw(), "Key must not be null!");
                ConfigurationNode child = node.node(new Object[]{keyObj});
                this.serialize(value, valueSerializer, ent.getValue(), "value", child, child.path());
                unvisitedKeys.remove(keyObj);
            }
            if (this.clearInvalids) {
                for (Map.Entry<Object, Object> unusedChild : unvisitedKeys) {
                    node.removeChild(unusedChild);
                }
            }
        }
    }

    private boolean serialize(Type type, TypeSerializer serializer, Object object, String mapPart, ConfigurationNode node, NodePath path) {
        try {
            serializer.serialize(type, object, node);
            return true;
        }
        catch (SerializationException ex) {
            ex.initPath(() -> ((ConfigurationNode)node).path());
            LOGGER.error("Could not serialize {} {} from {} at {}: {}", new Object[]{mapPart, object, type, path, ex.rawMessage()});
            return false;
        }
    }

    public @Nullable Map<?, ?> emptyValue(AnnotatedType specificType, ConfigurationOptions options) {
        if (specificType.isAnnotationPresent(ThrowExceptions.class)) {
            return (Map)this.fallback.emptyValue(specificType, options);
        }
        return new LinkedHashMap();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ThrowExceptions {
    }

    public static interface WriteBack {
    }
}

