/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.datacomponent.item.Equippable;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.set.PaperRegistrySets;
import io.papermc.paper.registry.set.RegistryKeySet;
import java.util.Optional;
import net.kyori.adventure.key.Key;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import org.bukkit.craftbukkit.CraftEquipmentSlot;
import org.bukkit.craftbukkit.util.Handleable;
import org.bukkit.entity.EntityType;
import org.checkerframework.checker.nullness.qual.Nullable;

public record PaperEquippable(net.minecraft.world.item.equipment.Equippable impl) implements Equippable,
Handleable<net.minecraft.world.item.equipment.Equippable>
{
    @Override
    public net.minecraft.world.item.equipment.Equippable getHandle() {
        return this.impl;
    }

    public org.bukkit.inventory.EquipmentSlot slot() {
        return CraftEquipmentSlot.getSlot(this.impl.slot());
    }

    public Key equipSound() {
        return PaperAdventure.asAdventure(this.impl.equipSound().value().location());
    }

    public @Nullable Key model() {
        return this.impl.model().map(PaperAdventure::asAdventure).orElse(null);
    }

    public @Nullable Key cameraOverlay() {
        return this.impl.cameraOverlay().map(PaperAdventure::asAdventure).orElse(null);
    }

    public @Nullable RegistryKeySet<EntityType> allowedEntities() {
        return this.impl.allowedEntities().map(set -> PaperRegistrySets.convertToApi(RegistryKey.ENTITY_TYPE, set)).orElse(null);
    }

    public boolean dispensable() {
        return this.impl.dispensable();
    }

    public boolean swappable() {
        return this.impl.swappable();
    }

    public boolean damageOnHurt() {
        return this.impl.damageOnHurt();
    }

    public Equippable.Builder toBuilder() {
        return new BuilderImpl(this.slot()).equipSound(this.equipSound()).model(this.model()).cameraOverlay(this.cameraOverlay()).allowedEntities(this.allowedEntities()).dispensable(this.dispensable()).swappable(this.swappable()).damageOnHurt(this.damageOnHurt());
    }

    static final class BuilderImpl
    implements Equippable.Builder {
        private final EquipmentSlot equipmentSlot;
        private Holder<SoundEvent> equipSound = SoundEvents.ARMOR_EQUIP_GENERIC;
        private Optional<ResourceLocation> model = Optional.empty();
        private Optional<ResourceLocation> cameraOverlay = Optional.empty();
        private Optional<HolderSet<net.minecraft.world.entity.EntityType<?>>> allowedEntities = Optional.empty();
        private boolean dispensable = true;
        private boolean swappable = true;
        private boolean damageOnHurt = true;

        BuilderImpl(org.bukkit.inventory.EquipmentSlot equipmentSlot) {
            this.equipmentSlot = CraftEquipmentSlot.getNMS(equipmentSlot);
        }

        public Equippable.Builder equipSound(Key sound) {
            this.equipSound = PaperAdventure.resolveSound(sound);
            return this;
        }

        public Equippable.Builder model(@Nullable Key model) {
            this.model = Optional.ofNullable(model).map(PaperAdventure::asVanilla);
            return this;
        }

        public Equippable.Builder cameraOverlay(@Nullable Key cameraOverlay) {
            this.cameraOverlay = Optional.ofNullable(cameraOverlay).map(PaperAdventure::asVanilla);
            return this;
        }

        public Equippable.Builder allowedEntities(@Nullable RegistryKeySet<EntityType> allowedEntities) {
            this.allowedEntities = Optional.ofNullable(allowedEntities).map(set -> PaperRegistrySets.convertToNms(Registries.ENTITY_TYPE, BuiltInRegistries.BUILT_IN_CONVERSIONS.lookup(), set));
            return this;
        }

        public Equippable.Builder dispensable(boolean dispensable) {
            this.dispensable = dispensable;
            return this;
        }

        public Equippable.Builder swappable(boolean swappable) {
            this.swappable = swappable;
            return this;
        }

        public Equippable.Builder damageOnHurt(boolean damageOnHurt) {
            this.damageOnHurt = damageOnHurt;
            return this;
        }

        public Equippable build() {
            return new PaperEquippable(new net.minecraft.world.item.equipment.Equippable(this.equipmentSlot, this.equipSound, this.model, this.cameraOverlay, this.allowedEntities, this.dispensable, this.swappable, this.damageOnHurt));
        }
    }
}

