/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.provider.type.paper;

import io.papermc.paper.plugin.configuration.PluginMeta;
import io.papermc.paper.plugin.provider.configuration.LoadOrderConfiguration;
import io.papermc.paper.plugin.provider.configuration.PaperPluginMeta;
import io.papermc.paper.plugin.provider.configuration.type.DependencyConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PaperBootstrapOrderConfiguration
implements LoadOrderConfiguration {
    private final PaperPluginMeta paperPluginMeta;
    private final List<String> loadBefore = new ArrayList<String>();
    private final List<String> loadAfter = new ArrayList<String>();

    public PaperBootstrapOrderConfiguration(PaperPluginMeta paperPluginMeta) {
        this.paperPluginMeta = paperPluginMeta;
        for (Map.Entry<String, DependencyConfiguration> configuration : paperPluginMeta.getBootstrapDependencies().entrySet()) {
            String name = configuration.getKey();
            DependencyConfiguration dependencyConfiguration = configuration.getValue();
            if (dependencyConfiguration.load() == DependencyConfiguration.LoadOrder.AFTER) {
                this.loadBefore.add(name);
                continue;
            }
            if (dependencyConfiguration.load() != DependencyConfiguration.LoadOrder.BEFORE) continue;
            this.loadAfter.add(name);
        }
    }

    @Override
    @NotNull
    public List<String> getLoadBefore() {
        return this.loadBefore;
    }

    @Override
    @NotNull
    public List<String> getLoadAfter() {
        return this.loadAfter;
    }

    @Override
    @NotNull
    public PluginMeta getMeta() {
        return this.paperPluginMeta;
    }
}

