/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;

public class AdvancementTree {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<ResourceLocation, AdvancementNode> nodes = new Object2ObjectOpenHashMap();
    private final Set<AdvancementNode> roots = new ObjectLinkedOpenHashSet();
    private final Set<AdvancementNode> tasks = new ObjectLinkedOpenHashSet();
    @Nullable
    private Listener listener;

    private void remove(AdvancementNode advancement) {
        for (AdvancementNode advancementnode1 : advancement.children()) {
            this.remove(advancementnode1);
        }
        LOGGER.debug("Forgot about advancement {}", (Object)advancement.holder());
        this.nodes.remove(advancement.holder().id());
        if (advancement.parent() == null) {
            this.roots.remove(advancement);
            if (this.listener != null) {
                this.listener.onRemoveAdvancementRoot(advancement);
            }
        } else {
            this.tasks.remove(advancement);
            if (this.listener != null) {
                this.listener.onRemoveAdvancementTask(advancement);
            }
        }
    }

    public void remove(Set<ResourceLocation> advancements) {
        for (ResourceLocation minecraftkey : advancements) {
            AdvancementNode advancementnode = this.nodes.get(minecraftkey);
            if (advancementnode == null) {
                LOGGER.warn("Told to remove advancement {} but I don't know what that is", (Object)minecraftkey);
                continue;
            }
            this.remove(advancementnode);
        }
    }

    public void addAll(Collection<AdvancementHolder> advancements) {
        ArrayList<AdvancementHolder> list = new ArrayList<AdvancementHolder>(advancements);
        while (!list.isEmpty()) {
            if (list.removeIf(this::tryInsert)) continue;
            LOGGER.error("Couldn't load advancements: {}", list);
            break;
        }
    }

    private boolean tryInsert(AdvancementHolder advancement) {
        Optional<ResourceLocation> optional = advancement.value().parent();
        Map<ResourceLocation, AdvancementNode> map = this.nodes;
        Objects.requireNonNull(this.nodes);
        AdvancementNode advancementnode = optional.map(map::get).orElse(null);
        if (advancementnode == null && optional.isPresent()) {
            return false;
        }
        AdvancementNode advancementnode1 = new AdvancementNode(advancement, advancementnode);
        if (advancementnode != null) {
            advancementnode.addChild(advancementnode1);
        }
        this.nodes.put(advancement.id(), advancementnode1);
        if (advancementnode == null) {
            this.roots.add(advancementnode1);
            if (this.listener != null) {
                this.listener.onAddAdvancementRoot(advancementnode1);
            }
        } else {
            this.tasks.add(advancementnode1);
            if (this.listener != null) {
                this.listener.onAddAdvancementTask(advancementnode1);
            }
        }
        return true;
    }

    public void clear() {
        this.nodes.clear();
        this.roots.clear();
        this.tasks.clear();
        if (this.listener != null) {
            this.listener.onAdvancementsCleared();
        }
    }

    public Iterable<AdvancementNode> roots() {
        return this.roots;
    }

    public Collection<AdvancementNode> nodes() {
        return this.nodes.values();
    }

    @Nullable
    public AdvancementNode get(ResourceLocation id) {
        return this.nodes.get(id);
    }

    @Nullable
    public AdvancementNode get(AdvancementHolder advancement) {
        return this.nodes.get(advancement.id());
    }

    public void setListener(@Nullable Listener listener) {
        this.listener = listener;
        if (listener != null) {
            for (AdvancementNode advancementnode : this.roots) {
                listener.onAddAdvancementRoot(advancementnode);
            }
            for (AdvancementNode advancementnode : this.tasks) {
                listener.onAddAdvancementTask(advancementnode);
            }
        }
    }

    public static interface Listener {
        public void onAddAdvancementRoot(AdvancementNode var1);

        public void onRemoveAdvancementRoot(AdvancementNode var1);

        public void onAddAdvancementTask(AdvancementNode var1);

        public void onRemoveAdvancementTask(AdvancementNode var1);

        public void onAdvancementsCleared();
    }
}

