/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands;

import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.flag.FeatureFlagSet;

public interface CommandBuildContext
extends HolderLookup.Provider {
    public static CommandBuildContext simple(final HolderLookup.Provider registries, final FeatureFlagSet enabledFeatures) {
        return new CommandBuildContext(){

            @Override
            @Override
            public Stream<ResourceKey<? extends Registry<?>>> listRegistryKeys() {
                return registries.listRegistryKeys();
            }

            @Override
            public <T> Optional<HolderLookup.RegistryLookup<T>> lookup(ResourceKey<? extends Registry<? extends T>> registryRef) {
                return registries.lookup(registryRef).map(wrapper -> wrapper.filterFeatures(enabledFeatures));
            }

            @Override
            @Override
            public FeatureFlagSet enabledFeatures() {
                return enabledFeatures;
            }
        };
    }

    public FeatureFlagSet enabledFeatures();
}

