/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.selector.options;

import com.google.common.collect.Maps;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.WrappedMinMaxBounds;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Team;

public class EntitySelectorOptions {
    private static final Map<String, Option> OPTIONS = Maps.newHashMap();
    public static final DynamicCommandExceptionType ERROR_UNKNOWN_OPTION = new DynamicCommandExceptionType(option -> net.minecraft.network.chat.Component.translatableEscape("argument.entity.options.unknown", option));
    public static final DynamicCommandExceptionType ERROR_INAPPLICABLE_OPTION = new DynamicCommandExceptionType(option -> net.minecraft.network.chat.Component.translatableEscape("argument.entity.options.inapplicable", option));
    public static final SimpleCommandExceptionType ERROR_RANGE_NEGATIVE = new SimpleCommandExceptionType((Message)net.minecraft.network.chat.Component.translatable("argument.entity.options.distance.negative"));
    public static final SimpleCommandExceptionType ERROR_LEVEL_NEGATIVE = new SimpleCommandExceptionType((Message)net.minecraft.network.chat.Component.translatable("argument.entity.options.level.negative"));
    public static final SimpleCommandExceptionType ERROR_LIMIT_TOO_SMALL = new SimpleCommandExceptionType((Message)net.minecraft.network.chat.Component.translatable("argument.entity.options.limit.toosmall"));
    public static final DynamicCommandExceptionType ERROR_SORT_UNKNOWN = new DynamicCommandExceptionType(sortType -> net.minecraft.network.chat.Component.translatableEscape("argument.entity.options.sort.irreversible", sortType));
    public static final DynamicCommandExceptionType ERROR_GAME_MODE_INVALID = new DynamicCommandExceptionType(gameMode -> net.minecraft.network.chat.Component.translatableEscape("argument.entity.options.mode.invalid", gameMode));
    public static final DynamicCommandExceptionType ERROR_ENTITY_TYPE_INVALID = new DynamicCommandExceptionType(entity -> net.minecraft.network.chat.Component.translatableEscape("argument.entity.options.type.invalid", entity));
    public static final DynamicCommandExceptionType ERROR_ENTITY_TAG_INVALID = new DynamicCommandExceptionType(object -> PaperAdventure.asVanilla(Component.text((String)("Invalid or unknown entity type tag '" + String.valueOf(object) + "'")).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"You can disable this error in 'paper.yml'")))));

    private static void register(String id, Modifier handler, Predicate<EntitySelectorParser> condition, net.minecraft.network.chat.Component description) {
        OPTIONS.put(id, new Option(handler, condition, description));
    }

    public static void bootStrap() {
        if (OPTIONS.isEmpty()) {
            EntitySelectorOptions.register("name", reader -> {
                int i = reader.getReader().getCursor();
                boolean bl = reader.shouldInvertValue();
                String string = reader.getReader().readString();
                if (reader.hasNameNotEquals() && !bl) {
                    reader.getReader().setCursor(i);
                    throw ERROR_INAPPLICABLE_OPTION.createWithContext((ImmutableStringReader)reader.getReader(), (Object)"name");
                }
                if (bl) {
                    reader.setHasNameNotEquals(true);
                } else {
                    reader.setHasNameEquals(true);
                }
                reader.addPredicate(entity -> entity.getName().getString().equals(string) != bl);
            }, reader -> !reader.hasNameEquals(), net.minecraft.network.chat.Component.translatable("argument.entity.options.name.description"));
            EntitySelectorOptions.register("distance", reader -> {
                int i = reader.getReader().getCursor();
                MinMaxBounds.Doubles doubles = MinMaxBounds.Doubles.fromReader(reader.getReader());
                if (doubles.min().isPresent() && doubles.min().get() < 0.0 || doubles.max().isPresent() && doubles.max().get() < 0.0) {
                    reader.getReader().setCursor(i);
                    throw ERROR_RANGE_NEGATIVE.createWithContext((ImmutableStringReader)reader.getReader());
                }
                reader.setDistance(doubles);
                reader.setWorldLimited();
            }, reader -> reader.getDistance().isAny(), net.minecraft.network.chat.Component.translatable("argument.entity.options.distance.description"));
            EntitySelectorOptions.register("level", reader -> {
                int i = reader.getReader().getCursor();
                MinMaxBounds.Ints ints = MinMaxBounds.Ints.fromReader(reader.getReader());
                if (ints.min().isPresent() && ints.min().get() < 0 || ints.max().isPresent() && ints.max().get() < 0) {
                    reader.getReader().setCursor(i);
                    throw ERROR_LEVEL_NEGATIVE.createWithContext((ImmutableStringReader)reader.getReader());
                }
                reader.setLevel(ints);
                reader.setIncludesEntities(false);
            }, reader -> reader.getLevel().isAny(), net.minecraft.network.chat.Component.translatable("argument.entity.options.level.description"));
            EntitySelectorOptions.register("x", reader -> {
                reader.setWorldLimited();
                reader.setX(reader.getReader().readDouble());
            }, reader -> reader.getX() == null, net.minecraft.network.chat.Component.translatable("argument.entity.options.x.description"));
            EntitySelectorOptions.register("y", reader -> {
                reader.setWorldLimited();
                reader.setY(reader.getReader().readDouble());
            }, reader -> reader.getY() == null, net.minecraft.network.chat.Component.translatable("argument.entity.options.y.description"));
            EntitySelectorOptions.register("z", reader -> {
                reader.setWorldLimited();
                reader.setZ(reader.getReader().readDouble());
            }, reader -> reader.getZ() == null, net.minecraft.network.chat.Component.translatable("argument.entity.options.z.description"));
            EntitySelectorOptions.register("dx", reader -> {
                reader.setWorldLimited();
                reader.setDeltaX(reader.getReader().readDouble());
            }, reader -> reader.getDeltaX() == null, net.minecraft.network.chat.Component.translatable("argument.entity.options.dx.description"));
            EntitySelectorOptions.register("dy", reader -> {
                reader.setWorldLimited();
                reader.setDeltaY(reader.getReader().readDouble());
            }, reader -> reader.getDeltaY() == null, net.minecraft.network.chat.Component.translatable("argument.entity.options.dy.description"));
            EntitySelectorOptions.register("dz", reader -> {
                reader.setWorldLimited();
                reader.setDeltaZ(reader.getReader().readDouble());
            }, reader -> reader.getDeltaZ() == null, net.minecraft.network.chat.Component.translatable("argument.entity.options.dz.description"));
            EntitySelectorOptions.register("x_rotation", reader -> reader.setRotX(WrappedMinMaxBounds.fromReader(reader.getReader(), true, Mth::wrapDegrees)), reader -> reader.getRotX() == WrappedMinMaxBounds.ANY, net.minecraft.network.chat.Component.translatable("argument.entity.options.x_rotation.description"));
            EntitySelectorOptions.register("y_rotation", reader -> reader.setRotY(WrappedMinMaxBounds.fromReader(reader.getReader(), true, Mth::wrapDegrees)), reader -> reader.getRotY() == WrappedMinMaxBounds.ANY, net.minecraft.network.chat.Component.translatable("argument.entity.options.y_rotation.description"));
            EntitySelectorOptions.register("limit", reader -> {
                int i = reader.getReader().getCursor();
                int j = reader.getReader().readInt();
                if (j < 1) {
                    reader.getReader().setCursor(i);
                    throw ERROR_LIMIT_TOO_SMALL.createWithContext((ImmutableStringReader)reader.getReader());
                }
                reader.setMaxResults(j);
                reader.setLimited(true);
            }, reader -> !reader.isCurrentEntity() && !reader.isLimited(), net.minecraft.network.chat.Component.translatable("argument.entity.options.limit.description"));
            EntitySelectorOptions.register("sort", reader -> {
                int i = reader.getReader().getCursor();
                String string = reader.getReader().readUnquotedString();
                reader.setSuggestions((builder, consumer) -> SharedSuggestionProvider.suggest(Arrays.asList("nearest", "furthest", "random", "arbitrary"), builder));
                reader.setOrder(switch (string) {
                    case "nearest" -> EntitySelectorParser.ORDER_NEAREST;
                    case "furthest" -> EntitySelectorParser.ORDER_FURTHEST;
                    case "random" -> EntitySelectorParser.ORDER_RANDOM;
                    case "arbitrary" -> EntitySelector.ORDER_ARBITRARY;
                    default -> {
                        reader.getReader().setCursor(i);
                        throw ERROR_SORT_UNKNOWN.createWithContext((ImmutableStringReader)reader.getReader(), (Object)string);
                    }
                });
                reader.setSorted(true);
            }, reader -> !reader.isCurrentEntity() && !reader.isSorted(), net.minecraft.network.chat.Component.translatable("argument.entity.options.sort.description"));
            EntitySelectorOptions.register("gamemode", reader -> {
                reader.setSuggestions((builder, consumer) -> {
                    String stringx = builder.getRemaining().toLowerCase(Locale.ROOT);
                    boolean blx = !reader.hasGamemodeNotEquals();
                    boolean bl2 = true;
                    if (!stringx.isEmpty()) {
                        if (stringx.charAt(0) == '!') {
                            blx = false;
                            stringx = stringx.substring(1);
                        } else {
                            bl2 = false;
                        }
                    }
                    for (GameType gameTypex : GameType.values()) {
                        if (!gameTypex.getName().toLowerCase(Locale.ROOT).startsWith(stringx)) continue;
                        if (bl2) {
                            builder.suggest("!" + gameTypex.getName());
                        }
                        if (!blx) continue;
                        builder.suggest(gameTypex.getName());
                    }
                    return builder.buildFuture();
                });
                int i = reader.getReader().getCursor();
                boolean bl = reader.shouldInvertValue();
                if (reader.hasGamemodeNotEquals() && !bl) {
                    reader.getReader().setCursor(i);
                    throw ERROR_INAPPLICABLE_OPTION.createWithContext((ImmutableStringReader)reader.getReader(), (Object)"gamemode");
                }
                String string = reader.getReader().readUnquotedString();
                GameType gameType = GameType.byName(string, null);
                if (gameType == null) {
                    reader.getReader().setCursor(i);
                    throw ERROR_GAME_MODE_INVALID.createWithContext((ImmutableStringReader)reader.getReader(), (Object)string);
                }
                reader.setIncludesEntities(false);
                reader.addPredicate(entity -> {
                    if (!(entity instanceof ServerPlayer)) {
                        return false;
                    }
                    GameType gameType2 = ((ServerPlayer)entity).gameMode.getGameModeForPlayer();
                    return bl ? gameType2 != gameType : gameType2 == gameType;
                });
                if (bl) {
                    reader.setHasGamemodeNotEquals(true);
                } else {
                    reader.setHasGamemodeEquals(true);
                }
            }, reader -> !reader.hasGamemodeEquals(), net.minecraft.network.chat.Component.translatable("argument.entity.options.gamemode.description"));
            EntitySelectorOptions.register("team", reader -> {
                boolean bl = reader.shouldInvertValue();
                String string = reader.getReader().readUnquotedString();
                reader.addPredicate(entity -> {
                    if (!(entity instanceof LivingEntity)) {
                        return false;
                    }
                    PlayerTeam team = entity.getTeam();
                    String string2 = team == null ? "" : ((Team)team).getName();
                    return string2.equals(string) != bl;
                });
                if (bl) {
                    reader.setHasTeamNotEquals(true);
                } else {
                    reader.setHasTeamEquals(true);
                }
            }, reader -> !reader.hasTeamEquals(), net.minecraft.network.chat.Component.translatable("argument.entity.options.team.description"));
            EntitySelectorOptions.register("type", reader -> {
                reader.setSuggestions((builder, consumer) -> {
                    SharedSuggestionProvider.suggestResource(BuiltInRegistries.ENTITY_TYPE.keySet(), builder, String.valueOf('!'));
                    SharedSuggestionProvider.suggestResource(BuiltInRegistries.ENTITY_TYPE.getTags().map(tag -> tag.key().location()), builder, "!#");
                    if (!reader.isTypeLimitedInversely()) {
                        SharedSuggestionProvider.suggestResource(BuiltInRegistries.ENTITY_TYPE.keySet(), builder);
                        SharedSuggestionProvider.suggestResource(BuiltInRegistries.ENTITY_TYPE.getTags().map(tag -> tag.key().location()), builder, String.valueOf('#'));
                    }
                    return builder.buildFuture();
                });
                int i = reader.getReader().getCursor();
                boolean bl = reader.shouldInvertValue();
                if (reader.isTypeLimitedInversely() && !bl) {
                    reader.getReader().setCursor(i);
                    throw ERROR_INAPPLICABLE_OPTION.createWithContext((ImmutableStringReader)reader.getReader(), (Object)"type");
                }
                if (bl) {
                    reader.setTypeLimitedInversely();
                }
                if (reader.isTag()) {
                    TagKey<EntityType<?>> tagKey = TagKey.create(Registries.ENTITY_TYPE, ResourceLocation.read(reader.getReader()));
                    if (reader.parsingEntityArgumentSuggestions && GlobalConfiguration.get().commands.fixTargetSelectorTagCompletion && BuiltInRegistries.ENTITY_TYPE.get(tagKey).isEmpty()) {
                        reader.getReader().setCursor(i);
                        throw ERROR_ENTITY_TAG_INVALID.createWithContext((ImmutableStringReader)reader.getReader(), tagKey);
                    }
                    reader.addPredicate(entity -> entity.getType().is(tagKey) != bl);
                } else {
                    ResourceLocation resourceLocation = ResourceLocation.read(reader.getReader());
                    EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.getOptional(resourceLocation).orElseThrow(() -> {
                        reader.getReader().setCursor(i);
                        return ERROR_ENTITY_TYPE_INVALID.createWithContext((ImmutableStringReader)reader.getReader(), (Object)resourceLocation.toString());
                    });
                    if (Objects.equals(EntityType.PLAYER, entityType) && !bl) {
                        reader.setIncludesEntities(false);
                    }
                    reader.addPredicate(entity -> Objects.equals(entityType, entity.getType()) != bl);
                    if (!bl) {
                        reader.limitToType(entityType);
                    }
                }
            }, reader -> !reader.isTypeLimited(), net.minecraft.network.chat.Component.translatable("argument.entity.options.type.description"));
            EntitySelectorOptions.register("tag", reader -> {
                boolean bl = reader.shouldInvertValue();
                String string = reader.getReader().readUnquotedString();
                reader.addPredicate(entity -> "".equals(string) ? entity.getTags().isEmpty() != bl : entity.getTags().contains(string) != bl);
            }, reader -> true, net.minecraft.network.chat.Component.translatable("argument.entity.options.tag.description"));
            EntitySelectorOptions.register("nbt", reader -> {
                boolean bl = reader.shouldInvertValue();
                CompoundTag compoundTag = new TagParser(reader.getReader()).readStruct();
                reader.addPredicate(entity -> {
                    ServerPlayer serverPlayer;
                    ItemStack itemStack;
                    CompoundTag compoundTag2 = entity.saveWithoutId(new CompoundTag());
                    if (entity instanceof ServerPlayer && !(itemStack = (serverPlayer = (ServerPlayer)entity).getInventory().getSelected()).isEmpty()) {
                        compoundTag2.put("SelectedItem", itemStack.save(serverPlayer.registryAccess()));
                    }
                    return NbtUtils.compareNbt(compoundTag, compoundTag2, true) != bl;
                });
            }, reader -> true, net.minecraft.network.chat.Component.translatable("argument.entity.options.nbt.description"));
            EntitySelectorOptions.register("scores", reader -> {
                StringReader stringReader = reader.getReader();
                HashMap map = Maps.newHashMap();
                stringReader.expect('{');
                stringReader.skipWhitespace();
                while (stringReader.canRead() && stringReader.peek() != '}') {
                    stringReader.skipWhitespace();
                    String string = stringReader.readUnquotedString();
                    stringReader.skipWhitespace();
                    stringReader.expect('=');
                    stringReader.skipWhitespace();
                    MinMaxBounds.Ints ints = MinMaxBounds.Ints.fromReader(stringReader);
                    map.put(string, ints);
                    stringReader.skipWhitespace();
                    if (!stringReader.canRead() || stringReader.peek() != ',') continue;
                    stringReader.skip();
                }
                stringReader.expect('}');
                if (!map.isEmpty()) {
                    reader.addPredicate(entity -> {
                        ServerScoreboard scoreboard = entity.getServer().getScoreboard();
                        for (Map.Entry entry : map.entrySet()) {
                            Objective objective = scoreboard.getObjective((String)entry.getKey());
                            if (objective == null) {
                                return false;
                            }
                            ReadOnlyScoreInfo readOnlyScoreInfo = scoreboard.getPlayerScoreInfo((ScoreHolder)entity, objective);
                            if (readOnlyScoreInfo == null) {
                                return false;
                            }
                            if (((MinMaxBounds.Ints)entry.getValue()).matches(readOnlyScoreInfo.value())) continue;
                            return false;
                        }
                        return true;
                    });
                }
                reader.setHasScores(true);
            }, reader -> !reader.hasScores(), net.minecraft.network.chat.Component.translatable("argument.entity.options.scores.description"));
            EntitySelectorOptions.register("advancements", reader -> {
                StringReader stringReader = reader.getReader();
                HashMap map = Maps.newHashMap();
                stringReader.expect('{');
                stringReader.skipWhitespace();
                while (stringReader.canRead() && stringReader.peek() != '}') {
                    stringReader.skipWhitespace();
                    ResourceLocation resourceLocation = ResourceLocation.read(stringReader);
                    stringReader.skipWhitespace();
                    stringReader.expect('=');
                    stringReader.skipWhitespace();
                    if (stringReader.canRead() && stringReader.peek() == '{') {
                        HashMap map2 = Maps.newHashMap();
                        stringReader.skipWhitespace();
                        stringReader.expect('{');
                        stringReader.skipWhitespace();
                        while (stringReader.canRead() && stringReader.peek() != '}') {
                            stringReader.skipWhitespace();
                            String string = stringReader.readUnquotedString();
                            stringReader.skipWhitespace();
                            stringReader.expect('=');
                            stringReader.skipWhitespace();
                            boolean bl = stringReader.readBoolean();
                            map2.put(string, criterionProgress -> criterionProgress.isDone() == bl);
                            stringReader.skipWhitespace();
                            if (!stringReader.canRead() || stringReader.peek() != ',') continue;
                            stringReader.skip();
                        }
                        stringReader.skipWhitespace();
                        stringReader.expect('}');
                        stringReader.skipWhitespace();
                        map.put(resourceLocation, advancementProgress -> {
                            for (Map.Entry entry : map2.entrySet()) {
                                CriterionProgress criterionProgress = advancementProgress.getCriterion((String)entry.getKey());
                                if (criterionProgress != null && ((Predicate)entry.getValue()).test(criterionProgress)) continue;
                                return false;
                            }
                            return true;
                        });
                    } else {
                        boolean bl2 = stringReader.readBoolean();
                        map.put(resourceLocation, advancementProgress -> advancementProgress.isDone() == bl2);
                    }
                    stringReader.skipWhitespace();
                    if (!stringReader.canRead() || stringReader.peek() != ',') continue;
                    stringReader.skip();
                }
                stringReader.expect('}');
                if (!map.isEmpty()) {
                    reader.addPredicate(entity -> {
                        if (!(entity instanceof ServerPlayer)) {
                            return false;
                        }
                        ServerPlayer serverPlayer = (ServerPlayer)entity;
                        PlayerAdvancements playerAdvancements = serverPlayer.getAdvancements();
                        ServerAdvancementManager serverAdvancementManager = serverPlayer.getServer().getAdvancements();
                        for (Map.Entry entry : map.entrySet()) {
                            AdvancementHolder advancementHolder = serverAdvancementManager.get((ResourceLocation)entry.getKey());
                            if (advancementHolder != null && ((Predicate)entry.getValue()).test(playerAdvancements.getOrStartProgress(advancementHolder))) continue;
                            return false;
                        }
                        return true;
                    });
                    reader.setIncludesEntities(false);
                }
                reader.setHasAdvancements(true);
            }, reader -> !reader.hasAdvancements(), net.minecraft.network.chat.Component.translatable("argument.entity.options.advancements.description"));
            EntitySelectorOptions.register("predicate", reader -> {
                boolean bl = reader.shouldInvertValue();
                ResourceKey<LootItemCondition> resourceKey = ResourceKey.create(Registries.PREDICATE, ResourceLocation.read(reader.getReader()));
                reader.addPredicate(entity -> {
                    if (!(entity.level() instanceof ServerLevel)) {
                        return false;
                    }
                    ServerLevel serverLevel = (ServerLevel)entity.level();
                    Optional<LootItemCondition> optional = serverLevel.getServer().reloadableRegistries().lookup().get(resourceKey).map(Holder::value);
                    if (optional.isEmpty()) {
                        return false;
                    }
                    LootParams lootParams = new LootParams.Builder(serverLevel).withParameter(LootContextParams.THIS_ENTITY, entity).withParameter(LootContextParams.ORIGIN, entity.position()).create(LootContextParamSets.SELECTOR);
                    LootContext lootContext = new LootContext.Builder(lootParams).create(Optional.empty());
                    lootContext.pushVisitedElement(LootContext.createVisitedEntry(optional.get()));
                    return bl ^ optional.get().test(lootContext);
                });
            }, reader -> true, net.minecraft.network.chat.Component.translatable("argument.entity.options.predicate.description"));
        }
    }

    public static Modifier get(EntitySelectorParser reader, String option, int restoreCursor) throws CommandSyntaxException {
        Option option2 = OPTIONS.get(option);
        if (option2 != null) {
            if (option2.canUse.test(reader)) {
                return option2.modifier;
            }
            throw ERROR_INAPPLICABLE_OPTION.createWithContext((ImmutableStringReader)reader.getReader(), (Object)option);
        }
        reader.getReader().setCursor(restoreCursor);
        throw ERROR_UNKNOWN_OPTION.createWithContext((ImmutableStringReader)reader.getReader(), (Object)option);
    }

    public static void suggestNames(EntitySelectorParser reader, SuggestionsBuilder suggestionBuilder) {
        String string = suggestionBuilder.getRemaining().toLowerCase(Locale.ROOT);
        for (Map.Entry<String, Option> entry : OPTIONS.entrySet()) {
            if (!entry.getValue().canUse.test(reader) || !entry.getKey().toLowerCase(Locale.ROOT).startsWith(string)) continue;
            suggestionBuilder.suggest(entry.getKey() + "=", (Message)entry.getValue().description);
        }
    }

    record Option(Modifier modifier, Predicate<EntitySelectorParser> canUse, net.minecraft.network.chat.Component description) {
    }

    public static interface Modifier {
        public void handle(EntitySelectorParser var1) throws CommandSyntaxException;
    }
}

