/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import org.slf4j.Logger;

public interface RegistryAccess
extends HolderLookup.Provider {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Frozen EMPTY = new ImmutableRegistryAccess(Map.of()).freeze();

    @Override
    public <E> Optional<Registry<E>> lookup(ResourceKey<? extends Registry<? extends E>> var1);

    @Override
    default public <E> Registry<E> lookupOrThrow(ResourceKey<? extends Registry<? extends E>> key) {
        return this.lookup(key).orElseThrow(() -> new IllegalStateException("Missing registry: " + String.valueOf(key)));
    }

    public Stream<RegistryEntry<?>> registries();

    @Override
    @Override
    default public Stream<ResourceKey<? extends Registry<?>>> listRegistryKeys() {
        return this.registries().map(registry -> registry.key);
    }

    public static Frozen fromRegistryOfRegistries(final Registry<? extends Registry<?>> registries) {
        return new Frozen(){

            @Override
            public <T> Optional<Registry<T>> lookup(ResourceKey<? extends Registry<? extends T>> registryRef) {
                Registry registry = registries;
                return registry.getOptional(registryRef);
            }

            @Override
            @Override
            public Stream<RegistryEntry<?>> registries() {
                return registries.entrySet().stream().map(RegistryEntry::fromMapEntry);
            }

            @Override
            @Override
            public Frozen freeze() {
                return this;
            }
        };
    }

    default public Frozen freeze() {
        class FrozenAccess
        extends ImmutableRegistryAccess
        implements Frozen {
            protected FrozenAccess(RegistryAccess registryAccess, Stream<RegistryEntry<?>> entryStream) {
                super(entryStream);
            }
        }
        return new FrozenAccess(this, this.registries().map(RegistryEntry::freeze));
    }

    @Override
    default public /* synthetic */ HolderLookup.RegistryLookup lookupOrThrow(ResourceKey registryRef) {
        return this.lookupOrThrow(registryRef);
    }

    @Override
    default public /* synthetic */ HolderGetter lookupOrThrow(ResourceKey registryRef) {
        return this.lookupOrThrow(registryRef);
    }

    public record RegistryEntry<T>(ResourceKey<? extends Registry<T>> key, Registry<T> value) {
        private static <T, R extends Registry<? extends T>> RegistryEntry<T> fromMapEntry(Map.Entry<? extends ResourceKey<? extends Registry<?>>, R> entry) {
            return RegistryEntry.fromUntyped(entry.getKey(), (Registry)entry.getValue());
        }

        private static <T> RegistryEntry<T> fromUntyped(ResourceKey<? extends Registry<?>> key, Registry<?> value) {
            return new RegistryEntry(key, value);
        }

        private RegistryEntry<T> freeze() {
            return new RegistryEntry<T>(this.key, this.value.freeze());
        }
    }

    public static class ImmutableRegistryAccess
    implements RegistryAccess {
        private final Map<? extends ResourceKey<? extends Registry<?>>, ? extends Registry<?>> registries;

        public ImmutableRegistryAccess(List<? extends Registry<?>> registries) {
            this.registries = registries.stream().collect(Collectors.toUnmodifiableMap(Registry::key, registry -> registry));
        }

        public ImmutableRegistryAccess(Map<? extends ResourceKey<? extends Registry<?>>, ? extends Registry<?>> registries) {
            this.registries = Map.copyOf(registries);
        }

        public ImmutableRegistryAccess(Stream<RegistryEntry<?>> entryStream) {
            this.registries = (Map)entryStream.collect(ImmutableMap.toImmutableMap(RegistryEntry::key, RegistryEntry::value));
        }

        @Override
        @Override
        public <E> Optional<Registry<E>> lookup(ResourceKey<? extends Registry<? extends E>> registryRef) {
            return Optional.ofNullable(this.registries.get(registryRef)).map(registry -> registry);
        }

        @Override
        @Override
        public Stream<RegistryEntry<?>> registries() {
            return this.registries.entrySet().stream().map(RegistryEntry::fromMapEntry);
        }
    }

    public static interface Frozen
    extends RegistryAccess {
    }
}

