/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import io.papermc.paper.annotation.DoNotUse;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.phys.AABB;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseArmorEvent;
import org.bukkit.inventory.ItemStack;

public class EquipmentDispenseItemBehavior
extends DefaultDispenseItemBehavior {
    public static final EquipmentDispenseItemBehavior INSTANCE = new EquipmentDispenseItemBehavior();

    @Override
    protected net.minecraft.world.item.ItemStack execute(BlockSource pointer, net.minecraft.world.item.ItemStack stack) {
        return EquipmentDispenseItemBehavior.dispenseEquipment(pointer, stack, this) ? stack : super.execute(pointer, stack);
    }

    @Deprecated
    @DoNotUse
    public static boolean dispenseEquipment(BlockSource pointer, net.minecraft.world.item.ItemStack armor) {
        return EquipmentDispenseItemBehavior.dispenseEquipment(pointer, armor, null);
    }

    public static boolean dispenseEquipment(BlockSource pointer, net.minecraft.world.item.ItemStack stack, @Nullable DispenseItemBehavior currentBehavior) {
        BlockPos blockposition = pointer.pos().relative(pointer.state().getValue(DispenserBlock.FACING));
        List<net.minecraft.world.entity.LivingEntity> list = pointer.level().getEntitiesOfClass(net.minecraft.world.entity.LivingEntity.class, new AABB(blockposition), entityliving -> entityliving.canEquipWithDispenser(stack));
        if (list.isEmpty()) {
            return false;
        }
        net.minecraft.world.entity.LivingEntity entityliving2 = list.getFirst();
        EquipmentSlot enumitemslot = entityliving2.getEquipmentSlotForItem(stack);
        net.minecraft.world.item.ItemStack itemstack1 = stack.copyWithCount(1);
        ServerLevel world = pointer.level();
        CraftBlock block = CraftBlock.at(world, pointer.pos());
        CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
        BlockDispenseArmorEvent event = new BlockDispenseArmorEvent((Block)block, (ItemStack)craftItem.clone(), (LivingEntity)((CraftLivingEntity)entityliving2.getBukkitEntity()));
        if (!DispenserBlock.eventFired) {
            world.getCraftServer().getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return false;
        }
        boolean shrink = true;
        if (!event.getItem().equals((Object)craftItem)) {
            shrink = false;
            net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
            DispenseItemBehavior idispensebehavior = DispenserBlock.getDispenseBehavior(pointer, eventStack);
            if (idispensebehavior != DispenseItemBehavior.NOOP && (currentBehavior == null || idispensebehavior != currentBehavior)) {
                idispensebehavior.dispense(pointer, eventStack);
                return true;
            }
        }
        entityliving2.setItemSlot(enumitemslot, CraftItemStack.asNMSCopy(event.getItem()));
        if (entityliving2 instanceof Mob) {
            Mob entityinsentient = (Mob)entityliving2;
            entityinsentient.setDropChance(enumitemslot, 2.0f);
            entityinsentient.setPersistenceRequired();
        }
        if (shrink) {
            stack.shrink(1);
        }
        return true;
    }
}

