/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class MinecartDispenseItemBehavior
extends DefaultDispenseItemBehavior {
    private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();
    private final EntityType<? extends AbstractMinecart> entityType;

    public MinecartDispenseItemBehavior(EntityType<? extends AbstractMinecart> minecartEntityType) {
        this.entityType = minecartEntityType;
    }

    @Override
    public net.minecraft.world.item.ItemStack execute(BlockSource pointer, net.minecraft.world.item.ItemStack stack) {
        double d3;
        Direction enumdirection = pointer.state().getValue(DispenserBlock.FACING);
        ServerLevel worldserver = pointer.level();
        Vec3 vec3d = pointer.center();
        double d0 = vec3d.x() + (double)enumdirection.getStepX() * 1.125;
        double d1 = Math.floor(vec3d.y()) + (double)enumdirection.getStepY();
        double d2 = vec3d.z() + (double)enumdirection.getStepZ() * 1.125;
        BlockPos blockposition = pointer.pos().relative(enumdirection);
        BlockState iblockdata = worldserver.getBlockState(blockposition);
        if (iblockdata.is(BlockTags.RAILS)) {
            d3 = MinecartDispenseItemBehavior.getRailShape(iblockdata).isSlope() ? 0.6 : 0.1;
        } else {
            if (!iblockdata.isAir()) {
                return this.defaultDispenseItemBehavior.dispense(pointer, stack);
            }
            BlockState iblockdata1 = worldserver.getBlockState(blockposition.below());
            if (!iblockdata1.is(BlockTags.RAILS)) {
                return this.defaultDispenseItemBehavior.dispense(pointer, stack);
            }
            d3 = enumdirection != Direction.DOWN && MinecartDispenseItemBehavior.getRailShape(iblockdata1).isSlope() ? -0.4 : -0.9;
        }
        Vec3 vec3d1 = new Vec3(d0, d1 + d3, d2);
        net.minecraft.world.item.ItemStack itemstack1 = stack.copyWithCount(1);
        CraftBlock block2 = CraftBlock.at(worldserver, pointer.pos());
        CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
        BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)block2, (ItemStack)craftItem.clone(), new Vector(vec3d1.x, vec3d1.y, vec3d1.z));
        if (!DispenserBlock.eventFired) {
            worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return stack;
        }
        boolean shrink = true;
        if (!event.getItem().equals((Object)craftItem)) {
            shrink = false;
            net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
            DispenseItemBehavior idispensebehavior = DispenserBlock.getDispenseBehavior(pointer, eventStack);
            if (idispensebehavior != DispenseItemBehavior.NOOP && idispensebehavior != this) {
                idispensebehavior.dispense(pointer, eventStack);
                return stack;
            }
        }
        itemstack1 = CraftItemStack.asNMSCopy(event.getItem());
        AbstractMinecart entityminecartabstract = AbstractMinecart.createMinecart(worldserver, event.getVelocity().getX(), event.getVelocity().getY(), event.getVelocity().getZ(), this.entityType, EntitySpawnReason.DISPENSER, itemstack1, null);
        if (entityminecartabstract != null && worldserver.addFreshEntity(entityminecartabstract) && shrink) {
            stack.shrink(1);
        }
        return stack;
    }

    private static RailShape getRailShape(BlockState state) {
        RailShape blockpropertytrackposition;
        Block block = state.getBlock();
        if (block instanceof BaseRailBlock) {
            BaseRailBlock blockminecarttrackabstract = (BaseRailBlock)block;
            blockpropertytrackposition = state.getValue(blockminecarttrackabstract.getShapeProperty());
        } else {
            blockpropertytrackposition = RailShape.NORTH_SOUTH;
        }
        return blockpropertytrackposition;
    }

    @Override
    protected void playSound(BlockSource pointer) {
        pointer.level().levelEvent(1000, pointer.pos(), 0);
    }
}

