/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.WorldVersion;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.advancements.packs.VanillaAdvancementProvider;
import net.minecraft.data.advancements.packs.WinterDropAdvancementProvider;
import net.minecraft.data.info.BiomeParametersDumpReport;
import net.minecraft.data.info.BlockListReport;
import net.minecraft.data.info.CommandsReport;
import net.minecraft.data.info.DatapackStructureReport;
import net.minecraft.data.info.ItemListReport;
import net.minecraft.data.info.PacketReport;
import net.minecraft.data.info.RegistryDumpReport;
import net.minecraft.data.loot.packs.TradeRebalanceLootTableProvider;
import net.minecraft.data.loot.packs.VanillaLootTableProvider;
import net.minecraft.data.loot.packs.WinterDropLootTableProvider;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.data.models.EquipmentModelProvider;
import net.minecraft.data.models.ModelProvider;
import net.minecraft.data.recipes.packs.VanillaRecipeProvider;
import net.minecraft.data.recipes.packs.WinterDropRecipeProvider;
import net.minecraft.data.registries.RegistriesDatapackGenerator;
import net.minecraft.data.registries.TradeRebalanceRegistries;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.data.registries.WinterDropRegistries;
import net.minecraft.data.structures.NbtToSnbt;
import net.minecraft.data.structures.SnbtToNbt;
import net.minecraft.data.structures.StructureUpdater;
import net.minecraft.data.tags.BannerPatternTagsProvider;
import net.minecraft.data.tags.BiomeTagsProvider;
import net.minecraft.data.tags.CatVariantTagsProvider;
import net.minecraft.data.tags.DamageTypeTagsProvider;
import net.minecraft.data.tags.EntityTypeTagsProvider;
import net.minecraft.data.tags.FlatLevelGeneratorPresetTagsProvider;
import net.minecraft.data.tags.FluidTagsProvider;
import net.minecraft.data.tags.GameEventTagsProvider;
import net.minecraft.data.tags.InstrumentTagsProvider;
import net.minecraft.data.tags.PaintingVariantTagsProvider;
import net.minecraft.data.tags.PoiTypeTagsProvider;
import net.minecraft.data.tags.StructureTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.data.tags.TradeRebalanceEnchantmentTagsProvider;
import net.minecraft.data.tags.TradeRebalanceStructureTagsProvider;
import net.minecraft.data.tags.VanillaBlockTagsProvider;
import net.minecraft.data.tags.VanillaEnchantmentTagsProvider;
import net.minecraft.data.tags.VanillaItemTagsProvider;
import net.minecraft.data.tags.WinterDropBiomeTagsProvider;
import net.minecraft.data.tags.WinterDropBlockTagsProvider;
import net.minecraft.data.tags.WinterDropEntityTypeTagsProvider;
import net.minecraft.data.tags.WinterDropItemTagsProvider;
import net.minecraft.data.tags.WorldPresetTagsProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;

public class Main {
    @DontObfuscate
    public static void main(String[] args) throws IOException {
        SharedConstants.tryDetectVersion();
        OptionParser optionParser = new OptionParser();
        AbstractOptionSpec optionSpec = optionParser.accepts("help", "Show the help menu").forHelp();
        OptionSpecBuilder optionSpec2 = optionParser.accepts("server", "Include server generators");
        OptionSpecBuilder optionSpec3 = optionParser.accepts("client", "Include client generators");
        OptionSpecBuilder optionSpec4 = optionParser.accepts("dev", "Include development tools");
        OptionSpecBuilder optionSpec5 = optionParser.accepts("reports", "Include data reports");
        OptionSpecBuilder optionSpec6 = optionParser.accepts("validate", "Validate inputs");
        OptionSpecBuilder optionSpec7 = optionParser.accepts("all", "Include all generators");
        ArgumentAcceptingOptionSpec optionSpec8 = optionParser.accepts("output", "Output folder").withRequiredArg().defaultsTo((Object)"generated", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec optionSpec9 = optionParser.accepts("input", "Input folder").withRequiredArg();
        OptionSet optionSet = optionParser.parse(args);
        if (optionSet.has((OptionSpec)optionSpec) || !optionSet.hasOptions()) {
            optionParser.printHelpOn((OutputStream)System.out);
            return;
        }
        Path path = Paths.get((String)optionSpec8.value(optionSet), new String[0]);
        boolean bl = optionSet.has((OptionSpec)optionSpec7);
        boolean bl2 = bl || optionSet.has((OptionSpec)optionSpec3);
        boolean bl3 = bl || optionSet.has((OptionSpec)optionSpec2);
        boolean bl4 = bl || optionSet.has((OptionSpec)optionSpec4);
        boolean bl5 = bl || optionSet.has((OptionSpec)optionSpec5);
        boolean bl6 = bl || optionSet.has((OptionSpec)optionSpec6);
        DataGenerator dataGenerator = Main.createStandardGenerator(path, optionSet.valuesOf((OptionSpec)optionSpec9).stream().map(input -> Paths.get(input, new String[0])).collect(Collectors.toList()), bl2, bl3, bl4, bl5, bl6, SharedConstants.getCurrentVersion(), true);
        dataGenerator.run();
    }

    private static <T extends DataProvider> DataProvider.Factory<T> bindRegistries(BiFunction<PackOutput, CompletableFuture<HolderLookup.Provider>, T> baseFactory, CompletableFuture<HolderLookup.Provider> registriesFuture) {
        return output -> (DataProvider)baseFactory.apply(output, registriesFuture);
    }

    public static DataGenerator createStandardGenerator(Path output2, Collection<Path> inputs, boolean includeClient, boolean includeServer, boolean includeDev, boolean includeReports, boolean validate, WorldVersion gameVersion, boolean ignoreCache) {
        DataGenerator dataGenerator = new DataGenerator(output2, gameVersion, ignoreCache);
        DataGenerator.PackGenerator packGenerator = dataGenerator.getVanillaPack(includeClient || includeServer);
        packGenerator.addProvider(outputx -> new SnbtToNbt(outputx, inputs).addFilter(new StructureUpdater()));
        CompletableFuture<HolderLookup.Provider> completableFuture = CompletableFuture.supplyAsync(VanillaRegistries::createLookup, Util.backgroundExecutor());
        DataGenerator.PackGenerator packGenerator2 = dataGenerator.getVanillaPack(includeClient);
        packGenerator2.addProvider(ModelProvider::new);
        packGenerator2.addProvider(EquipmentModelProvider::new);
        DataGenerator.PackGenerator packGenerator3 = dataGenerator.getVanillaPack(includeServer);
        packGenerator3.addProvider(Main.bindRegistries(RegistriesDatapackGenerator::new, completableFuture));
        packGenerator3.addProvider(Main.bindRegistries(VanillaAdvancementProvider::create, completableFuture));
        packGenerator3.addProvider(Main.bindRegistries(VanillaLootTableProvider::create, completableFuture));
        packGenerator3.addProvider(Main.bindRegistries(VanillaRecipeProvider.Runner::new, completableFuture));
        TagsProvider tagsProvider = packGenerator3.addProvider(Main.bindRegistries(VanillaBlockTagsProvider::new, completableFuture));
        TagsProvider tagsProvider2 = packGenerator3.addProvider(outputx -> new VanillaItemTagsProvider(outputx, completableFuture, tagsProvider.contentsGetter()));
        TagsProvider tagsProvider3 = packGenerator3.addProvider(Main.bindRegistries(BiomeTagsProvider::new, completableFuture));
        TagsProvider tagsProvider4 = packGenerator3.addProvider(Main.bindRegistries(BannerPatternTagsProvider::new, completableFuture));
        TagsProvider tagsProvider5 = packGenerator3.addProvider(Main.bindRegistries(StructureTagsProvider::new, completableFuture));
        packGenerator3.addProvider(Main.bindRegistries(CatVariantTagsProvider::new, completableFuture));
        packGenerator3.addProvider(Main.bindRegistries(DamageTypeTagsProvider::new, completableFuture));
        packGenerator3.addProvider(Main.bindRegistries(EntityTypeTagsProvider::new, completableFuture));
        packGenerator3.addProvider(Main.bindRegistries(FlatLevelGeneratorPresetTagsProvider::new, completableFuture));
        packGenerator3.addProvider(Main.bindRegistries(FluidTagsProvider::new, completableFuture));
        packGenerator3.addProvider(Main.bindRegistries(GameEventTagsProvider::new, completableFuture));
        packGenerator3.addProvider(Main.bindRegistries(InstrumentTagsProvider::new, completableFuture));
        packGenerator3.addProvider(Main.bindRegistries(PaintingVariantTagsProvider::new, completableFuture));
        packGenerator3.addProvider(Main.bindRegistries(PoiTypeTagsProvider::new, completableFuture));
        packGenerator3.addProvider(Main.bindRegistries(WorldPresetTagsProvider::new, completableFuture));
        packGenerator3.addProvider(Main.bindRegistries(VanillaEnchantmentTagsProvider::new, completableFuture));
        DataGenerator.PackGenerator packGenerator4 = dataGenerator.getVanillaPack(includeDev);
        packGenerator4.addProvider(outputx -> new NbtToSnbt(outputx, inputs));
        DataGenerator.PackGenerator packGenerator5 = dataGenerator.getVanillaPack(includeReports);
        packGenerator5.addProvider(Main.bindRegistries(BiomeParametersDumpReport::new, completableFuture));
        packGenerator5.addProvider(Main.bindRegistries(ItemListReport::new, completableFuture));
        packGenerator5.addProvider(Main.bindRegistries(BlockListReport::new, completableFuture));
        packGenerator5.addProvider(Main.bindRegistries(CommandsReport::new, completableFuture));
        packGenerator5.addProvider(RegistryDumpReport::new);
        packGenerator5.addProvider(PacketReport::new);
        packGenerator5.addProvider(DatapackStructureReport::new);
        CompletableFuture<RegistrySetBuilder.PatchedRegistries> completableFuture2 = TradeRebalanceRegistries.createLookup(completableFuture);
        CompletionStage completableFuture3 = completableFuture2.thenApply(RegistrySetBuilder.PatchedRegistries::patches);
        DataGenerator.PackGenerator packGenerator6 = dataGenerator.getBuiltinDatapack(includeServer, "trade_rebalance");
        packGenerator6.addProvider(Main.bindRegistries(RegistriesDatapackGenerator::new, (CompletableFuture<HolderLookup.Provider>)completableFuture3));
        packGenerator6.addProvider(outputx -> PackMetadataGenerator.forFeaturePack(outputx, Component.translatable("dataPack.trade_rebalance.description"), FeatureFlagSet.of(FeatureFlags.TRADE_REBALANCE)));
        packGenerator6.addProvider(Main.bindRegistries(TradeRebalanceLootTableProvider::create, completableFuture));
        packGenerator6.addProvider(Main.bindRegistries(TradeRebalanceStructureTagsProvider::new, completableFuture));
        packGenerator6.addProvider(Main.bindRegistries(TradeRebalanceEnchantmentTagsProvider::new, completableFuture));
        DataGenerator.PackGenerator packGenerator7 = dataGenerator.getBuiltinDatapack(includeServer, "redstone_experiments");
        packGenerator7.addProvider(outputx -> PackMetadataGenerator.forFeaturePack(outputx, Component.translatable("dataPack.redstone_experiments.description"), FeatureFlagSet.of(FeatureFlags.REDSTONE_EXPERIMENTS)));
        DataGenerator.PackGenerator packGenerator8 = dataGenerator.getBuiltinDatapack(includeServer, "minecart_improvements");
        packGenerator8.addProvider(outputx -> PackMetadataGenerator.forFeaturePack(outputx, Component.translatable("dataPack.minecart_improvements.description"), FeatureFlagSet.of(FeatureFlags.MINECART_IMPROVEMENTS)));
        CompletableFuture<RegistrySetBuilder.PatchedRegistries> completableFuture4 = WinterDropRegistries.createLookup(completableFuture);
        CompletionStage completableFuture5 = completableFuture4.thenApply(RegistrySetBuilder.PatchedRegistries::full);
        DataGenerator.PackGenerator packGenerator9 = dataGenerator.getBuiltinDatapack(includeServer, "winter_drop");
        packGenerator9.addProvider(Main.bindRegistries(RegistriesDatapackGenerator::new, (CompletableFuture<HolderLookup.Provider>)completableFuture4.thenApply(RegistrySetBuilder.PatchedRegistries::patches)));
        packGenerator9.addProvider(Main.bindRegistries(WinterDropRecipeProvider.Runner::new, (CompletableFuture<HolderLookup.Provider>)completableFuture5));
        TagsProvider tagsProvider6 = packGenerator9.addProvider(arg_0 -> Main.lambda$createStandardGenerator$8((CompletableFuture)completableFuture5, tagsProvider, arg_0));
        packGenerator9.addProvider(arg_0 -> Main.lambda$createStandardGenerator$9((CompletableFuture)completableFuture5, tagsProvider2, tagsProvider6, arg_0));
        packGenerator9.addProvider(arg_0 -> Main.lambda$createStandardGenerator$10((CompletableFuture)completableFuture5, tagsProvider3, arg_0));
        packGenerator9.addProvider(Main.bindRegistries(WinterDropLootTableProvider::create, (CompletableFuture<HolderLookup.Provider>)completableFuture5));
        packGenerator9.addProvider(output -> PackMetadataGenerator.forFeaturePack(output, Component.translatable("dataPack.winter_drop.description"), FeatureFlagSet.of(FeatureFlags.WINTER_DROP)));
        packGenerator9.addProvider(Main.bindRegistries(WinterDropEntityTypeTagsProvider::new, (CompletableFuture<HolderLookup.Provider>)completableFuture5));
        packGenerator9.addProvider(Main.bindRegistries(WinterDropAdvancementProvider::create, (CompletableFuture<HolderLookup.Provider>)completableFuture5));
        return dataGenerator;
    }

    private static /* synthetic */ WinterDropBiomeTagsProvider lambda$createStandardGenerator$10(CompletableFuture completableFuture, TagsProvider tagsProvider, PackOutput output) {
        return new WinterDropBiomeTagsProvider(output, completableFuture, tagsProvider.contentsGetter());
    }

    private static /* synthetic */ WinterDropItemTagsProvider lambda$createStandardGenerator$9(CompletableFuture completableFuture, TagsProvider tagsProvider, TagsProvider tagsProvider2, PackOutput output) {
        return new WinterDropItemTagsProvider(output, completableFuture, tagsProvider.contentsGetter(), tagsProvider2.contentsGetter());
    }

    private static /* synthetic */ WinterDropBlockTagsProvider lambda$createStandardGenerator$8(CompletableFuture completableFuture, TagsProvider tagsProvider, PackOutput outout) {
        return new WinterDropBlockTagsProvider(outout, completableFuture, tagsProvider.contentsGetter());
    }
}

