/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.models.blockstates;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Selector;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;

public class MultiVariantGenerator
implements BlockStateGenerator {
    private final Block block;
    private final List<Variant> baseVariants;
    private final Set<Property<?>> seenProperties = Sets.newHashSet();
    private final List<PropertyDispatch> declaredPropertySets = Lists.newArrayList();

    private MultiVariantGenerator(Block block, List<Variant> variants) {
        this.block = block;
        this.baseVariants = variants;
    }

    public MultiVariantGenerator with(PropertyDispatch map) {
        map.getDefinedProperties().forEach(property -> {
            if (this.block.getStateDefinition().getProperty(property.getName()) != property) {
                throw new IllegalStateException("Property " + String.valueOf(property) + " is not defined for block " + String.valueOf(this.block));
            }
            if (!this.seenProperties.add((Property<?>)property)) {
                throw new IllegalStateException("Values of property " + String.valueOf(property) + " already defined for block " + String.valueOf(this.block));
            }
        });
        this.declaredPropertySets.add(map);
        return this;
    }

    @Override
    @Override
    public JsonElement get() {
        Stream<Object> stream = Stream.of(Pair.of((Object)Selector.empty(), this.baseVariants));
        for (PropertyDispatch propertyDispatch : this.declaredPropertySets) {
            Map<Selector, List<Variant>> map = propertyDispatch.getEntries();
            stream = stream.flatMap(pair -> map.entrySet().stream().map(entry -> {
                Selector selector = ((Selector)pair.getFirst()).extend((Selector)entry.getKey());
                List<Variant> list = MultiVariantGenerator.mergeVariants((List)pair.getSecond(), (List)entry.getValue());
                return Pair.of((Object)selector, list);
            }));
        }
        TreeMap map2 = new TreeMap();
        stream.forEach(pair -> map2.put(((Selector)pair.getFirst()).getKey(), Variant.convertList((List)pair.getSecond())));
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("variants", (JsonElement)Util.make(new JsonObject(), json -> map2.forEach((arg_0, arg_1) -> ((JsonObject)json).add(arg_0, arg_1))));
        return jsonObject;
    }

    private static List<Variant> mergeVariants(List<Variant> left, List<Variant> right) {
        ImmutableList.Builder builder = ImmutableList.builder();
        left.forEach(leftVariant -> right.forEach(rightVariant -> builder.add((Object)Variant.merge(leftVariant, rightVariant))));
        return builder.build();
    }

    @Override
    @Override
    public Block getBlock() {
        return this.block;
    }

    public static MultiVariantGenerator multiVariant(Block block) {
        return new MultiVariantGenerator(block, (List<Variant>)ImmutableList.of((Object)Variant.variant()));
    }

    public static MultiVariantGenerator multiVariant(Block block, Variant variant) {
        return new MultiVariantGenerator(block, (List<Variant>)ImmutableList.of((Object)variant));
    }

    public static MultiVariantGenerator multiVariant(Block block, Variant ... variants) {
        return new MultiVariantGenerator(block, (List<Variant>)ImmutableList.copyOf((Object[])variants));
    }

    @Override
    public /* synthetic */ Object get() {
        return this.get();
    }
}

