/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.recipes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.EnterBlockTrigger;
import net.minecraft.advancements.critereon.ImpossibleTrigger;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.BlockFamilies;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.data.recipes.SmithingTrimRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SuspiciousEffectHolder;

public abstract class RecipeProvider {
    protected final HolderLookup.Provider registries;
    private final HolderGetter<Item> items;
    protected final RecipeOutput output;
    private static final Map<BlockFamily.Variant, FamilyRecipeProvider> SHAPE_BUILDERS = ImmutableMap.builder().put((Object)BlockFamily.Variant.BUTTON, (generator, output, input) -> generator.buttonBuilder(output, Ingredient.of(input))).put((Object)BlockFamily.Variant.CHISELED, (generator, output, input) -> generator.chiseledBuilder(RecipeCategory.BUILDING_BLOCKS, output, Ingredient.of(input))).put((Object)BlockFamily.Variant.CUT, (generator, output, input) -> generator.cutBuilder(RecipeCategory.BUILDING_BLOCKS, output, Ingredient.of(input))).put((Object)BlockFamily.Variant.DOOR, (generator, output, input) -> generator.doorBuilder(output, Ingredient.of(input))).put((Object)BlockFamily.Variant.CUSTOM_FENCE, (generator, output, input) -> generator.fenceBuilder(output, Ingredient.of(input))).put((Object)BlockFamily.Variant.FENCE, (generator, output, input) -> generator.fenceBuilder(output, Ingredient.of(input))).put((Object)BlockFamily.Variant.CUSTOM_FENCE_GATE, (generator, output, input) -> generator.fenceGateBuilder(output, Ingredient.of(input))).put((Object)BlockFamily.Variant.FENCE_GATE, (generator, output, input) -> generator.fenceGateBuilder(output, Ingredient.of(input))).put((Object)BlockFamily.Variant.SIGN, (generator, output, input) -> generator.signBuilder(output, Ingredient.of(input))).put((Object)BlockFamily.Variant.SLAB, (generator, output, input) -> generator.slabBuilder(RecipeCategory.BUILDING_BLOCKS, output, Ingredient.of(input))).put((Object)BlockFamily.Variant.STAIRS, (generator, output, input) -> generator.stairBuilder(output, Ingredient.of(input))).put((Object)BlockFamily.Variant.PRESSURE_PLATE, (generator, output, input) -> generator.pressurePlateBuilder(RecipeCategory.REDSTONE, output, Ingredient.of(input))).put((Object)BlockFamily.Variant.POLISHED, (generator, output, input) -> generator.polishedBuilder(RecipeCategory.BUILDING_BLOCKS, output, Ingredient.of(input))).put((Object)BlockFamily.Variant.TRAPDOOR, (generator, output, input) -> generator.trapdoorBuilder(output, Ingredient.of(input))).put((Object)BlockFamily.Variant.WALL, (generator, output, input) -> generator.wallBuilder(RecipeCategory.DECORATIONS, output, Ingredient.of(input))).build();

    protected RecipeProvider(HolderLookup.Provider registries, RecipeOutput exporter) {
        this.registries = registries;
        this.items = registries.lookupOrThrow(Registries.ITEM);
        this.output = exporter;
    }

    protected abstract void buildRecipes();

    protected void generateForEnabledBlockFamilies(FeatureFlagSet enabledFeatures) {
        BlockFamilies.getAllFamilies().filter(BlockFamily::shouldGenerateRecipe).forEach(family -> this.generateRecipes((BlockFamily)family, enabledFeatures));
    }

    protected void oneToOneConversionRecipe(ItemLike output, ItemLike input, @Nullable String group) {
        this.oneToOneConversionRecipe(output, input, group, 1);
    }

    protected void oneToOneConversionRecipe(ItemLike output, ItemLike input, @Nullable String group, int outputCount) {
        this.shapeless(RecipeCategory.MISC, output, outputCount).requires(input).group(group).unlockedBy(RecipeProvider.getHasName(input), (Criterion)this.has(input)).save(this.output, RecipeProvider.getConversionRecipeName(output, input));
    }

    protected void oreSmelting(List<ItemLike> inputs, RecipeCategory category, ItemLike output, float experience, int cookingTime, String group) {
        this.oreCooking(RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new, inputs, category, output, experience, cookingTime, group, "_from_smelting");
    }

    protected void oreBlasting(List<ItemLike> inputs, RecipeCategory category, ItemLike output, float experience, int cookingTime, String group) {
        this.oreCooking(RecipeSerializer.BLASTING_RECIPE, BlastingRecipe::new, inputs, category, output, experience, cookingTime, group, "_from_blasting");
    }

    private <T extends AbstractCookingRecipe> void oreCooking(RecipeSerializer<T> serializer, AbstractCookingRecipe.Factory<T> recipeFactory, List<ItemLike> inputs, RecipeCategory category, ItemLike output, float experience, int cookingTime, String group, String suffix) {
        for (ItemLike itemLike : inputs) {
            SimpleCookingRecipeBuilder.generic(Ingredient.of(itemLike), category, output, experience, cookingTime, serializer, recipeFactory).group(group).unlockedBy(RecipeProvider.getHasName(itemLike), (Criterion)this.has(itemLike)).save(this.output, RecipeProvider.getItemName(output) + suffix + "_" + RecipeProvider.getItemName(itemLike));
        }
    }

    protected void netheriteSmithing(Item input, RecipeCategory category, Item result) {
        SmithingTransformRecipeBuilder.smithing(Ingredient.of((ItemLike)Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE), Ingredient.of((ItemLike)input), this.tag(ItemTags.NETHERITE_TOOL_MATERIALS), category, result).unlocks("has_netherite_ingot", this.has(ItemTags.NETHERITE_TOOL_MATERIALS)).save(this.output, RecipeProvider.getItemName(result) + "_smithing");
    }

    protected void trimSmithing(Item input, ResourceKey<Recipe<?>> resourceKey) {
        SmithingTrimRecipeBuilder.smithingTrim(Ingredient.of((ItemLike)input), this.tag(ItemTags.TRIMMABLE_ARMOR), this.tag(ItemTags.TRIM_MATERIALS), RecipeCategory.MISC).unlocks("has_smithing_trim_template", this.has(input)).save(this.output, resourceKey);
    }

    protected void twoByTwoPacker(RecipeCategory category, ItemLike output, ItemLike input) {
        this.shaped(category, output, 1).define(Character.valueOf('#'), input).pattern("##").pattern("##").unlockedBy(RecipeProvider.getHasName(input), (Criterion)this.has(input)).save(this.output);
    }

    protected void threeByThreePacker(RecipeCategory category, ItemLike output, ItemLike input, String criterionName) {
        this.shapeless(category, output).requires(input, 9).unlockedBy(criterionName, (Criterion)this.has(input)).save(this.output);
    }

    protected void threeByThreePacker(RecipeCategory category, ItemLike output, ItemLike input) {
        this.threeByThreePacker(category, output, input, RecipeProvider.getHasName(input));
    }

    protected void planksFromLog(ItemLike output, TagKey<Item> logTag, int count) {
        this.shapeless(RecipeCategory.BUILDING_BLOCKS, output, count).requires(logTag).group("planks").unlockedBy("has_log", (Criterion)this.has(logTag)).save(this.output);
    }

    protected void planksFromLogs(ItemLike output, TagKey<Item> logTag, int count) {
        this.shapeless(RecipeCategory.BUILDING_BLOCKS, output, count).requires(logTag).group("planks").unlockedBy("has_logs", (Criterion)this.has(logTag)).save(this.output);
    }

    protected void woodFromLogs(ItemLike output, ItemLike input) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, output, 3).define(Character.valueOf('#'), input).pattern("##").pattern("##").group("bark").unlockedBy("has_log", (Criterion)this.has(input)).save(this.output);
    }

    protected void woodenBoat(ItemLike output, ItemLike input) {
        this.shaped(RecipeCategory.TRANSPORTATION, output).define(Character.valueOf('#'), input).pattern("# #").pattern("###").group("boat").unlockedBy("in_water", (Criterion)RecipeProvider.insideOf(Blocks.WATER)).save(this.output);
    }

    protected void chestBoat(ItemLike output, ItemLike input) {
        this.shapeless(RecipeCategory.TRANSPORTATION, output).requires(Blocks.CHEST).requires(input).group("chest_boat").unlockedBy("has_boat", (Criterion)this.has(ItemTags.BOATS)).save(this.output);
    }

    private RecipeBuilder buttonBuilder(ItemLike output, Ingredient input) {
        return this.shapeless(RecipeCategory.REDSTONE, output).requires(input);
    }

    protected RecipeBuilder doorBuilder(ItemLike output, Ingredient input) {
        return this.shaped(RecipeCategory.REDSTONE, output, 3).define(Character.valueOf('#'), input).pattern("##").pattern("##").pattern("##");
    }

    private RecipeBuilder fenceBuilder(ItemLike output, Ingredient input) {
        int i = output == Blocks.NETHER_BRICK_FENCE ? 6 : 3;
        Item item = output == Blocks.NETHER_BRICK_FENCE ? Items.NETHER_BRICK : Items.STICK;
        return this.shaped(RecipeCategory.DECORATIONS, output, i).define(Character.valueOf('W'), input).define(Character.valueOf('#'), item).pattern("W#W").pattern("W#W");
    }

    private RecipeBuilder fenceGateBuilder(ItemLike output, Ingredient input) {
        return this.shaped(RecipeCategory.REDSTONE, output).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('W'), input).pattern("#W#").pattern("#W#");
    }

    protected void pressurePlate(ItemLike output, ItemLike input) {
        this.pressurePlateBuilder(RecipeCategory.REDSTONE, output, Ingredient.of(input)).unlockedBy(RecipeProvider.getHasName(input), this.has(input)).save(this.output);
    }

    private RecipeBuilder pressurePlateBuilder(RecipeCategory category, ItemLike output, Ingredient input) {
        return this.shaped(category, output).define(Character.valueOf('#'), input).pattern("##");
    }

    protected void slab(RecipeCategory category, ItemLike output, ItemLike input) {
        this.slabBuilder(category, output, Ingredient.of(input)).unlockedBy(RecipeProvider.getHasName(input), this.has(input)).save(this.output);
    }

    protected RecipeBuilder slabBuilder(RecipeCategory category, ItemLike output, Ingredient input) {
        return this.shaped(category, output, 6).define(Character.valueOf('#'), input).pattern("###");
    }

    protected RecipeBuilder stairBuilder(ItemLike output, Ingredient input) {
        return this.shaped(RecipeCategory.BUILDING_BLOCKS, output, 4).define(Character.valueOf('#'), input).pattern("#  ").pattern("## ").pattern("###");
    }

    protected RecipeBuilder trapdoorBuilder(ItemLike output, Ingredient input) {
        return this.shaped(RecipeCategory.REDSTONE, output, 2).define(Character.valueOf('#'), input).pattern("###").pattern("###");
    }

    private RecipeBuilder signBuilder(ItemLike output, Ingredient input) {
        return this.shaped(RecipeCategory.DECORATIONS, output, 3).group("sign").define(Character.valueOf('#'), input).define(Character.valueOf('X'), Items.STICK).pattern("###").pattern("###").pattern(" X ");
    }

    protected void hangingSign(ItemLike output, ItemLike input) {
        this.shaped(RecipeCategory.DECORATIONS, output, 6).group("hanging_sign").define(Character.valueOf('#'), input).define(Character.valueOf('X'), Items.CHAIN).pattern("X X").pattern("###").pattern("###").unlockedBy("has_stripped_logs", (Criterion)this.has(input)).save(this.output);
    }

    protected void colorBlockWithDye(List<Item> dyes, List<Item> dyeables, String group) {
        this.colorWithDye(dyes, dyeables, null, group, RecipeCategory.BUILDING_BLOCKS);
    }

    protected void colorWithDye(List<Item> dyes, List<Item> dyeables, @Nullable Item undyed, String group, RecipeCategory category) {
        for (int i = 0; i < dyes.size(); ++i) {
            Item item2 = dyes.get(i);
            Item item22 = dyeables.get(i);
            Stream<Item> stream = dyeables.stream().filter(item -> !item.equals(item22));
            if (undyed != null) {
                stream = Stream.concat(stream, Stream.of(undyed));
            }
            this.shapeless(category, item22).requires(item2).requires(Ingredient.of(stream)).group(group).unlockedBy("has_needed_dye", (Criterion)this.has(item2)).save(this.output, "dye_" + RecipeProvider.getItemName(item22));
        }
    }

    protected void carpet(ItemLike output, ItemLike input) {
        this.shaped(RecipeCategory.DECORATIONS, output, 3).define(Character.valueOf('#'), input).pattern("##").group("carpet").unlockedBy(RecipeProvider.getHasName(input), (Criterion)this.has(input)).save(this.output);
    }

    protected void bedFromPlanksAndWool(ItemLike output, ItemLike inputWool) {
        this.shaped(RecipeCategory.DECORATIONS, output).define(Character.valueOf('#'), inputWool).define(Character.valueOf('X'), ItemTags.PLANKS).pattern("###").pattern("XXX").group("bed").unlockedBy(RecipeProvider.getHasName(inputWool), (Criterion)this.has(inputWool)).save(this.output);
    }

    protected void banner(ItemLike output, ItemLike inputWool) {
        this.shaped(RecipeCategory.DECORATIONS, output).define(Character.valueOf('#'), inputWool).define(Character.valueOf('|'), Items.STICK).pattern("###").pattern("###").pattern(" | ").group("banner").unlockedBy(RecipeProvider.getHasName(inputWool), (Criterion)this.has(inputWool)).save(this.output);
    }

    protected void stainedGlassFromGlassAndDye(ItemLike output, ItemLike input) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, output, 8).define(Character.valueOf('#'), Blocks.GLASS).define(Character.valueOf('X'), input).pattern("###").pattern("#X#").pattern("###").group("stained_glass").unlockedBy("has_glass", (Criterion)this.has(Blocks.GLASS)).save(this.output);
    }

    protected void stainedGlassPaneFromStainedGlass(ItemLike output, ItemLike input) {
        this.shaped(RecipeCategory.DECORATIONS, output, 16).define(Character.valueOf('#'), input).pattern("###").pattern("###").group("stained_glass_pane").unlockedBy("has_glass", (Criterion)this.has(input)).save(this.output);
    }

    protected void stainedGlassPaneFromGlassPaneAndDye(ItemLike output, ItemLike inputDye) {
        ((ShapedRecipeBuilder)this.shaped(RecipeCategory.DECORATIONS, output, 8).define(Character.valueOf('#'), Blocks.GLASS_PANE).define(Character.valueOf('$'), inputDye).pattern("###").pattern("#$#").pattern("###").group("stained_glass_pane").unlockedBy("has_glass_pane", (Criterion)this.has(Blocks.GLASS_PANE))).unlockedBy(RecipeProvider.getHasName(inputDye), (Criterion)this.has(inputDye)).save(this.output, RecipeProvider.getConversionRecipeName(output, Blocks.GLASS_PANE));
    }

    protected void coloredTerracottaFromTerracottaAndDye(ItemLike output, ItemLike input) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, output, 8).define(Character.valueOf('#'), Blocks.TERRACOTTA).define(Character.valueOf('X'), input).pattern("###").pattern("#X#").pattern("###").group("stained_terracotta").unlockedBy("has_terracotta", (Criterion)this.has(Blocks.TERRACOTTA)).save(this.output);
    }

    protected void concretePowder(ItemLike output, ItemLike input) {
        ((ShapelessRecipeBuilder)this.shapeless(RecipeCategory.BUILDING_BLOCKS, output, 8).requires(input).requires(Blocks.SAND, 4).requires(Blocks.GRAVEL, 4).group("concrete_powder").unlockedBy("has_sand", (Criterion)this.has(Blocks.SAND))).unlockedBy("has_gravel", (Criterion)this.has(Blocks.GRAVEL)).save(this.output);
    }

    protected void candle(ItemLike output, ItemLike input) {
        this.shapeless(RecipeCategory.DECORATIONS, output).requires(Blocks.CANDLE).requires(input).group("dyed_candle").unlockedBy(RecipeProvider.getHasName(input), (Criterion)this.has(input)).save(this.output);
    }

    protected void wall(RecipeCategory category, ItemLike output, ItemLike input) {
        this.wallBuilder(category, output, Ingredient.of(input)).unlockedBy(RecipeProvider.getHasName(input), this.has(input)).save(this.output);
    }

    private RecipeBuilder wallBuilder(RecipeCategory category, ItemLike output, Ingredient input) {
        return this.shaped(category, output, 6).define(Character.valueOf('#'), input).pattern("###").pattern("###");
    }

    protected void polished(RecipeCategory category, ItemLike output, ItemLike input) {
        this.polishedBuilder(category, output, Ingredient.of(input)).unlockedBy(RecipeProvider.getHasName(input), this.has(input)).save(this.output);
    }

    private RecipeBuilder polishedBuilder(RecipeCategory category, ItemLike output, Ingredient input) {
        return this.shaped(category, output, 4).define(Character.valueOf('S'), input).pattern("SS").pattern("SS");
    }

    protected void cut(RecipeCategory category, ItemLike output, ItemLike input) {
        this.cutBuilder(category, output, Ingredient.of(input)).unlockedBy(RecipeProvider.getHasName(input), (Criterion)this.has(input)).save(this.output);
    }

    private ShapedRecipeBuilder cutBuilder(RecipeCategory category, ItemLike output, Ingredient input) {
        return this.shaped(category, output, 4).define(Character.valueOf('#'), input).pattern("##").pattern("##");
    }

    protected void chiseled(RecipeCategory category, ItemLike output, ItemLike input) {
        this.chiseledBuilder(category, output, Ingredient.of(input)).unlockedBy(RecipeProvider.getHasName(input), (Criterion)this.has(input)).save(this.output);
    }

    protected void mosaicBuilder(RecipeCategory category, ItemLike output, ItemLike input) {
        this.shaped(category, output).define(Character.valueOf('#'), input).pattern("#").pattern("#").unlockedBy(RecipeProvider.getHasName(input), (Criterion)this.has(input)).save(this.output);
    }

    protected ShapedRecipeBuilder chiseledBuilder(RecipeCategory category, ItemLike output, Ingredient input) {
        return this.shaped(category, output).define(Character.valueOf('#'), input).pattern("#").pattern("#");
    }

    protected void stonecutterResultFromBase(RecipeCategory category, ItemLike output, ItemLike input) {
        this.stonecutterResultFromBase(category, output, input, 1);
    }

    protected void stonecutterResultFromBase(RecipeCategory category, ItemLike output, ItemLike input, int count) {
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(input), category, output, count).unlockedBy(RecipeProvider.getHasName(input), (Criterion)this.has(input)).save(this.output, RecipeProvider.getConversionRecipeName(output, input) + "_stonecutting");
    }

    private void smeltingResultFromBase(ItemLike output, ItemLike input) {
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(input), RecipeCategory.BUILDING_BLOCKS, output, 0.1f, 200).unlockedBy(RecipeProvider.getHasName(input), (Criterion)this.has(input)).save(this.output);
    }

    protected void nineBlockStorageRecipes(RecipeCategory reverseCategory, ItemLike baseItem, RecipeCategory compactingCategory, ItemLike compactItem) {
        this.nineBlockStorageRecipes(reverseCategory, baseItem, compactingCategory, compactItem, RecipeProvider.getSimpleRecipeName(compactItem), null, RecipeProvider.getSimpleRecipeName(baseItem), null);
    }

    protected void nineBlockStorageRecipesWithCustomPacking(RecipeCategory reverseCategory, ItemLike baseItem, RecipeCategory compactingCategory, ItemLike compactItem, String compactingId, String compactingGroup) {
        this.nineBlockStorageRecipes(reverseCategory, baseItem, compactingCategory, compactItem, compactingId, compactingGroup, RecipeProvider.getSimpleRecipeName(baseItem), null);
    }

    protected void nineBlockStorageRecipesRecipesWithCustomUnpacking(RecipeCategory reverseCategory, ItemLike baseItem, RecipeCategory compactingCategory, ItemLike compactItem, String reverseId, String reverseGroup) {
        this.nineBlockStorageRecipes(reverseCategory, baseItem, compactingCategory, compactItem, RecipeProvider.getSimpleRecipeName(compactItem), null, reverseId, reverseGroup);
    }

    private void nineBlockStorageRecipes(RecipeCategory reverseCategory, ItemLike baseItem, RecipeCategory compactingCategory, ItemLike compactItem, String compactingId, @Nullable String compactingGroup, String reverseId, @Nullable String reverseGroup) {
        ((ShapelessRecipeBuilder)this.shapeless(reverseCategory, baseItem, 9).requires(compactItem).group(reverseGroup).unlockedBy(RecipeProvider.getHasName(compactItem), (Criterion)this.has(compactItem))).save(this.output, ResourceKey.create(Registries.RECIPE, ResourceLocation.parse(reverseId)));
        ((ShapedRecipeBuilder)this.shaped(compactingCategory, compactItem).define(Character.valueOf('#'), baseItem).pattern("###").pattern("###").pattern("###").group(compactingGroup).unlockedBy(RecipeProvider.getHasName(baseItem), (Criterion)this.has(baseItem))).save(this.output, ResourceKey.create(Registries.RECIPE, ResourceLocation.parse(compactingId)));
    }

    protected void copySmithingTemplate(ItemLike template, ItemLike resource) {
        this.shaped(RecipeCategory.MISC, template, 2).define(Character.valueOf('#'), Items.DIAMOND).define(Character.valueOf('C'), resource).define(Character.valueOf('S'), template).pattern("#S#").pattern("#C#").pattern("###").unlockedBy(RecipeProvider.getHasName(template), (Criterion)this.has(template)).save(this.output);
    }

    protected void copySmithingTemplate(ItemLike template, Ingredient resource) {
        this.shaped(RecipeCategory.MISC, template, 2).define(Character.valueOf('#'), Items.DIAMOND).define(Character.valueOf('C'), resource).define(Character.valueOf('S'), template).pattern("#S#").pattern("#C#").pattern("###").unlockedBy(RecipeProvider.getHasName(template), (Criterion)this.has(template)).save(this.output);
    }

    protected <T extends AbstractCookingRecipe> void cookRecipes(String cooker, RecipeSerializer<T> serializer, AbstractCookingRecipe.Factory<T> recipeFactory, int cookingTime) {
        this.simpleCookingRecipe(cooker, serializer, recipeFactory, cookingTime, Items.BEEF, Items.COOKED_BEEF, 0.35f);
        this.simpleCookingRecipe(cooker, serializer, recipeFactory, cookingTime, Items.CHICKEN, Items.COOKED_CHICKEN, 0.35f);
        this.simpleCookingRecipe(cooker, serializer, recipeFactory, cookingTime, Items.COD, Items.COOKED_COD, 0.35f);
        this.simpleCookingRecipe(cooker, serializer, recipeFactory, cookingTime, Items.KELP, Items.DRIED_KELP, 0.1f);
        this.simpleCookingRecipe(cooker, serializer, recipeFactory, cookingTime, Items.SALMON, Items.COOKED_SALMON, 0.35f);
        this.simpleCookingRecipe(cooker, serializer, recipeFactory, cookingTime, Items.MUTTON, Items.COOKED_MUTTON, 0.35f);
        this.simpleCookingRecipe(cooker, serializer, recipeFactory, cookingTime, Items.PORKCHOP, Items.COOKED_PORKCHOP, 0.35f);
        this.simpleCookingRecipe(cooker, serializer, recipeFactory, cookingTime, Items.POTATO, Items.BAKED_POTATO, 0.35f);
        this.simpleCookingRecipe(cooker, serializer, recipeFactory, cookingTime, Items.RABBIT, Items.COOKED_RABBIT, 0.35f);
    }

    private <T extends AbstractCookingRecipe> void simpleCookingRecipe(String cooker, RecipeSerializer<T> serializer, AbstractCookingRecipe.Factory<T> recipeFactory, int cookingTime, ItemLike input, ItemLike output, float experience) {
        SimpleCookingRecipeBuilder.generic(Ingredient.of(input), RecipeCategory.FOOD, output, experience, cookingTime, serializer, recipeFactory).unlockedBy(RecipeProvider.getHasName(input), (Criterion)this.has(input)).save(this.output, RecipeProvider.getItemName(output) + "_from_" + cooker);
    }

    protected void waxRecipes(FeatureFlagSet enabledFeatures) {
        HoneycombItem.WAXABLES.get().forEach((unwaxed, waxed) -> {
            if (!waxed.requiredFeatures().isSubsetOf(enabledFeatures)) {
                return;
            }
            this.shapeless(RecipeCategory.BUILDING_BLOCKS, (ItemLike)waxed).requires((ItemLike)unwaxed).requires(Items.HONEYCOMB).group(RecipeProvider.getItemName(waxed)).unlockedBy(RecipeProvider.getHasName(unwaxed), (Criterion)this.has((ItemLike)unwaxed)).save(this.output, RecipeProvider.getConversionRecipeName(waxed, Items.HONEYCOMB));
        });
    }

    protected void grate(Block output, Block input) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, output, 4).define(Character.valueOf('M'), input).pattern(" M ").pattern("M M").pattern(" M ").unlockedBy(RecipeProvider.getHasName(input), (Criterion)this.has(input)).save(this.output);
    }

    protected void copperBulb(Block output, Block input) {
        this.shaped(RecipeCategory.REDSTONE, output, 4).define(Character.valueOf('C'), input).define(Character.valueOf('R'), Items.REDSTONE).define(Character.valueOf('B'), Items.BLAZE_ROD).pattern(" C ").pattern("CBC").pattern(" R ").unlockedBy(RecipeProvider.getHasName(input), (Criterion)this.has(input)).save(this.output);
    }

    protected void suspiciousStew(Item input, SuspiciousEffectHolder stewIngredient) {
        ItemStack itemStack = new ItemStack(Items.SUSPICIOUS_STEW.builtInRegistryHolder(), 1, DataComponentPatch.builder().set(DataComponents.SUSPICIOUS_STEW_EFFECTS, stewIngredient.getSuspiciousEffects()).build());
        this.shapeless(RecipeCategory.FOOD, itemStack).requires(Items.BOWL).requires(Items.BROWN_MUSHROOM).requires(Items.RED_MUSHROOM).requires(input).group("suspicious_stew").unlockedBy(RecipeProvider.getHasName(input), (Criterion)this.has(input)).save(this.output, RecipeProvider.getItemName(itemStack.getItem()) + "_from_" + RecipeProvider.getItemName(input));
    }

    protected void generateRecipes(BlockFamily family, FeatureFlagSet enabledFeatures) {
        family.getVariants().forEach((variant, block) -> {
            if (!block.requiredFeatures().isSubsetOf(enabledFeatures)) {
                return;
            }
            FamilyRecipeProvider familyRecipeProvider = SHAPE_BUILDERS.get(variant);
            Block itemLike = this.getBaseBlock(family, (BlockFamily.Variant)((Object)variant));
            if (familyRecipeProvider != null) {
                RecipeBuilder recipeBuilder = familyRecipeProvider.create(this, (ItemLike)block, itemLike);
                family.getRecipeGroupPrefix().ifPresent(group -> recipeBuilder.group(group + (String)(variant == BlockFamily.Variant.CUT ? "" : "_" + variant.getRecipeGroup())));
                recipeBuilder.unlockedBy(family.getRecipeUnlockedBy().orElseGet(() -> RecipeProvider.getHasName(itemLike)), this.has(itemLike));
                recipeBuilder.save(this.output);
            }
            if (variant == BlockFamily.Variant.CRACKED) {
                this.smeltingResultFromBase((ItemLike)block, itemLike);
            }
        });
    }

    private Block getBaseBlock(BlockFamily family, BlockFamily.Variant variant) {
        if (variant == BlockFamily.Variant.CHISELED) {
            if (!family.getVariants().containsKey((Object)BlockFamily.Variant.SLAB)) {
                throw new IllegalStateException("Slab is not defined for the family.");
            }
            return family.get(BlockFamily.Variant.SLAB);
        }
        return family.getBaseBlock();
    }

    private static Criterion<EnterBlockTrigger.TriggerInstance> insideOf(Block block) {
        return CriteriaTriggers.ENTER_BLOCK.createCriterion(new EnterBlockTrigger.TriggerInstance(Optional.empty(), Optional.of(block.builtInRegistryHolder()), Optional.empty()));
    }

    private Criterion<InventoryChangeTrigger.TriggerInstance> has(MinMaxBounds.Ints count, ItemLike item) {
        return RecipeProvider.inventoryTrigger(ItemPredicate.Builder.item().of(this.items, item).withCount(count));
    }

    protected Criterion<InventoryChangeTrigger.TriggerInstance> has(ItemLike item) {
        return RecipeProvider.inventoryTrigger(ItemPredicate.Builder.item().of(this.items, item));
    }

    protected Criterion<InventoryChangeTrigger.TriggerInstance> has(TagKey<Item> tag) {
        return RecipeProvider.inventoryTrigger(ItemPredicate.Builder.item().of(this.items, tag));
    }

    private static Criterion<InventoryChangeTrigger.TriggerInstance> inventoryTrigger(ItemPredicate.Builder ... predicates) {
        return RecipeProvider.inventoryTrigger((ItemPredicate[])Arrays.stream(predicates).map(ItemPredicate.Builder::build).toArray(ItemPredicate[]::new));
    }

    private static Criterion<InventoryChangeTrigger.TriggerInstance> inventoryTrigger(ItemPredicate ... predicates) {
        return CriteriaTriggers.INVENTORY_CHANGED.createCriterion(new InventoryChangeTrigger.TriggerInstance(Optional.empty(), InventoryChangeTrigger.TriggerInstance.Slots.ANY, List.of(predicates)));
    }

    protected static String getHasName(ItemLike item) {
        return "has_" + RecipeProvider.getItemName(item);
    }

    protected static String getItemName(ItemLike item) {
        return BuiltInRegistries.ITEM.getKey(item.asItem()).getPath();
    }

    protected static String getSimpleRecipeName(ItemLike item) {
        return RecipeProvider.getItemName(item);
    }

    protected static String getConversionRecipeName(ItemLike to, ItemLike from) {
        return RecipeProvider.getItemName(to) + "_from_" + RecipeProvider.getItemName(from);
    }

    protected static String getSmeltingRecipeName(ItemLike item) {
        return RecipeProvider.getItemName(item) + "_from_smelting";
    }

    protected static String getBlastingRecipeName(ItemLike item) {
        return RecipeProvider.getItemName(item) + "_from_blasting";
    }

    protected Ingredient tag(TagKey<Item> tag) {
        return Ingredient.of(this.items.getOrThrow(tag));
    }

    protected ShapedRecipeBuilder shaped(RecipeCategory category, ItemLike output) {
        return ShapedRecipeBuilder.shaped(this.items, category, output);
    }

    protected ShapedRecipeBuilder shaped(RecipeCategory category, ItemLike output, int count) {
        return ShapedRecipeBuilder.shaped(this.items, category, output, count);
    }

    protected ShapelessRecipeBuilder shapeless(RecipeCategory category, ItemStack output) {
        return ShapelessRecipeBuilder.shapeless(this.items, category, output);
    }

    protected ShapelessRecipeBuilder shapeless(RecipeCategory category, ItemLike output) {
        return ShapelessRecipeBuilder.shapeless(this.items, category, output);
    }

    protected ShapelessRecipeBuilder shapeless(RecipeCategory category, ItemLike output, int count) {
        return ShapelessRecipeBuilder.shapeless(this.items, category, output, count);
    }

    @FunctionalInterface
    static interface FamilyRecipeProvider {
        public RecipeBuilder create(RecipeProvider var1, ItemLike var2, ItemLike var3);
    }

    protected static abstract class Runner
    implements DataProvider {
        private final PackOutput packOutput;
        private final CompletableFuture<HolderLookup.Provider> registries;

        protected Runner(PackOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
            this.packOutput = output;
            this.registries = registriesFuture;
        }

        @Override
        @Override
        public final CompletableFuture<?> run(final CachedOutput writer) {
            return this.registries.thenCompose(registries -> {
                PackOutput.PathProvider pathProvider = this.packOutput.createRegistryElementsPathProvider(Registries.RECIPE);
                PackOutput.PathProvider pathProvider2 = this.packOutput.createRegistryElementsPathProvider(Registries.ADVANCEMENT);
                final HashSet set = Sets.newHashSet();
                final ArrayList list = new ArrayList();
                RecipeOutput recipeOutput = new RecipeOutput(){
                    final /* synthetic */ HolderLookup.Provider val$registries;
                    final /* synthetic */ PackOutput.PathProvider val$recipePathProvider;
                    final /* synthetic */ PackOutput.PathProvider val$advancementPathProvider;
                    {
                        this.val$registries = provider;
                        this.val$recipePathProvider = pathProvider;
                        this.val$advancementPathProvider = pathProvider2;
                    }

                    @Override
                    @Override
                    public void accept(ResourceKey<Recipe<?>> key, Recipe<?> recipe, @Nullable AdvancementHolder advancement) {
                        if (!set.add(key)) {
                            throw new IllegalStateException("Duplicate recipe " + String.valueOf(key.location()));
                        }
                        this.saveRecipe(key, recipe);
                        if (advancement != null) {
                            this.saveAdvancement(advancement);
                        }
                    }

                    @Override
                    @Override
                    public Advancement.Builder advancement() {
                        return Advancement.Builder.recipeAdvancement().parent(RecipeBuilder.ROOT_RECIPE_ADVANCEMENT);
                    }

                    @Override
                    @Override
                    public void includeRootAdvancement() {
                        AdvancementHolder advancementHolder = Advancement.Builder.recipeAdvancement().addCriterion("impossible", CriteriaTriggers.IMPOSSIBLE.createCriterion(new ImpossibleTrigger.TriggerInstance())).build(RecipeBuilder.ROOT_RECIPE_ADVANCEMENT);
                        this.saveAdvancement(advancementHolder);
                    }

                    private void saveRecipe(ResourceKey<Recipe<?>> key, Recipe<?> recipe) {
                        list.add(DataProvider.saveStable(writer, this.val$registries, Recipe.CODEC, recipe, this.val$recipePathProvider.json(key.location())));
                    }

                    private void saveAdvancement(AdvancementHolder advancementEntry) {
                        list.add(DataProvider.saveStable(writer, this.val$registries, Advancement.CODEC, advancementEntry.value(), this.val$advancementPathProvider.json(advancementEntry.id())));
                    }
                };
                this.createRecipeProvider((HolderLookup.Provider)registries, recipeOutput).buildRecipes();
                return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
            });
        }

        protected abstract RecipeProvider createRecipeProvider(HolderLookup.Provider var1, RecipeOutput var2);
    }
}

