/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.recipes;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.HolderGetter;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;

public class ShapelessRecipeBuilder
implements RecipeBuilder {
    private final HolderGetter<Item> items;
    private final RecipeCategory category;
    private final ItemStack result;
    private final List<Ingredient> ingredients = new ArrayList<Ingredient>();
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();
    @Nullable
    private String group;

    private ShapelessRecipeBuilder(HolderGetter<Item> registryLookup, RecipeCategory category, ItemStack output) {
        this.items = registryLookup;
        this.category = category;
        this.result = output;
    }

    public static ShapelessRecipeBuilder shapeless(HolderGetter<Item> registryLookup, RecipeCategory category, ItemStack output) {
        return new ShapelessRecipeBuilder(registryLookup, category, output);
    }

    public static ShapelessRecipeBuilder shapeless(HolderGetter<Item> registryLookup, RecipeCategory category, ItemLike output) {
        return ShapelessRecipeBuilder.shapeless(registryLookup, category, output, 1);
    }

    public static ShapelessRecipeBuilder shapeless(HolderGetter<Item> registryLookup, RecipeCategory category, ItemLike output, int count) {
        return new ShapelessRecipeBuilder(registryLookup, category, output.asItem().getDefaultInstance().copyWithCount(count));
    }

    public ShapelessRecipeBuilder requires(TagKey<Item> tag) {
        return this.requires(Ingredient.of(this.items.getOrThrow(tag)));
    }

    public ShapelessRecipeBuilder requires(ItemLike item) {
        return this.requires(item, 1);
    }

    public ShapelessRecipeBuilder requires(ItemLike item, int amount) {
        for (int i = 0; i < amount; ++i) {
            this.requires(Ingredient.of(item));
        }
        return this;
    }

    public ShapelessRecipeBuilder requires(Ingredient ingredient) {
        return this.requires(ingredient, 1);
    }

    public ShapelessRecipeBuilder requires(Ingredient ingredient, int amount) {
        for (int i = 0; i < amount; ++i) {
            this.ingredients.add(ingredient);
        }
        return this;
    }

    @Override
    @Override
    public ShapelessRecipeBuilder unlockedBy(String string, Criterion<?> criterion) {
        this.criteria.put(string, criterion);
        return this;
    }

    @Override
    @Override
    public ShapelessRecipeBuilder group(@Nullable String string) {
        this.group = string;
        return this;
    }

    @Override
    @Override
    public Item getResult() {
        return this.result.getItem();
    }

    @Override
    @Override
    public void save(RecipeOutput exporter, ResourceKey<Recipe<?>> recipeKey) {
        this.ensureValid(recipeKey);
        Advancement.Builder builder = exporter.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked(recipeKey)).rewards(AdvancementRewards.Builder.recipe(recipeKey)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach(builder::addCriterion);
        ShapelessRecipe shapelessRecipe = new ShapelessRecipe(Objects.requireNonNullElse(this.group, ""), RecipeBuilder.determineBookCategory(this.category), this.result, this.ingredients);
        exporter.accept(recipeKey, shapelessRecipe, builder.build(recipeKey.location().withPrefix("recipes/" + this.category.getFolderName() + "/")));
    }

    private void ensureValid(ResourceKey<Recipe<?>> recipeKey) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(recipeKey.location()));
        }
    }

    @Override
    public /* synthetic */ RecipeBuilder group(@Nullable String group) {
        return this.group(group);
    }

    public /* synthetic */ RecipeBuilder unlockedBy(String name, Criterion criterion) {
        return this.unlockedBy(name, criterion);
    }
}

