/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen;

import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.biome.OverworldBiomes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class WinterDropBiomes {
    public static final ResourceKey<Biome> PALE_GARDEN = WinterDropBiomes.createKey("pale_garden");

    public static ResourceKey<Biome> createKey(String id) {
        return ResourceKey.create(Registries.BIOME, ResourceLocation.withDefaultNamespace(id));
    }

    public static void register(BootstrapContext<Biome> biomeRegisterable, String id, Biome biome) {
        biomeRegisterable.register(WinterDropBiomes.createKey(id), biome);
    }

    public static void bootstrap(BootstrapContext<Biome> biomeRegisterable) {
        HolderGetter<PlacedFeature> holderGetter = biomeRegisterable.lookup(Registries.PLACED_FEATURE);
        HolderGetter<ConfiguredWorldCarver<?>> holderGetter2 = biomeRegisterable.lookup(Registries.CONFIGURED_CARVER);
        biomeRegisterable.register(PALE_GARDEN, OverworldBiomes.darkForest(holderGetter, holderGetter2, true));
    }
}

