/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.mojang.logging.LogUtils;
import net.minecraft.Util;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.gametest.framework.TestReporter;
import org.slf4j.Logger;

public class LogTestReporter
implements TestReporter {
    private static final Logger LOGGER = LogUtils.getLogger();

    @Override
    @Override
    public void onTestFailed(GameTestInfo test) {
        String string = test.getTestOrigin().toShortString();
        if (test.isRequired()) {
            LOGGER.error("{} failed at {}! {}", new Object[]{test.getTestName(), string, Util.describeError(test.getError())});
        } else {
            LOGGER.warn("(optional) {} failed at {}. {}", new Object[]{test.getTestName(), string, Util.describeError(test.getError())});
        }
    }

    @Override
    @Override
    public void onTestSuccess(GameTestInfo test) {
    }
}

