/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.world.Difficulty;

public class ClientboundChangeDifficultyPacket
implements Packet<ClientGamePacketListener> {
    public static final StreamCodec<FriendlyByteBuf, ClientboundChangeDifficultyPacket> STREAM_CODEC = Packet.codec(ClientboundChangeDifficultyPacket::write, ClientboundChangeDifficultyPacket::new);
    private final Difficulty difficulty;
    private final boolean locked;

    public ClientboundChangeDifficultyPacket(Difficulty difficulty, boolean difficultyLocked) {
        this.difficulty = difficulty;
        this.locked = difficultyLocked;
    }

    private ClientboundChangeDifficultyPacket(FriendlyByteBuf buf) {
        this.difficulty = Difficulty.byId(buf.readUnsignedByte());
        this.locked = buf.readBoolean();
    }

    private void write(FriendlyByteBuf buf) {
        buf.writeByte(this.difficulty.getId());
        buf.writeBoolean(this.locked);
    }

    @Override
    @Override
    public PacketType<ClientboundChangeDifficultyPacket> type() {
        return GamePacketTypes.CLIENTBOUND_CHANGE_DIFFICULTY;
    }

    @Override
    @Override
    public void handle(ClientGamePacketListener listener) {
        listener.handleChangeDifficulty(this);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public Difficulty getDifficulty() {
        return this.difficulty;
    }
}

