/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.recipebook;

import java.util.Iterator;
import net.minecraft.util.Mth;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;

public interface PlaceRecipeHelper {
    public static <T> void placeRecipe(int width, int height, Recipe<?> recipe, Iterable<T> slots, Output<T> filter) {
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
            PlaceRecipeHelper.placeRecipe(width, height, shapedRecipe.getWidth(), shapedRecipe.getHeight(), slots, filter);
        } else {
            PlaceRecipeHelper.placeRecipe(width, height, width, height, slots, filter);
        }
    }

    public static <T> void placeRecipe(int width, int height, int recipeWidth, int recipeHeight, Iterable<T> slots, Output<T> filter) {
        Iterator<T> iterator = slots.iterator();
        int i = 0;
        block0: for (int j = 0; j < height; ++j) {
            boolean bl = (float)recipeHeight < (float)height / 2.0f;
            int k = Mth.floor((float)height / 2.0f - (float)recipeHeight / 2.0f);
            if (bl && k > j) {
                i += width;
                ++j;
            }
            for (int l = 0; l < width; ++l) {
                boolean bl2;
                if (!iterator.hasNext()) {
                    return;
                }
                bl = (float)recipeWidth < (float)width / 2.0f;
                k = Mth.floor((float)width / 2.0f - (float)recipeWidth / 2.0f);
                int m = recipeWidth;
                boolean bl3 = bl2 = l < recipeWidth;
                if (bl) {
                    m = k + recipeWidth;
                    boolean bl4 = bl2 = k <= l && l < k + recipeWidth;
                }
                if (bl2) {
                    filter.addItemToSlot(iterator.next(), i, l, j);
                } else if (m == l) {
                    i += width - l;
                    continue block0;
                }
                ++i;
            }
        }
    }

    @FunctionalInterface
    public static interface Output<T> {
        public void addItemToSlot(T var1, int var2, int var3, int var4);
    }
}

