/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementTree;
import net.minecraft.advancements.TreeNodePosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class ServerAdvancementManager
extends SimpleJsonResourceReloadListener<Advancement> {
    private static final Logger LOGGER = LogUtils.getLogger();
    public Map<ResourceLocation, AdvancementHolder> advancements = new HashMap<ResourceLocation, AdvancementHolder>();
    private AdvancementTree tree = new AdvancementTree();
    private final HolderLookup.Provider registries;

    public ServerAdvancementManager(HolderLookup.Provider registries) {
        super(registries, Advancement.CODEC, Registries.elementsDirPath(Registries.ADVANCEMENT));
        this.registries = registries;
    }

    @Override
    protected void apply(Map<ResourceLocation, Advancement> prepared, ResourceManager manager, ProfilerFiller profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        prepared.forEach((minecraftkey, advancement) -> {
            if (SpigotConfig.disabledAdvancements != null && (SpigotConfig.disabledAdvancements.contains("*") || SpigotConfig.disabledAdvancements.contains(minecraftkey.toString()) || SpigotConfig.disabledAdvancements.contains(minecraftkey.getNamespace()))) {
                return;
            }
            this.validate((ResourceLocation)minecraftkey, (Advancement)advancement);
            builder.put(minecraftkey, (Object)new AdvancementHolder((ResourceLocation)minecraftkey, (Advancement)advancement));
        });
        this.advancements = new HashMap<ResourceLocation, AdvancementHolder>((Map<ResourceLocation, AdvancementHolder>)builder.buildOrThrow());
        AdvancementTree advancementtree = new AdvancementTree();
        advancementtree.addAll(this.advancements.values());
        LOGGER.info("Loaded {} advancements", (Object)advancementtree.nodes().size());
        for (AdvancementNode advancementnode : advancementtree.roots()) {
            if (!advancementnode.holder().value().display().isPresent()) continue;
            TreeNodePosition.run(advancementnode);
        }
        this.tree = advancementtree;
    }

    private void validate(ResourceLocation id, Advancement advancement) {
        ProblemReporter.Collector problemreporter_a = new ProblemReporter.Collector();
        advancement.validate(problemreporter_a, this.registries);
        problemreporter_a.getReport().ifPresent(s -> LOGGER.warn("Found validation problems in advancement {}: \n{}", (Object)id, s));
    }

    @Nullable
    public AdvancementHolder get(ResourceLocation id) {
        return this.advancements.get(id);
    }

    public AdvancementTree tree() {
        return this.tree;
    }

    public Collection<AdvancementHolder> getAllAdvancements() {
        return this.advancements.values();
    }
}

