/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.GameRules;

public class GameRuleCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandRegistryAccess) {
        final LiteralArgumentBuilder literalargumentbuilder = (LiteralArgumentBuilder)Commands.literal("gamerule").requires(commandlistenerwrapper -> commandlistenerwrapper.hasPermission(2));
        new GameRules(commandRegistryAccess.enabledFeatures()).visitGameRuleTypes(new GameRules.GameRuleTypeVisitor(){

            @Override
            public <T extends GameRules.Value<T>> void visit(GameRules.Key<T> key, GameRules.Type<T> type) {
                LiteralArgumentBuilder<CommandSourceStack> literalargumentbuilder1 = Commands.literal(key.getId());
                literalargumentbuilder.then(((LiteralArgumentBuilder)literalargumentbuilder1.executes(commandcontext -> GameRuleCommand.queryRule((CommandSourceStack)commandcontext.getSource(), key))).then(type.createArgument("value").executes(commandcontext -> GameRuleCommand.setRule((CommandContext<CommandSourceStack>)commandcontext, key))));
            }
        });
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)literalargumentbuilder);
    }

    static <T extends GameRules.Value<T>> int setRule(CommandContext<CommandSourceStack> context, GameRules.Key<T> key) {
        CommandSourceStack commandlistenerwrapper = (CommandSourceStack)context.getSource();
        Object t0 = commandlistenerwrapper.getLevel().getGameRules().getRule(key);
        ((GameRules.Value)t0).setFromArgument(context, "value", key);
        commandlistenerwrapper.sendSuccess(() -> Component.translatable("commands.gamerule.set", key.getId(), t0.toString()), true);
        return ((GameRules.Value)t0).getCommandResult();
    }

    static <T extends GameRules.Value<T>> int queryRule(CommandSourceStack source, GameRules.Key<T> key) {
        Object t0 = source.getLevel().getGameRules().getRule(key);
        source.sendSuccess(() -> Component.translatable("commands.gamerule.query", key.getId(), t0.toString()), false);
        return ((GameRules.Value)t0).getCommandResult();
    }
}

