/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.Optional;
import net.minecraft.ResourceLocationException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.TemplateMirrorArgument;
import net.minecraft.commands.arguments.TemplateRotationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockRotProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.bukkit.event.world.AsyncStructureGenerateEvent;

public class PlaceCommand {
    private static final SimpleCommandExceptionType ERROR_FEATURE_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.place.feature.failed"));
    private static final SimpleCommandExceptionType ERROR_JIGSAW_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.place.jigsaw.failed"));
    private static final SimpleCommandExceptionType ERROR_STRUCTURE_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.place.structure.failed"));
    private static final DynamicCommandExceptionType ERROR_TEMPLATE_INVALID = new DynamicCommandExceptionType(object -> Component.translatableEscape("commands.place.template.invalid", object));
    private static final SimpleCommandExceptionType ERROR_TEMPLATE_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.place.template.failed"));
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_TEMPLATES = (commandcontext, suggestionsbuilder) -> {
        StructureTemplateManager structuretemplatemanager = ((CommandSourceStack)commandcontext.getSource()).getLevel().getStructureManager();
        return SharedSuggestionProvider.suggestResource(structuretemplatemanager.listTemplates(), suggestionsbuilder);
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("place").requires(commandlistenerwrapper -> commandlistenerwrapper.hasPermission(2))).then(Commands.literal("feature").then(((RequiredArgumentBuilder)Commands.argument("feature", ResourceKeyArgument.key(Registries.CONFIGURED_FEATURE)).executes(commandcontext -> PlaceCommand.placeFeature((CommandSourceStack)commandcontext.getSource(), ResourceKeyArgument.getConfiguredFeature((CommandContext<CommandSourceStack>)commandcontext, "feature"), BlockPos.containing(((CommandSourceStack)commandcontext.getSource()).getPosition())))).then(Commands.argument("pos", BlockPosArgument.blockPos()).executes(commandcontext -> PlaceCommand.placeFeature((CommandSourceStack)commandcontext.getSource(), ResourceKeyArgument.getConfiguredFeature((CommandContext<CommandSourceStack>)commandcontext, "feature"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)commandcontext, "pos"))))))).then(Commands.literal("jigsaw").then(Commands.argument("pool", ResourceKeyArgument.key(Registries.TEMPLATE_POOL)).then(Commands.argument("target", ResourceLocationArgument.id()).then(((RequiredArgumentBuilder)Commands.argument("max_depth", IntegerArgumentType.integer((int)1, (int)20)).executes(commandcontext -> PlaceCommand.placeJigsaw((CommandSourceStack)commandcontext.getSource(), ResourceKeyArgument.getStructureTemplatePool((CommandContext<CommandSourceStack>)commandcontext, "pool"), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)commandcontext, "target"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"max_depth"), BlockPos.containing(((CommandSourceStack)commandcontext.getSource()).getPosition())))).then(Commands.argument("position", BlockPosArgument.blockPos()).executes(commandcontext -> PlaceCommand.placeJigsaw((CommandSourceStack)commandcontext.getSource(), ResourceKeyArgument.getStructureTemplatePool((CommandContext<CommandSourceStack>)commandcontext, "pool"), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)commandcontext, "target"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"max_depth"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)commandcontext, "position"))))))))).then(Commands.literal("structure").then(((RequiredArgumentBuilder)Commands.argument("structure", ResourceKeyArgument.key(Registries.STRUCTURE)).executes(commandcontext -> PlaceCommand.placeStructure((CommandSourceStack)commandcontext.getSource(), ResourceKeyArgument.getStructure((CommandContext<CommandSourceStack>)commandcontext, "structure"), BlockPos.containing(((CommandSourceStack)commandcontext.getSource()).getPosition())))).then(Commands.argument("pos", BlockPosArgument.blockPos()).executes(commandcontext -> PlaceCommand.placeStructure((CommandSourceStack)commandcontext.getSource(), ResourceKeyArgument.getStructure((CommandContext<CommandSourceStack>)commandcontext, "structure"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)commandcontext, "pos"))))))).then(Commands.literal("template").then(((RequiredArgumentBuilder)Commands.argument("template", ResourceLocationArgument.id()).suggests(SUGGEST_TEMPLATES).executes(commandcontext -> PlaceCommand.placeTemplate((CommandSourceStack)commandcontext.getSource(), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)commandcontext, "template"), BlockPos.containing(((CommandSourceStack)commandcontext.getSource()).getPosition()), Rotation.NONE, Mirror.NONE, 1.0f, 0))).then(((RequiredArgumentBuilder)Commands.argument("pos", BlockPosArgument.blockPos()).executes(commandcontext -> PlaceCommand.placeTemplate((CommandSourceStack)commandcontext.getSource(), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)commandcontext, "template"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)commandcontext, "pos"), Rotation.NONE, Mirror.NONE, 1.0f, 0))).then(((RequiredArgumentBuilder)Commands.argument("rotation", TemplateRotationArgument.templateRotation()).executes(commandcontext -> PlaceCommand.placeTemplate((CommandSourceStack)commandcontext.getSource(), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)commandcontext, "template"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)commandcontext, "pos"), TemplateRotationArgument.getRotation((CommandContext<CommandSourceStack>)commandcontext, "rotation"), Mirror.NONE, 1.0f, 0))).then(((RequiredArgumentBuilder)Commands.argument("mirror", TemplateMirrorArgument.templateMirror()).executes(commandcontext -> PlaceCommand.placeTemplate((CommandSourceStack)commandcontext.getSource(), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)commandcontext, "template"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)commandcontext, "pos"), TemplateRotationArgument.getRotation((CommandContext<CommandSourceStack>)commandcontext, "rotation"), TemplateMirrorArgument.getMirror((CommandContext<CommandSourceStack>)commandcontext, "mirror"), 1.0f, 0))).then(((RequiredArgumentBuilder)Commands.argument("integrity", FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(commandcontext -> PlaceCommand.placeTemplate((CommandSourceStack)commandcontext.getSource(), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)commandcontext, "template"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)commandcontext, "pos"), TemplateRotationArgument.getRotation((CommandContext<CommandSourceStack>)commandcontext, "rotation"), TemplateMirrorArgument.getMirror((CommandContext<CommandSourceStack>)commandcontext, "mirror"), FloatArgumentType.getFloat((CommandContext)commandcontext, (String)"integrity"), 0))).then(Commands.argument("seed", IntegerArgumentType.integer()).executes(commandcontext -> PlaceCommand.placeTemplate((CommandSourceStack)commandcontext.getSource(), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)commandcontext, "template"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)commandcontext, "pos"), TemplateRotationArgument.getRotation((CommandContext<CommandSourceStack>)commandcontext, "rotation"), TemplateMirrorArgument.getMirror((CommandContext<CommandSourceStack>)commandcontext, "mirror"), FloatArgumentType.getFloat((CommandContext)commandcontext, (String)"integrity"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"seed"))))))))))));
    }

    public static int placeFeature(CommandSourceStack source, Holder.Reference<ConfiguredFeature<?, ?>> feature, BlockPos pos) throws CommandSyntaxException {
        ServerLevel worldserver = source.getLevel();
        ConfiguredFeature<?, ?> worldgenfeatureconfigured = feature.value();
        ChunkPos chunkcoordintpair = new ChunkPos(pos);
        PlaceCommand.checkLoaded(worldserver, new ChunkPos(chunkcoordintpair.x - 1, chunkcoordintpair.z - 1), new ChunkPos(chunkcoordintpair.x + 1, chunkcoordintpair.z + 1));
        if (!worldgenfeatureconfigured.place(worldserver, worldserver.getChunkSource().getGenerator(), worldserver.getRandom(), pos)) {
            throw ERROR_FEATURE_FAILED.create();
        }
        String s = feature.key().location().toString();
        source.sendSuccess(() -> Component.translatable("commands.place.feature.success", s, pos.getX(), pos.getY(), pos.getZ()), true);
        return 1;
    }

    public static int placeJigsaw(CommandSourceStack source, Holder<StructureTemplatePool> structurePool, ResourceLocation id, int maxDepth, BlockPos pos) throws CommandSyntaxException {
        ServerLevel worldserver = source.getLevel();
        ChunkPos chunkcoordintpair = new ChunkPos(pos);
        PlaceCommand.checkLoaded(worldserver, chunkcoordintpair, chunkcoordintpair);
        if (!JigsawPlacement.generateJigsaw(worldserver, structurePool, id, maxDepth, pos, false)) {
            throw ERROR_JIGSAW_FAILED.create();
        }
        source.sendSuccess(() -> Component.translatable("commands.place.jigsaw.success", pos.getX(), pos.getY(), pos.getZ()), true);
        return 1;
    }

    public static int placeStructure(CommandSourceStack source, Holder.Reference<Structure> structure, BlockPos pos) throws CommandSyntaxException {
        ServerLevel worldserver = source.getLevel();
        Structure structure1 = structure.value();
        ChunkGenerator chunkgenerator = worldserver.getChunkSource().getGenerator();
        StructureStart structurestart = structure1.generate(source.registryAccess(), chunkgenerator, chunkgenerator.getBiomeSource(), worldserver.getChunkSource().randomState(), worldserver.getStructureManager(), worldserver.getSeed(), new ChunkPos(pos), 0, worldserver, holder -> true);
        if (!structurestart.isValid()) {
            throw ERROR_STRUCTURE_FAILED.create();
        }
        structurestart.generationEventCause = AsyncStructureGenerateEvent.Cause.COMMAND;
        BoundingBox structureboundingbox = structurestart.getBoundingBox();
        ChunkPos chunkcoordintpair = new ChunkPos(SectionPos.blockToSectionCoord(structureboundingbox.minX()), SectionPos.blockToSectionCoord(structureboundingbox.minZ()));
        ChunkPos chunkcoordintpair1 = new ChunkPos(SectionPos.blockToSectionCoord(structureboundingbox.maxX()), SectionPos.blockToSectionCoord(structureboundingbox.maxZ()));
        PlaceCommand.checkLoaded(worldserver, chunkcoordintpair, chunkcoordintpair1);
        ChunkPos.rangeClosed(chunkcoordintpair, chunkcoordintpair1).forEach(chunkcoordintpair2 -> structurestart.placeInChunk(worldserver, worldserver.structureManager(), chunkgenerator, worldserver.getRandom(), new BoundingBox(chunkcoordintpair2.getMinBlockX(), worldserver.getMinY(), chunkcoordintpair2.getMinBlockZ(), chunkcoordintpair2.getMaxBlockX(), worldserver.getMaxY() + 1, chunkcoordintpair2.getMaxBlockZ()), (ChunkPos)chunkcoordintpair2));
        String s = structure.key().location().toString();
        source.sendSuccess(() -> Component.translatable("commands.place.structure.success", s, pos.getX(), pos.getY(), pos.getZ()), true);
        return 1;
    }

    public static int placeTemplate(CommandSourceStack source, ResourceLocation id, BlockPos pos, Rotation rotation, Mirror mirror, float integrity, int seed) throws CommandSyntaxException {
        boolean flag;
        Optional<StructureTemplate> optional;
        ServerLevel worldserver = source.getLevel();
        StructureTemplateManager structuretemplatemanager = worldserver.getStructureManager();
        try {
            optional = structuretemplatemanager.get(id);
        }
        catch (ResourceLocationException resourcekeyinvalidexception) {
            throw ERROR_TEMPLATE_INVALID.create((Object)id);
        }
        if (optional.isEmpty()) {
            throw ERROR_TEMPLATE_INVALID.create((Object)id);
        }
        StructureTemplate definedstructure = optional.get();
        PlaceCommand.checkLoaded(worldserver, new ChunkPos(pos), new ChunkPos(pos.offset(definedstructure.getSize())));
        StructurePlaceSettings definedstructureinfo = new StructurePlaceSettings().setMirror(mirror).setRotation(rotation);
        if (integrity < 1.0f) {
            definedstructureinfo.clearProcessors().addProcessor(new BlockRotProcessor(integrity)).setRandom(StructureBlockEntity.createRandom(seed));
        }
        if (!(flag = definedstructure.placeInWorld(worldserver, pos, pos, definedstructureinfo, StructureBlockEntity.createRandom(seed), 2))) {
            throw ERROR_TEMPLATE_FAILED.create();
        }
        source.sendSuccess(() -> Component.translatable("commands.place.template.success", Component.translationArg(id), pos.getX(), pos.getY(), pos.getZ()), true);
        return 1;
    }

    private static void checkLoaded(ServerLevel world, ChunkPos pos1, ChunkPos pos2) throws CommandSyntaxException {
        if (ChunkPos.rangeClosed(pos1, pos2).filter(chunkcoordintpair2 -> !world.isLoaded(chunkcoordintpair2.getWorldPosition())).findAny().isPresent()) {
            throw BlockPosArgument.ERROR_NOT_LOADED.create();
        }
    }
}

