/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class SummonCommand {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.summon.failed"));
    private static final SimpleCommandExceptionType ERROR_DUPLICATE_UUID = new SimpleCommandExceptionType((Message)Component.translatable("commands.summon.failed.uuid"));
    private static final SimpleCommandExceptionType INVALID_POSITION = new SimpleCommandExceptionType((Message)Component.translatable("commands.summon.invalidPosition"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext registryAccess) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("summon").requires(commandlistenerwrapper -> commandlistenerwrapper.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument("entity", ResourceArgument.resource(registryAccess, Registries.ENTITY_TYPE)).suggests(SuggestionProviders.SUMMONABLE_ENTITIES).executes(commandcontext -> SummonCommand.spawnEntity((CommandSourceStack)commandcontext.getSource(), ResourceArgument.getSummonableEntityType((CommandContext<CommandSourceStack>)commandcontext, "entity"), ((CommandSourceStack)commandcontext.getSource()).getPosition(), new CompoundTag(), true))).then(((RequiredArgumentBuilder)Commands.argument("pos", Vec3Argument.vec3()).executes(commandcontext -> SummonCommand.spawnEntity((CommandSourceStack)commandcontext.getSource(), ResourceArgument.getSummonableEntityType((CommandContext<CommandSourceStack>)commandcontext, "entity"), Vec3Argument.getVec3((CommandContext<CommandSourceStack>)commandcontext, "pos"), new CompoundTag(), true))).then(Commands.argument("nbt", CompoundTagArgument.compoundTag()).executes(commandcontext -> SummonCommand.spawnEntity((CommandSourceStack)commandcontext.getSource(), ResourceArgument.getSummonableEntityType((CommandContext<CommandSourceStack>)commandcontext, "entity"), Vec3Argument.getVec3((CommandContext<CommandSourceStack>)commandcontext, "pos"), CompoundTagArgument.getCompoundTag(commandcontext, "nbt"), false)))))));
    }

    public static Entity createEntity(CommandSourceStack source, Holder.Reference<EntityType<?>> entityType, Vec3 pos, CompoundTag nbt, boolean initialize) throws CommandSyntaxException {
        BlockPos blockposition = BlockPos.containing(pos);
        if (!Level.isInSpawnableBounds(blockposition)) {
            throw INVALID_POSITION.create();
        }
        CompoundTag nbttagcompound1 = nbt.copy();
        nbttagcompound1.putString("id", entityType.key().location().toString());
        ServerLevel worldserver = source.getLevel();
        Entity entity = EntityType.loadEntityRecursive(nbttagcompound1, worldserver, EntitySpawnReason.COMMAND, entity1 -> {
            entity1.moveTo(pos.x, pos.y, pos.z, entity1.getYRot(), entity1.getXRot());
            entity1.spawnReason = CreatureSpawnEvent.SpawnReason.COMMAND;
            return entity1;
        });
        if (entity == null) {
            throw ERROR_FAILED.create();
        }
        if (initialize && entity instanceof Mob) {
            ((Mob)entity).finalizeSpawn(source.getLevel(), source.getLevel().getCurrentDifficultyAt(entity.blockPosition()), EntitySpawnReason.COMMAND, null);
        }
        if (!worldserver.tryAddFreshEntityWithPassengers(entity, CreatureSpawnEvent.SpawnReason.COMMAND)) {
            throw ERROR_DUPLICATE_UUID.create();
        }
        return entity;
    }

    private static int spawnEntity(CommandSourceStack source, Holder.Reference<EntityType<?>> entityType, Vec3 pos, CompoundTag nbt, boolean initialize) throws CommandSyntaxException {
        Entity entity = SummonCommand.createEntity(source, entityType, pos, nbt, initialize);
        source.sendSuccess(() -> Component.translatable("commands.summon.success", entity.getDisplayName()), true);
        return 1;
    }
}

