/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Iterators;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.configuration.GlobalConfiguration;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.TimeArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.event.world.TimeSkipEvent;

public class TimeCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("time").requires(commandlistenerwrapper -> commandlistenerwrapper.hasPermission(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("set").then(Commands.literal("day").executes(commandcontext -> TimeCommand.setTime((CommandSourceStack)commandcontext.getSource(), 1000)))).then(Commands.literal("noon").executes(commandcontext -> TimeCommand.setTime((CommandSourceStack)commandcontext.getSource(), 6000)))).then(Commands.literal("night").executes(commandcontext -> TimeCommand.setTime((CommandSourceStack)commandcontext.getSource(), 13000)))).then(Commands.literal("midnight").executes(commandcontext -> TimeCommand.setTime((CommandSourceStack)commandcontext.getSource(), 18000)))).then(Commands.argument("time", TimeArgument.time()).executes(commandcontext -> TimeCommand.setTime((CommandSourceStack)commandcontext.getSource(), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"time")))))).then(Commands.literal("add").then(Commands.argument("time", TimeArgument.time()).executes(commandcontext -> TimeCommand.addTime((CommandSourceStack)commandcontext.getSource(), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"time")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("query").then(Commands.literal("daytime").executes(commandcontext -> TimeCommand.queryTime((CommandSourceStack)commandcontext.getSource(), TimeCommand.getDayTime(((CommandSourceStack)commandcontext.getSource()).getLevel()))))).then(Commands.literal("gametime").executes(commandcontext -> TimeCommand.queryTime((CommandSourceStack)commandcontext.getSource(), (int)(((CommandSourceStack)commandcontext.getSource()).getLevel().getGameTime() % Integer.MAX_VALUE))))).then(Commands.literal("day").executes(commandcontext -> TimeCommand.queryTime((CommandSourceStack)commandcontext.getSource(), (int)(((CommandSourceStack)commandcontext.getSource()).getLevel().getDayTime() / 24000L % Integer.MAX_VALUE)))))));
    }

    private static int getDayTime(ServerLevel world) {
        return (int)(world.getDayTime() % 24000L);
    }

    private static int queryTime(CommandSourceStack source, int time) {
        source.sendSuccess(() -> Component.translatable("commands.time.query", time), false);
        return time;
    }

    public static int setTime(CommandSourceStack source, int time) {
        Object iterator;
        Object object = iterator = GlobalConfiguration.get().commands.timeCommandAffectsAllWorlds ? source.getServer().getAllLevels().iterator() : Iterators.singletonIterator((Object)source.getLevel());
        while (iterator.hasNext()) {
            ServerLevel worldserver = (ServerLevel)iterator.next();
            TimeSkipEvent event = new TimeSkipEvent((World)worldserver.getWorld(), TimeSkipEvent.SkipReason.COMMAND, (long)time - worldserver.getDayTime());
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            worldserver.setDayTime(worldserver.getDayTime() + event.getSkipAmount());
        }
        source.sendSuccess(() -> Component.translatable("commands.time.set", time), true);
        return TimeCommand.getDayTime(source.getLevel());
    }

    public static int addTime(CommandSourceStack source, int time) {
        Object iterator;
        Object object = iterator = GlobalConfiguration.get().commands.timeCommandAffectsAllWorlds ? source.getServer().getAllLevels().iterator() : Iterators.singletonIterator((Object)source.getLevel());
        while (iterator.hasNext()) {
            ServerLevel worldserver = (ServerLevel)iterator.next();
            TimeSkipEvent event = new TimeSkipEvent((World)worldserver.getWorld(), TimeSkipEvent.SkipReason.COMMAND, (long)time);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            worldserver.setDayTime(worldserver.getDayTime() + event.getSkipAmount());
        }
        int j = TimeCommand.getDayTime(source.getLevel());
        source.sendSuccess(() -> Component.translatable("commands.time.set", j), true);
        return j;
    }
}

