/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.mojang.logging.LogUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkTaskPriorityQueue;
import net.minecraft.util.Unit;
import net.minecraft.util.thread.PriorityConsecutiveExecutor;
import net.minecraft.util.thread.StrictQueue;
import net.minecraft.util.thread.TaskScheduler;
import net.minecraft.world.level.ChunkPos;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ChunkTaskDispatcher
implements ChunkHolder.LevelChangeListener,
AutoCloseable {
    public static final int DISPATCHER_PRIORITY_COUNT = 4;
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ChunkTaskPriorityQueue queue;
    private final TaskScheduler<Runnable> executor;
    private final PriorityConsecutiveExecutor dispatcher;
    protected boolean sleeping;

    public ChunkTaskDispatcher(TaskScheduler<Runnable> executor, Executor dispatchExecutor) {
        this.queue = new ChunkTaskPriorityQueue(executor.name() + "_queue");
        this.executor = executor;
        this.dispatcher = new PriorityConsecutiveExecutor(4, dispatchExecutor, "dispatcher");
        this.sleeping = true;
    }

    public boolean hasWork() {
        return this.dispatcher.hasWork() || this.queue.hasWork();
    }

    @Override
    @Override
    public void onLevelChange(ChunkPos pos, IntSupplier levelGetter, int targetLevel, IntConsumer levelSetter) {
        this.dispatcher.schedule(new StrictQueue.RunnableWithPriority(0, () -> {
            int j = levelGetter.getAsInt();
            this.queue.resortChunkTasks(j, pos, targetLevel);
            levelSetter.accept(targetLevel);
        }));
    }

    public void release(long pos, Runnable callback, boolean removeElement) {
        this.dispatcher.schedule(new StrictQueue.RunnableWithPriority(1, () -> {
            this.queue.release(pos, removeElement);
            this.onRelease(pos);
            if (this.sleeping) {
                this.sleeping = false;
                this.pollTask();
            }
            callback.run();
        }));
    }

    public void submit(Runnable runnable, long pos, IntSupplier levelGetter) {
        this.dispatcher.schedule(new StrictQueue.RunnableWithPriority(2, () -> {
            int i = levelGetter.getAsInt();
            this.queue.submit(runnable, pos, i);
            if (this.sleeping) {
                this.sleeping = false;
                this.pollTask();
            }
        }));
    }

    protected void pollTask() {
        this.dispatcher.schedule(new StrictQueue.RunnableWithPriority(3, () -> {
            ChunkTaskPriorityQueue.TasksForChunk tasksForChunk = this.popTasks();
            if (tasksForChunk == null) {
                this.sleeping = true;
            } else {
                this.scheduleForExecution(tasksForChunk);
            }
        }));
    }

    protected void scheduleForExecution(ChunkTaskPriorityQueue.TasksForChunk entry) {
        CompletableFuture.allOf((CompletableFuture[])entry.tasks().stream().map(runnable -> this.executor.scheduleWithResult(future -> {
            runnable.run();
            future.complete(Unit.INSTANCE);
        })).toArray(CompletableFuture[]::new)).thenAccept(v -> this.pollTask());
    }

    protected void onRelease(long chunkPos) {
    }

    @Nullable
    protected ChunkTaskPriorityQueue.TasksForChunk popTasks() {
        return this.queue.pop();
    }

    @Override
    @Override
    public void close() {
        this.executor.close();
    }
}

