/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.phys.AABB;

public interface ServerEntityGetter
extends EntityGetter {
    public ServerLevel getLevel();

    @Nullable
    default public Player getNearestPlayer(TargetingConditions targetPredicate, LivingEntity entity) {
        return this.getNearestEntity(this.players(), targetPredicate, entity, entity.getX(), entity.getY(), entity.getZ());
    }

    @Nullable
    default public Player getNearestPlayer(TargetingConditions targetPredicate, LivingEntity entity, double x, double y, double z) {
        return this.getNearestEntity(this.players(), targetPredicate, entity, x, y, z);
    }

    @Nullable
    default public Player getNearestPlayer(TargetingConditions targetPredicate, double x, double y, double z) {
        return this.getNearestEntity(this.players(), targetPredicate, null, x, y, z);
    }

    @Nullable
    default public <T extends LivingEntity> T getNearestEntity(Class<? extends T> clazz, TargetingConditions targetPredicate, @Nullable LivingEntity entity, double x, double y, double z, AABB box) {
        return (T)this.getNearestEntity(this.getEntitiesOfClass(clazz, box, potentialEntity -> true), targetPredicate, entity, x, y, z);
    }

    @Nullable
    default public <T extends LivingEntity> T getNearestEntity(List<? extends T> entities, TargetingConditions targetPredicate, @Nullable LivingEntity entity, double x, double y, double z) {
        double d = -1.0;
        LivingEntity livingEntity = null;
        for (LivingEntity livingEntity2 : entities) {
            if (!targetPredicate.test(this.getLevel(), entity, livingEntity2)) continue;
            double e = livingEntity2.distanceToSqr(x, y, z);
            if (d != -1.0 && !(e < d)) continue;
            d = e;
            livingEntity = livingEntity2;
        }
        return (T)livingEntity;
    }

    default public List<Player> getNearbyPlayers(TargetingConditions targetPredicate, LivingEntity entity, AABB box) {
        ArrayList<Player> list = new ArrayList<Player>();
        for (Player player : this.players()) {
            if (!box.contains(player.getX(), player.getY(), player.getZ()) || !targetPredicate.test(this.getLevel(), entity, player)) continue;
            list.add(player);
        }
        return list;
    }

    default public <T extends LivingEntity> List<T> getNearbyEntities(Class<T> clazz, TargetingConditions targetPredicate, LivingEntity entity2, AABB box) {
        List<LivingEntity> list = this.getEntitiesOfClass(clazz, box, entity -> true);
        ArrayList<LivingEntity> list2 = new ArrayList<LivingEntity>();
        for (LivingEntity livingEntity : list) {
            if (!targetPredicate.test(this.getLevel(), entity2, livingEntity)) continue;
            list2.add(livingEntity);
        }
        return list2;
    }
}

