/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ClientCredentialParameters;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IClientCertificate;
import com.microsoft.aad.msal4j.IClientCredential;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.ServerTextFilter;
import net.minecraft.util.GsonHelper;

public class PlayerSafetyServiceTextFilter
extends ServerTextFilter {
    private final ConfidentialClientApplication client;
    private final ClientCredentialParameters clientParameters;
    private final Set<String> fullyFilteredEvents;
    private final int connectionReadTimeoutMs;

    private PlayerSafetyServiceTextFilter(URL url, ServerTextFilter.MessageEncoder messageEncoder, ServerTextFilter.IgnoreStrategy hashIgnorer, ExecutorService threadPool, ConfidentialClientApplication application, ClientCredentialParameters credentialParameters, Set<String> fullyFilteredEvents, int readTimeout) {
        super(url, messageEncoder, hashIgnorer, threadPool);
        this.client = application;
        this.clientParameters = credentialParameters;
        this.fullyFilteredEvents = fullyFilteredEvents;
        this.connectionReadTimeoutMs = readTimeout;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static ServerTextFilter createTextFilterFromConfig(String response) {
        void confidentialClientApplication2;
        void uRL2;
        JsonObject jsonObject = GsonHelper.parse(response);
        URI uRI = URI.create(GsonHelper.getAsString(jsonObject, "apiServer"));
        String string = GsonHelper.getAsString(jsonObject, "apiPath");
        String string2 = GsonHelper.getAsString(jsonObject, "scope");
        String string3 = GsonHelper.getAsString(jsonObject, "serverId", "");
        String string4 = GsonHelper.getAsString(jsonObject, "applicationId");
        String string5 = GsonHelper.getAsString(jsonObject, "tenantId");
        String string6 = GsonHelper.getAsString(jsonObject, "roomId", "Java:Chat");
        String string7 = GsonHelper.getAsString(jsonObject, "certificatePath");
        String string8 = GsonHelper.getAsString(jsonObject, "certificatePassword", "");
        int i = GsonHelper.getAsInt(jsonObject, "hashesToDrop", -1);
        int j = GsonHelper.getAsInt(jsonObject, "maxConcurrentRequests", 7);
        JsonArray jsonArray = GsonHelper.getAsJsonArray(jsonObject, "fullyFilteredEvents");
        HashSet<String> set = new HashSet<String>();
        jsonArray.forEach(json -> set.add(GsonHelper.convertToString(json, "filteredEvent")));
        int k = GsonHelper.getAsInt(jsonObject, "connectionReadTimeoutMs", 2000);
        try {
            URL uRL = uRI.resolve(string).toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
        ServerTextFilter.MessageEncoder messageEncoder = (profile, message) -> {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("userId", profile.getId().toString());
            jsonObject.addProperty("userDisplayName", profile.getName());
            jsonObject.addProperty("server", string3);
            jsonObject.addProperty("room", string6);
            jsonObject.addProperty("area", "JavaChatRealms");
            jsonObject.addProperty("data", message);
            jsonObject.addProperty("language", "*");
            return jsonObject;
        };
        ServerTextFilter.IgnoreStrategy ignoreStrategy = ServerTextFilter.IgnoreStrategy.select(i);
        ExecutorService executorService = PlayerSafetyServiceTextFilter.createWorkerPool(j);
        try (InputStream inputStream = Files.newInputStream(Path.of(string7, new String[0]), new OpenOption[0]);){
            IClientCertificate iClientCertificate = ClientCredentialFactory.createFromCertificate((InputStream)inputStream, (String)string8);
        }
        catch (Exception exception) {
            ServerTextFilter.LOGGER.warn("Failed to open certificate file");
            return null;
        }
        try {
            void iClientCertificate3;
            ConfidentialClientApplication confidentialClientApplication = ((ConfidentialClientApplication.Builder)((ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)string4, (IClientCredential)iClientCertificate3).sendX5c(true).executorService(executorService)).authority(String.format(Locale.ROOT, "https://login.microsoftonline.com/%s/", string5))).build();
        }
        catch (Exception exception2) {
            ServerTextFilter.LOGGER.warn("Failed to create confidential client application");
            return null;
        }
        ClientCredentialParameters clientCredentialParameters = ClientCredentialParameters.builder(Set.of(string2)).build();
        return new PlayerSafetyServiceTextFilter((URL)uRL2, messageEncoder, ignoreStrategy, executorService, (ConfidentialClientApplication)confidentialClientApplication2, clientCredentialParameters, set, k);
    }

    private IAuthenticationResult aquireIAuthenticationResult() {
        return (IAuthenticationResult)this.client.acquireToken(this.clientParameters).join();
    }

    @Override
    @Override
    protected void setAuthorizationProperty(HttpURLConnection connection) {
        IAuthenticationResult iAuthenticationResult = this.aquireIAuthenticationResult();
        connection.setRequestProperty("Authorization", "Bearer " + iAuthenticationResult.accessToken());
    }

    @Override
    @Override
    protected FilteredText filterText(String raw, ServerTextFilter.IgnoreStrategy hashIgnorer, JsonObject response) {
        JsonObject jsonObject = GsonHelper.getAsJsonObject(response, "result", null);
        if (jsonObject == null) {
            return FilteredText.fullyFiltered(raw);
        }
        boolean bl = GsonHelper.getAsBoolean(jsonObject, "filtered", true);
        if (!bl) {
            return FilteredText.passThrough(raw);
        }
        JsonArray jsonArray = GsonHelper.getAsJsonArray(jsonObject, "events", new JsonArray());
        for (JsonElement jsonElement : jsonArray) {
            JsonObject jsonObject2 = jsonElement.getAsJsonObject();
            String string = GsonHelper.getAsString(jsonObject2, "id", "");
            if (!this.fullyFilteredEvents.contains(string)) continue;
            return FilteredText.fullyFiltered(raw);
        }
        JsonArray jsonArray2 = GsonHelper.getAsJsonArray(jsonObject, "redactedTextIndex", new JsonArray());
        return new FilteredText(raw, this.parseMask(raw, jsonArray2, hashIgnorer));
    }

    @Override
    @Override
    protected int connectionReadTimeout() {
        return this.connectionReadTimeoutMs;
    }
}

