/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.network.chat.FilterMask;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.LegacyTextFilter;
import net.minecraft.server.network.PlayerSafetyServiceTextFilter;
import net.minecraft.server.network.TextFilter;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.StringUtil;
import net.minecraft.util.thread.ConsecutiveExecutor;
import org.slf4j.Logger;

public abstract class ServerTextFilter
implements AutoCloseable {
    protected static final Logger LOGGER = LogUtils.getLogger();
    private static final AtomicInteger WORKER_COUNT = new AtomicInteger(1);
    private static final ThreadFactory THREAD_FACTORY = runnable -> {
        Thread thread = new Thread(runnable);
        thread.setName("Chat-Filter-Worker-" + WORKER_COUNT.getAndIncrement());
        return thread;
    };
    private final URL chatEndpoint;
    private final MessageEncoder chatEncoder;
    final IgnoreStrategy chatIgnoreStrategy;
    final ExecutorService workerPool;

    protected static ExecutorService createWorkerPool(int threadCount) {
        return Executors.newFixedThreadPool(threadCount, THREAD_FACTORY);
    }

    protected ServerTextFilter(URL url, MessageEncoder messageEncoder, IgnoreStrategy hashIgnorer, ExecutorService threadPool) {
        this.chatIgnoreStrategy = hashIgnorer;
        this.workerPool = threadPool;
        this.chatEndpoint = url;
        this.chatEncoder = messageEncoder;
    }

    protected static URL getEndpoint(URI uri, @Nullable JsonObject endpoints, String key, String defaultPath) throws MalformedURLException {
        String string = ServerTextFilter.getEndpointFromConfig(endpoints, key, defaultPath);
        return uri.resolve("/" + string).toURL();
    }

    protected static String getEndpointFromConfig(@Nullable JsonObject endpoints, String key, String defaultPath) {
        return endpoints != null ? GsonHelper.getAsString(endpoints, key, defaultPath) : defaultPath;
    }

    @Nullable
    public static ServerTextFilter createFromConfig(DedicatedServerProperties properties) {
        String string = properties.textFilteringConfig;
        if (StringUtil.isBlank(string)) {
            return null;
        }
        return switch (properties.textFilteringVersion) {
            case 0 -> LegacyTextFilter.createTextFilterFromConfig(string);
            case 1 -> PlayerSafetyServiceTextFilter.createTextFilterFromConfig(string);
            default -> {
                LOGGER.warn("Could not create text filter - unsupported text filtering version used");
                yield null;
            }
        };
    }

    protected CompletableFuture<FilteredText> requestMessageProcessing(GameProfile profile, String raw, IgnoreStrategy hashIgnorer, Executor executor) {
        if (raw.isEmpty()) {
            return CompletableFuture.completedFuture(FilteredText.EMPTY);
        }
        return CompletableFuture.supplyAsync(() -> {
            JsonObject jsonObject = this.chatEncoder.encode(profile, raw);
            try {
                JsonObject jsonObject2 = this.processRequestResponse(jsonObject, this.chatEndpoint);
                return this.filterText(raw, hashIgnorer, jsonObject2);
            }
            catch (Exception exception) {
                LOGGER.warn("Failed to validate message '{}'", (Object)raw, (Object)exception);
                return FilteredText.fullyFiltered(raw);
            }
        }, executor);
    }

    protected abstract FilteredText filterText(String var1, IgnoreStrategy var2, JsonObject var3);

    protected FilterMask parseMask(String raw, JsonArray redactedTextIndex, IgnoreStrategy hashIgnorer) {
        if (redactedTextIndex.isEmpty()) {
            return FilterMask.PASS_THROUGH;
        }
        if (hashIgnorer.shouldIgnore(raw, redactedTextIndex.size())) {
            return FilterMask.FULLY_FILTERED;
        }
        FilterMask filterMask = new FilterMask(raw.length());
        for (int i = 0; i < redactedTextIndex.size(); ++i) {
            filterMask.setFiltered(redactedTextIndex.get(i).getAsInt());
        }
        return filterMask;
    }

    @Override
    @Override
    public void close() {
        this.workerPool.shutdownNow();
    }

    protected void drainStream(InputStream stream) throws IOException {
        byte[] bs = new byte[1024];
        while (stream.read(bs) != -1) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonObject processRequestResponse(JsonObject request, URL url) throws IOException {
        HttpURLConnection httpURLConnection = this.makeRequest(request, url);
        try (InputStream inputStream = httpURLConnection.getInputStream();){
            JsonObject jsonObject;
            if (httpURLConnection.getResponseCode() == 204) {
                JsonObject jsonObject2 = new JsonObject();
                return jsonObject2;
            }
            try {
                jsonObject = Streams.parse((JsonReader)new JsonReader((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8))).getAsJsonObject();
            }
            catch (Throwable throwable) {
                this.drainStream(inputStream);
                throw throwable;
            }
            this.drainStream(inputStream);
            return jsonObject;
        }
    }

    protected HttpURLConnection makeRequest(JsonObject request, URL url) throws IOException {
        HttpURLConnection httpURLConnection = this.getURLConnection(url);
        this.setAuthorizationProperty(httpURLConnection);
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(httpURLConnection.getOutputStream(), StandardCharsets.UTF_8);
             JsonWriter jsonWriter = new JsonWriter((Writer)outputStreamWriter);){
            Streams.write((JsonElement)request, (JsonWriter)jsonWriter);
        }
        int i = httpURLConnection.getResponseCode();
        if (i < 200 || i >= 300) {
            throw new RequestFailedException(i + " " + httpURLConnection.getResponseMessage());
        }
        return httpURLConnection;
    }

    protected abstract void setAuthorizationProperty(HttpURLConnection var1);

    protected int connectionReadTimeout() {
        return 2000;
    }

    protected HttpURLConnection getURLConnection(URL url) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
        httpURLConnection.setConnectTimeout(15000);
        httpURLConnection.setReadTimeout(this.connectionReadTimeout());
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        httpURLConnection.setRequestProperty("Accept", "application/json");
        httpURLConnection.setRequestProperty("User-Agent", "Minecraft server" + SharedConstants.getCurrentVersion().getName());
        return httpURLConnection;
    }

    public TextFilter createContext(GameProfile profile) {
        return new PlayerContext(profile);
    }

    @FunctionalInterface
    public static interface IgnoreStrategy {
        public static final IgnoreStrategy NEVER_IGNORE = (hashes, hashesSize) -> false;
        public static final IgnoreStrategy IGNORE_FULLY_FILTERED = (hashes, hashesSize) -> hashes.length() == hashesSize;

        public static IgnoreStrategy ignoreOverThreshold(int hashesToDrop) {
            return (hashes, hashesSize) -> hashesSize >= hashesToDrop;
        }

        public static IgnoreStrategy select(int hashesToDrop) {
            return switch (hashesToDrop) {
                case -1 -> NEVER_IGNORE;
                case 0 -> IGNORE_FULLY_FILTERED;
                default -> IgnoreStrategy.ignoreOverThreshold(hashesToDrop);
            };
        }

        public boolean shouldIgnore(String var1, int var2);
    }

    @FunctionalInterface
    protected static interface MessageEncoder {
        public JsonObject encode(GameProfile var1, String var2);
    }

    protected static class RequestFailedException
    extends RuntimeException {
        protected RequestFailedException(String message) {
            super(message);
        }
    }

    protected class PlayerContext
    implements TextFilter {
        protected final GameProfile profile;
        protected final Executor streamExecutor;

        protected PlayerContext(GameProfile gameProfile) {
            this.profile = gameProfile;
            ConsecutiveExecutor consecutiveExecutor = new ConsecutiveExecutor(ServerTextFilter.this.workerPool, "chat stream for " + gameProfile.getName());
            this.streamExecutor = consecutiveExecutor::schedule;
        }

        @Override
        @Override
        public CompletableFuture<List<FilteredText>> processMessageBundle(List<String> texts) {
            List list = (List)texts.stream().map(text -> ServerTextFilter.this.requestMessageProcessing(this.profile, (String)text, ServerTextFilter.this.chatIgnoreStrategy, this.streamExecutor)).collect(ImmutableList.toImmutableList());
            return Util.sequenceFailFast(list).exceptionally(throwable -> ImmutableList.of());
        }

        @Override
        @Override
        public CompletableFuture<FilteredText> processStreamMessage(String text) {
            return ServerTextFilter.this.requestMessageProcessing(this.profile, text, ServerTextFilter.this.chatIgnoreStrategy, this.streamExecutor);
        }
    }
}

