/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.Util;
import net.minecraft.core.UUIDUtil;
import net.minecraft.server.packs.DownloadCacheCleaner;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.HttpUtil;
import net.minecraft.util.eventlog.JsonEventLog;
import net.minecraft.util.thread.ConsecutiveExecutor;
import org.slf4j.Logger;

public class DownloadQueue
implements AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int MAX_KEPT_PACKS = 20;
    private final Path cacheDir;
    private final JsonEventLog<LogEntry> eventLog;
    private final ConsecutiveExecutor tasks = new ConsecutiveExecutor(Util.nonCriticalIoPool(), "download-queue");

    public DownloadQueue(Path directory) throws IOException {
        this.cacheDir = directory;
        FileUtil.createDirectoriesSafe(directory);
        this.eventLog = JsonEventLog.open(LogEntry.CODEC, directory.resolve("log.json"));
        DownloadCacheCleaner.vacuumCacheDir(directory, 20);
    }

    private BatchResult runDownload(BatchConfig config, Map<UUID, DownloadRequest> entries) {
        BatchResult batchResult = new BatchResult();
        entries.forEach((id, entry) -> {
            Path path = this.cacheDir.resolve(id.toString());
            Path path2 = null;
            try {
                path2 = HttpUtil.downloadFile(path, entry.url, batchConfig.headers, batchConfig.hashFunction, entry.hash, batchConfig.maxSize, batchConfig.proxy, batchConfig.listener);
                batchResult.downloaded.put((UUID)id, path2);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to download {}", (Object)entry.url, (Object)exception);
                batchResult.failed.add((UUID)id);
            }
            try {
                this.eventLog.write(new LogEntry((UUID)id, entry.url.toString(), Instant.now(), Optional.ofNullable(entry.hash).map(HashCode::toString), path2 != null ? this.getFileInfo(path2) : Either.left("download_failed")));
            }
            catch (Exception exception2) {
                LOGGER.error("Failed to log download of {}", (Object)entry.url, (Object)exception2);
            }
        });
        return batchResult;
    }

    private Either<String, FileInfoEntry> getFileInfo(Path path) {
        try {
            long l = Files.size(path);
            Path path2 = this.cacheDir.relativize(path);
            return Either.right(new FileInfoEntry(path2.toString(), l));
        }
        catch (IOException iOException) {
            LOGGER.error("Failed to get file size of {}", (Object)path, (Object)iOException);
            return Either.left("no_access");
        }
    }

    public CompletableFuture<BatchResult> downloadBatch(BatchConfig config, Map<UUID, DownloadRequest> entries) {
        return CompletableFuture.supplyAsync(() -> this.runDownload(config, entries), this.tasks::schedule);
    }

    @Override
    @Override
    public void close() throws IOException {
        this.tasks.close();
        this.eventLog.close();
    }

    record LogEntry(UUID id, String url, Instant time, Optional<String> hash, Either<String, FileInfoEntry> errorOrFileInfo) {
        public static final Codec<LogEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.STRING_CODEC.fieldOf("id").forGetter(LogEntry::id), (App)Codec.STRING.fieldOf("url").forGetter(LogEntry::url), (App)ExtraCodecs.INSTANT_ISO8601.fieldOf("time").forGetter(LogEntry::time), (App)Codec.STRING.optionalFieldOf("hash").forGetter(LogEntry::hash), (App)Codec.mapEither((MapCodec)Codec.STRING.fieldOf("error"), (MapCodec)FileInfoEntry.CODEC.fieldOf("file")).forGetter(LogEntry::errorOrFileInfo)).apply((Applicative)instance, LogEntry::new));
    }

    public record BatchResult(Map<UUID, Path> downloaded, Set<UUID> failed) {
        public BatchResult() {
            this(new HashMap<UUID, Path>(), new HashSet<UUID>());
        }
    }

    public record BatchConfig(HashFunction hashFunction, int maxSize, Map<String, String> headers, Proxy proxy, HttpUtil.DownloadProgressListener listener) {
    }

    record FileInfoEntry(String name, long size) {
        public static final Codec<FileInfoEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(FileInfoEntry::name), (App)Codec.LONG.fieldOf("size").forGetter(FileInfoEntry::size)).apply((Applicative)instance, FileInfoEntry::new));
    }

    public record DownloadRequest(URL url, @Nullable HashCode hash) {
    }
}

