/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.util.Objects;
import net.minecraft.server.players.ServerOpListEntry;
import net.minecraft.server.players.StoredUserEntry;
import net.minecraft.server.players.StoredUserList;

public class ServerOpList
extends StoredUserList<GameProfile, ServerOpListEntry> {
    public ServerOpList(File file) {
        super(file);
    }

    @Override
    @Override
    protected StoredUserEntry<GameProfile> createEntry(JsonObject json) {
        return new ServerOpListEntry(json);
    }

    @Override
    @Override
    public String[] getUserList() {
        return (String[])this.getEntries().stream().map(StoredUserEntry::getUser).filter(Objects::nonNull).map(GameProfile::getName).toArray(String[]::new);
    }

    public boolean canBypassPlayerLimit(GameProfile profile) {
        ServerOpListEntry serverOpListEntry = (ServerOpListEntry)this.get(profile);
        if (serverOpListEntry != null) {
            return serverOpListEntry.getBypassesPlayerLimit();
        }
        return false;
    }

    @Override
    @Override
    protected String getKeyForUser(GameProfile gameProfile) {
        return gameProfile.getId().toString();
    }

    @Override
    protected /* synthetic */ String getKeyForUser(Object profile) {
        return this.getKeyForUser((GameProfile)profile);
    }
}

