/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.ResourceLocationException;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.protocol.game.ClientboundRecipeBookAddPacket;
import net.minecraft.network.protocol.game.ClientboundRecipeBookRemovePacket;
import net.minecraft.network.protocol.game.ClientboundRecipeBookSettingsPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.RecipeBook;
import net.minecraft.stats.RecipeBookSettings;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.slf4j.Logger;

public class ServerRecipeBook
extends RecipeBook {
    public static final String RECIPE_BOOK_TAG = "recipeBook";
    private static final Logger LOGGER = LogUtils.getLogger();
    private final DisplayResolver displayResolver;
    @VisibleForTesting
    public final Set<ResourceKey<Recipe<?>>> known = Sets.newIdentityHashSet();
    @VisibleForTesting
    protected final Set<ResourceKey<Recipe<?>>> highlight = Sets.newIdentityHashSet();

    public ServerRecipeBook(DisplayResolver collector) {
        this.displayResolver = collector;
    }

    public void add(ResourceKey<Recipe<?>> recipeKey) {
        this.known.add(recipeKey);
    }

    public boolean contains(ResourceKey<Recipe<?>> recipeKey) {
        return this.known.contains(recipeKey);
    }

    public void remove(ResourceKey<Recipe<?>> recipeKey) {
        this.known.remove(recipeKey);
        this.highlight.remove(recipeKey);
    }

    public void removeHighlight(ResourceKey<Recipe<?>> recipeKey) {
        this.highlight.remove(recipeKey);
    }

    private void addHighlight(ResourceKey<Recipe<?>> recipeKey) {
        this.highlight.add(recipeKey);
    }

    public int addRecipes(Collection<RecipeHolder<?>> recipes, ServerPlayer player) {
        ArrayList<ClientboundRecipeBookAddPacket.Entry> list = new ArrayList<ClientboundRecipeBookAddPacket.Entry>();
        for (RecipeHolder<?> recipeholder : recipes) {
            ResourceKey<Recipe<?>> resourcekey = recipeholder.id();
            if (this.known.contains(resourcekey) || recipeholder.value().isSpecial() || !CraftEventFactory.handlePlayerRecipeListUpdateEvent(player, resourcekey.location())) continue;
            this.add(resourcekey);
            this.addHighlight(resourcekey);
            this.displayResolver.displaysForRecipe(resourcekey, recipedisplayentry -> list.add(new ClientboundRecipeBookAddPacket.Entry((RecipeDisplayEntry)recipedisplayentry, recipeholder.value().showNotification(), true)));
            CriteriaTriggers.RECIPE_UNLOCKED.trigger(player, recipeholder);
        }
        if (!list.isEmpty() && player.connection != null) {
            player.connection.send(new ClientboundRecipeBookAddPacket(list, false));
        }
        return list.size();
    }

    public int removeRecipes(Collection<RecipeHolder<?>> recipes, ServerPlayer player) {
        ArrayList list = Lists.newArrayList();
        for (RecipeHolder<?> recipeholder : recipes) {
            ResourceKey<Recipe<?>> resourcekey = recipeholder.id();
            if (!this.known.contains(resourcekey)) continue;
            this.remove(resourcekey);
            this.displayResolver.displaysForRecipe(resourcekey, recipedisplayentry -> list.add(recipedisplayentry.id()));
        }
        if (!list.isEmpty() && player.connection != null) {
            player.connection.send(new ClientboundRecipeBookRemovePacket(list));
        }
        return list.size();
    }

    public CompoundTag toNbt() {
        CompoundTag nbttagcompound = new CompoundTag();
        this.getBookSettings().write(nbttagcompound);
        ListTag nbttaglist = new ListTag();
        for (ResourceKey<Recipe<?>> resourcekey : this.known) {
            nbttaglist.add(StringTag.valueOf(resourcekey.location().toString()));
        }
        nbttagcompound.put("recipes", nbttaglist);
        ListTag nbttaglist1 = new ListTag();
        for (ResourceKey<Recipe<?>> resourcekey1 : this.highlight) {
            nbttaglist1.add(StringTag.valueOf(resourcekey1.location().toString()));
        }
        nbttagcompound.put("toBeDisplayed", nbttaglist1);
        return nbttagcompound;
    }

    public void fromNbt(CompoundTag nbt, Predicate<ResourceKey<Recipe<?>>> validPredicate) {
        this.setBookSettings(RecipeBookSettings.read(nbt));
        ListTag nbttaglist = nbt.getList("recipes", 8);
        this.loadRecipes(nbttaglist, this::add, validPredicate);
        ListTag nbttaglist1 = nbt.getList("toBeDisplayed", 8);
        this.loadRecipes(nbttaglist1, this::addHighlight, validPredicate);
    }

    private void loadRecipes(ListTag list, Consumer<ResourceKey<Recipe<?>>> handler, Predicate<ResourceKey<Recipe<?>>> validPredicate) {
        for (int i = 0; i < list.size(); ++i) {
            String s = list.getString(i);
            try {
                ResourceKey<Recipe<?>> resourcekey = ResourceKey.create(Registries.RECIPE, ResourceLocation.parse(s));
                if (!validPredicate.test(resourcekey)) {
                    LOGGER.error("Tried to load unrecognized recipe: {} removed now.", resourcekey);
                    continue;
                }
                handler.accept(resourcekey);
                continue;
            }
            catch (ResourceLocationException resourcekeyinvalidexception) {
                LOGGER.error("Tried to load improperly formatted recipe: {} removed now.", (Object)s);
            }
        }
    }

    public void sendInitialRecipeBook(ServerPlayer player) {
        player.connection.send(new ClientboundRecipeBookSettingsPacket(this.getBookSettings()));
        ArrayList<ClientboundRecipeBookAddPacket.Entry> list = new ArrayList<ClientboundRecipeBookAddPacket.Entry>(this.known.size());
        for (ResourceKey<Recipe<?>> resourcekey : this.known) {
            this.displayResolver.displaysForRecipe(resourcekey, recipedisplayentry -> list.add(new ClientboundRecipeBookAddPacket.Entry((RecipeDisplayEntry)recipedisplayentry, false, this.highlight.contains(resourcekey))));
        }
        player.connection.send(new ClientboundRecipeBookAddPacket(list, true));
    }

    public void copyOverData(ServerRecipeBook recipeBook) {
        this.known.clear();
        this.highlight.clear();
        this.bookSettings.replaceFrom(recipeBook.bookSettings);
        this.known.addAll(recipeBook.known);
        this.highlight.addAll(recipeBook.highlight);
    }

    @FunctionalInterface
    public static interface DisplayResolver {
        public void displaysForRecipe(ResourceKey<Recipe<?>> var1, Consumer<RecipeDisplayEntry> var2);
    }
}

